/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.util;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.data.PanelAction;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;

public class UserPathPanelVariable
implements PanelAction {
    private static final String userPathPanelKey = "UserPathPanelVariable";
    private static final String previousUserPathPanelKey = "APPDATA_PATH";

    @Override
    public void executeAction(InstallData idata, AbstractUIHandler ah) {
        block13: {
            String userPathPanelVariable = idata.getVariable(userPathPanelKey);
            String previousUserPathPanelVariable = idata.getVariable(previousUserPathPanelKey);
            String installMode = idata.getVariable("installMode");
            if (previousUserPathPanelVariable == null || previousUserPathPanelVariable.isEmpty()) {
                if (userPathPanelVariable == null || userPathPanelVariable.isEmpty()) {
                    StringBuilder s = new StringBuilder();
                    s = s.append(idata.getVariable("CommonAppData")).append(File.separator);
                    s = s.append("sos-berlin.com").append(File.separator);
                    s = s.append("js7").append(File.separator);
                    s = s.append(installMode);
                    if ("agent".equals(installMode)) {
                        s = s.append("_").append(idata.getVariable("agentPort"));
                    }
                    idata.setVariable(userPathPanelKey, s.toString());
                }
            } else if ("agent".equals(installMode)) {
                if (!previousUserPathPanelVariable.endsWith(idata.getVariable("agentPort"))) {
                    idata.setVariable(userPathPanelKey, previousUserPathPanelVariable.replaceFirst("\\d{1,5}$", idata.getVariable("agentPort")));
                } else {
                    idata.setVariable(userPathPanelKey, previousUserPathPanelVariable);
                }
            } else if (installMode.contains("controller")) {
                try {
                    Path parentDir = Paths.get(previousUserPathPanelVariable, new String[0]).getParent();
                    if (parentDir != null) {
                        idata.setVariable(userPathPanelKey, parentDir.toString());
                        break block13;
                    }
                    idata.setVariable(userPathPanelKey, previousUserPathPanelVariable);
                }
                catch (Exception e) {
                    idata.setVariable(userPathPanelKey, previousUserPathPanelVariable);
                }
            } else {
                idata.setVariable(userPathPanelKey, previousUserPathPanelVariable);
            }
        }
    }

    @Override
    public void initialize(PanelActionConfiguration arg0) {
    }
}

