/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.process;

import com.sos.izpack.process.ProcessHelper;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;

public class SecurityLevel
extends ProcessHelper {
    private static final String JOC_WAR_FILE_NAME = "joc.war";
    private static final String JOC_SETTINGS_FILE_NAME = "joc-settings.properties";
    private static final String groupIdPrefix = "com.sos-berlin.";

    @Override
    public boolean run(String[] args) throws Exception {
        try {
            this.writeHeader("Set Security Level: " + this.idata.getVariable("securityLevel"));
            Path jettyBase = Paths.get(this.idata.getVariable("APPDATA_PATH"), new String[0]);
            Path webApps = jettyBase.resolve("webapps");
            Path webInf = webApps.resolve("joc/WEB-INF");
            Path srcSettingsFile = jettyBase.resolve("resources/joc-settings.properties");
            Path jocWar = webApps.resolve(JOC_WAR_FILE_NAME);
            FileSystem warFileSystem = null;
            if (Files.exists(jocWar, new LinkOption[0]) && !Files.exists(webInf, new LinkOption[0])) {
                warFileSystem = FileSystems.newFileSystem(jocWar, (ClassLoader)null);
            }
            try {
                String version = this.idata.getInfo().getAppVersion();
                Path libDir = warFileSystem == null ? webInf.resolve("lib") : warFileSystem.getPath("WEB-INF", "lib");
                switch (this.idata.getVariable("securityLevel").toUpperCase()) {
                    case "HIGH": {
                        Files.deleteIfExists(libDir.resolve("sos-webservices-publish-medium-" + version + ".jar"));
                        Files.deleteIfExists(libDir.resolve("sos-webservices-publish-low-" + version + ".jar"));
                        Files.deleteIfExists(libDir.resolve("com.sos-berlin.sos-webservices-publish-medium-" + version + ".jar"));
                        Files.deleteIfExists(libDir.resolve("com.sos-berlin.sos-webservices-publish-low-" + version + ".jar"));
                        break;
                    }
                    case "MEDIUM": {
                        Files.deleteIfExists(libDir.resolve("sos-webservices-publish-high-" + version + ".jar"));
                        Files.deleteIfExists(libDir.resolve("sos-webservices-publish-low-" + version + ".jar"));
                        Files.deleteIfExists(libDir.resolve("com.sos-berlin.sos-webservices-publish-high-" + version + ".jar"));
                        Files.deleteIfExists(libDir.resolve("com.sos-berlin.sos-webservices-publish-low-" + version + ".jar"));
                        break;
                    }
                    default: {
                        Files.deleteIfExists(libDir.resolve("sos-webservices-publish-high-" + version + ".jar"));
                        Files.deleteIfExists(libDir.resolve("sos-webservices-publish-medium-" + version + ".jar"));
                        Files.deleteIfExists(libDir.resolve("com.sos-berlin.sos-webservices-publish-high-" + version + ".jar"));
                        Files.deleteIfExists(libDir.resolve("com.sos-berlin.sos-webservices-publish-medium-" + version + ".jar"));
                    }
                }
                Path classesDir = warFileSystem == null ? webInf.resolve("classes") : warFileSystem.getPath("WEB-INF", "classes");
                Files.move(srcSettingsFile, classesDir.resolve(JOC_SETTINGS_FILE_NAME), StandardCopyOption.REPLACE_EXISTING);
                this.log("... done", new Object[0]);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (warFileSystem != null && warFileSystem.isOpen()) {
                    try {
                        warFileSystem.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            this.log("... failed", new Object[0]);
            this.log(e);
        }
        return true;
    }
}

