/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.util;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import java.util.regex.Pattern;

public class SchedulerIdValidator
implements DataValidator {
    @Override
    public DataValidator.Status validateData(InstallData idata) {
        if ("controller".equals(idata.getVariable("installMode"))) {
            Pattern pattern = Pattern.compile("[^/\\\\:;*?!&\"<>()|^]+");
            String id = idata.getVariable("controllerId");
            if (id == null || id.isEmpty()) {
                System.out.println("Controller ID is missing");
                return DataValidator.Status.ERROR;
            }
            if (!pattern.matcher(id).matches()) {
                System.out.println(String.format("Invalid special characters in Controller ID. Please omit:\n%1$s", "/ \\ : ; * ? ! & \" < > ( ) | ^"));
                return DataValidator.Status.ERROR;
            }
        }
        return DataValidator.Status.OK;
    }

    @Override
    public String getErrorMessageId() {
        return "service.id.valid";
    }

    @Override
    public String getWarningMessageId() {
        return "service.id.valid";
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }
}

