/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.util;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.data.PanelAction;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;

public class SetLogPidFileAndWorkDirectory
implements PanelAction {
    @Override
    public void executeAction(InstallData idata, AbstractUIHandler ah) {
        String logPath = idata.getVariable("logPath");
        String pidFilePath = idata.getVariable("pidFilePath");
        String configPath = idata.getVariable("configFilePath");
        String workPath = idata.getVariable("workPath");
        String javaHome = idata.getVariable("javaHome");
        if (logPath == null) {
            logPath = "";
        }
        if (configPath == null) {
            configPath = "";
        }
        if (pidFilePath == null) {
            pidFilePath = "";
        }
        if (workPath == null) {
            workPath = "";
        }
        if (javaHome == null) {
            javaHome = "";
        }
        try {
            String workDir = Paths.get("", new String[0]).toRealPath(new LinkOption[0]).toString();
            logPath = this.cutWorkingDir(logPath, workDir);
            configPath = this.cutWorkingDir(configPath, workDir);
            pidFilePath = this.cutWorkingDir(pidFilePath, workDir);
            workPath = this.cutWorkingDir(workPath, workDir);
            javaHome = this.cutWorkingDir(javaHome, workDir);
            if (logPath.equalsIgnoreCase(pidFilePath)) {
                pidFilePath = "";
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        idata.setVariable("pidFilePath", pidFilePath);
        idata.setVariable("configPath", configPath);
        idata.setVariable("logPath", logPath);
        idata.setVariable("workPath", workPath);
        idata.setVariable("javaHome", javaHome);
    }

    @Override
    public void initialize(PanelActionConfiguration pac) {
    }

    private String cutWorkingDir(String path, String workDir) {
        if (workDir.equalsIgnoreCase(path)) {
            return "";
        }
        if (path.toLowerCase().startsWith(workDir.toLowerCase() + File.separator + "%")) {
            path = path.substring(workDir.length() + 1);
        }
        if (path.toLowerCase().startsWith(workDir.toLowerCase() + "%")) {
            path = path.substring(workDir.length());
        }
        return path;
    }
}

