/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.util;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.izforge.izpack.util.OsVersion;
import com.sos.izpack.process.ProcessHelper;
import java.nio.file.attribute.UserPrincipal;

public class WindowsAccountValidator
implements DataValidator {
    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getErrorMessageId() {
        return "windows.account.validation.error";
    }

    @Override
    public String getWarningMessageId() {
        return "windows.account.validation.error";
    }

    @Override
    public DataValidator.Status validateData(InstallData idata) {
        if (!OsVersion.IS_WINDOWS) {
            return DataValidator.Status.OK;
        }
        try {
            UserPrincipal principal = ProcessHelper.getWindowsAccount(idata.getVariable("serviceAccount"), idata.getVariable("HOST_NAME"));
            idata.setVariable("validServiceAccount", principal == null ? "" : principal.getName());
        }
        catch (Exception e) {
            return DataValidator.Status.ERROR;
        }
        return DataValidator.Status.OK;
    }
}

