/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlInfo {
    private XPath xPath = null;
    private Document dom = null;

    public XmlInfo() {
    }

    public Document getDom() {
        return this.dom;
    }

    public XmlInfo(String path) throws ParserConfigurationException, SAXException, IOException {
        this.init(path);
    }

    public XmlInfo(File confFile) throws ParserConfigurationException, SAXException, IOException {
        this.init(confFile);
    }

    public XmlInfo(Path confFile) throws ParserConfigurationException, SAXException, IOException {
        this.init(confFile.toFile());
    }

    public void init(File confFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbf.setIgnoringElementContentWhitespace(true);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        this.xPath = XPathFactory.newInstance().newXPath();
        this.dom = builder.parse(confFile);
        this.deleteWhitespaceNode(this.dom.getDocumentElement());
    }

    public void init(String path) throws ParserConfigurationException, SAXException, IOException {
        this.init(new File(path));
    }

    public Map<String, String> getDBConfiguration() throws XPathExpressionException {
        NodeList hibernateProperties = this.getNodeList("hibernate-configuration/session-factory/property");
        HashMap<String, String> dbConf = new HashMap<String, String>();
        block18: for (int i = 0; i < hibernateProperties.getLength(); ++i) {
            Element prop = (Element)hibernateProperties.item(i);
            switch (prop.getAttribute("name")) {
                case "hibernate.connection.driver_class": 
                case "jakarta.persistence.jdbc.driver": {
                    dbConf.put("class", prop.getNodeValue());
                    continue block18;
                }
                case "hibernate.connection.password": 
                case "jakarta.persistence.jdbc.password": {
                    dbConf.put("password", prop.getNodeValue());
                    continue block18;
                }
                case "hibernate.connection.url": 
                case "jakarta.persistence.jdbc.url": {
                    dbConf.put("url", prop.getNodeValue());
                    continue block18;
                }
                case "hibernate.connection.username": 
                case "jakarta.persistence.jdbc.user": {
                    dbConf.put("user", prop.getNodeValue());
                    continue block18;
                }
                case "hibernate.dialect": {
                    dbConf.put("dialect", prop.getNodeValue());
                }
            }
        }
        return dbConf;
    }

    public boolean hasC3P0Configuration() throws XPathExpressionException {
        NodeList hibernateProperties = this.getNodeList("hibernate-configuration/session-factory/property");
        for (int i = 0; i < hibernateProperties.getLength(); ++i) {
            Element prop = (Element)hibernateProperties.item(i);
            if (!prop.getAttribute("name").startsWith("hibernate.c3p0.")) continue;
            return true;
        }
        return false;
    }

    public Element getCredentialStoreLocation() throws XPathExpressionException {
        return this.getHibernateElement("sos.credential_store_file");
    }

    public Element getDBDriverClass() throws XPathExpressionException {
        Element elem = this.getHibernateElement("connection.driver_class");
        if (elem == null) {
            elem = this.getJakartaPersistenceJdbcElement("driver");
        }
        return elem;
    }

    public Element getDBUser() throws XPathExpressionException {
        Element elem = this.getHibernateElement("connection.username");
        if (elem == null) {
            elem = this.getJakartaPersistenceJdbcElement("user");
        }
        return elem;
    }

    public Element getDBPassword() throws XPathExpressionException {
        Element elem = this.getHibernateElement("connection.password");
        if (elem == null) {
            elem = this.getJakartaPersistenceJdbcElement("password");
        }
        return elem;
    }

    public Element getDBUrl() throws XPathExpressionException {
        Element elem = this.getHibernateElement("connection.url");
        if (elem == null) {
            elem = this.getJakartaPersistenceJdbcElement("url");
        }
        return elem;
    }

    public Element getDBDialect() throws XPathExpressionException {
        return this.getHibernateElement("dialect");
    }

    public String getDbmsFromHibernateConf() throws XPathExpressionException {
        String dbms = "";
        Element elem = this.getDBUrl();
        if (elem != null && (dbms = this.getDbms(elem.getTextContent().toLowerCase().replaceFirst("^.*:(h2|mariadb|mysql|oracle|postgres(?:ql)?|sqlserver):.*$", "$1"))).isEmpty() && (elem = this.getElement("/hibernate-configuration/session-factory/property[@name='hibernate.sos.dbms_product']")) != null && (dbms = this.getDbms(elem.getTextContent().toLowerCase().replaceFirst("^.*(h2|mariadb|mysql|oracle|pgsql|mssql).*$", "$1"))).isEmpty() && (elem = this.getDBDialect()) != null) {
            dbms = this.getDbms(elem.getTextContent().toLowerCase().replaceFirst("^.*(h2|mariadb|mysql|oracle|postgres(?:ql)?|sqlserver).*$", "$1"));
        }
        return dbms;
    }

    private String getDbms(String dbms) {
        if (dbms == null) {
            return "";
        }
        switch (dbms) {
            case "mssql": 
            case "sqlserver": {
                return "mssql";
            }
            case "pgsql": 
            case "postgres": 
            case "postgresql": {
                return "pgsql";
            }
            case "mysql": 
            case "mariadb": {
                return "mysql";
            }
            case "h2": 
            case "oracle": {
                return dbms;
            }
        }
        return "";
    }

    public Element getHibernateElement(String name) throws XPathExpressionException {
        return this.getElement("/hibernate-configuration/session-factory/property[@name='hibernate." + name + "']");
    }

    public Element getJakartaPersistenceJdbcElement(String name) throws XPathExpressionException {
        return this.getElement("/hibernate-configuration/session-factory/property[@name='jakarta.persistence.jdbc." + name + "']");
    }

    public void deleteC3p0Elements() throws XPathExpressionException {
        Element parentElem = this.getElement("/hibernate-configuration/session-factory");
        NodeList hibernateProperties = this.getNodeList("hibernate-configuration/session-factory/property");
        ArrayList<Element> c3p0Nodes = new ArrayList<Element>();
        for (int i = 0; i < hibernateProperties.getLength(); ++i) {
            Element prop = (Element)hibernateProperties.item(i);
            if (!prop.getAttribute("name").startsWith("hibernate.c3p0.")) continue;
            c3p0Nodes.add(prop);
        }
        c3p0Nodes.forEach(e -> parentElem.removeChild((Node)e));
    }

    public void commentOutC3p0Elements() throws XPathExpressionException {
        if (this.hasC3P0Configuration()) {
            Element parentElem = this.getElement("/hibernate-configuration/session-factory");
            this.addHibernateComment(" c3p0 Connection Pool ", parentElem);
            NodeList hibernateProperties = this.getNodeList("hibernate-configuration/session-factory/property");
            ArrayList<Element> c3p0Nodes = new ArrayList<Element>();
            for (int i = 0; i < hibernateProperties.getLength(); ++i) {
                Element prop = (Element)hibernateProperties.item(i);
                if (!prop.getAttribute("name").startsWith("hibernate.c3p0.")) continue;
                c3p0Nodes.add(prop);
            }
            c3p0Nodes.forEach(e -> this.commentOutC3p0Element((Element)e, parentElem));
        }
    }

    public void commentOutC3p0Element(Element e, Node parent) {
        try {
            String s = String.format(" <property name=\"%s\">%s</property> ", e.getAttribute("name"), e.getTextContent());
            parent.removeChild(e);
            this.addHibernateComment(s, parent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Boolean addHibernateElement(String key, String value, String comment) throws XPathExpressionException {
        Element elem = this.getHibernateElement(key);
        if (elem == null) {
            Element parentElem = this.getElement("/hibernate-configuration/session-factory");
            if (comment != null && !comment.isEmpty()) {
                this.addHibernateComment(comment, parentElem);
            }
            elem = this.dom.createElement("property");
            elem.setAttribute("name", "hibernate." + key);
            elem.setTextContent(value);
            parentElem.appendChild(elem);
            return true;
        }
        return null;
    }

    public Boolean addHibernateComment(String str, Node parent) throws XPathExpressionException {
        parent.appendChild(this.dom.createComment(str));
        return true;
    }

    public Node getNode(String xpathExpr) throws XPathExpressionException {
        return (Node)this.xPath.evaluate(xpathExpr, this.dom, XPathConstants.NODE);
    }

    public Element getElement(String xpathExpr) throws XPathExpressionException {
        return (Element)this.xPath.evaluate(xpathExpr, this.dom, XPathConstants.NODE);
    }

    public NodeList getNodeList(String xpathExpr) throws XPathExpressionException {
        return (NodeList)this.xPath.evaluate(xpathExpr, this.dom, XPathConstants.NODESET);
    }

    public String getAttributeValue(String xpathExpr, String defaultValue) throws XPathExpressionException {
        String value = (String)this.xPath.evaluate(xpathExpr, this.dom, XPathConstants.STRING);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return value;
    }

    public boolean hasElement(String xpathExpr) {
        try {
            return this.getNode(xpathExpr) != null;
        }
        catch (XPathExpressionException e) {
            return false;
        }
    }

    private void deleteWhitespaceNode(Node parent) {
        NodeList nl = parent.getChildNodes();
        ArrayList<Node> whitespaceNodes = new ArrayList<Node>();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n2 = nl.item(i);
            if (XmlInfo.isWhitespaceNode(n2)) {
                whitespaceNodes.add(n2);
                continue;
            }
            if (n2.getNodeType() != 1) continue;
            this.deleteWhitespaceNode(n2);
        }
        whitespaceNodes.forEach(n -> parent.removeChild((Node)n));
    }

    private static boolean isWhitespaceNode(Node n) {
        if (n.getNodeType() == 3) {
            String val = n.getNodeValue();
            return val.trim().length() == 0;
        }
        return false;
    }
}

