/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.httpclient.commons;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sos.commons.exception.SOSNoSuchFileException;
import com.sos.commons.httpclient.commons.HttpExecutionResult;
import com.sos.commons.util.SOSClassUtil;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.http.HttpUtils;
import com.sos.commons.util.loggers.base.ISOSLogger;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.net.ssl.SSLSession;

public abstract class ABaseHttpClient
implements AutoCloseable {
    private static final Set<String> DEFAULT_SENSITIVE_HEADERS = Set.of("Authorization", "Proxy-Authorization", "Cookie", "Set-Cookie", "X-Api-Key", "X-Auth-Token", "Authentication-Token", "Session-Id");
    private static final String MASKED_STRING = "********";
    private final ISOSLogger logger;
    private final HttpClient client;
    private Map<String, String> headers;
    private Set<String> sensitiveHeaders = new LinkedHashSet<String>(DEFAULT_SENSITIVE_HEADERS);
    private Boolean isHEADMethodAllowed;
    private boolean chunkedTransfer = true;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    protected ABaseHttpClient(ISOSLogger logger, HttpClient client) {
        this(logger, client, true);
    }

    protected ABaseHttpClient(ISOSLogger logger, HttpClient client, boolean chunkedTransfer) {
        this.logger = logger;
        this.client = client;
        this.chunkedTransfer = chunkedTransfer;
    }

    @Override
    public void close() throws Exception {
    }

    public HttpRequest.Builder createRequestBuilder(URI uri) {
        return this.createRequestBuilder(uri, this.headers);
    }

    public HttpRequest.Builder createRequestBuilder(URI uri, Map<String, String> headers) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(uri);
        this.setRequestHeaders(builder, headers);
        return builder;
    }

    public <T> HttpExecutionResult<T> execute(HttpRequest request, HttpResponse.BodyHandler<T> bodyHandler) throws Exception {
        return new HttpExecutionResult<T>(request, this.client.send(request, bodyHandler));
    }

    public HttpExecutionResult<String> executeWithResponseBody(HttpRequest request) throws Exception {
        return this.execute(request, HttpResponse.BodyHandlers.ofString());
    }

    public HttpExecutionResult<JsonNode> executeWithJsonNodeResponseBody(HttpRequest request) throws Exception {
        HttpExecutionResult<String> r = this.executeWithResponseBody(request);
        this.verifyJsonResponse(r.response());
        return this.wrapHttpExecutionResultJsonNode(r);
    }

    public <T> HttpExecutionResult<T> executeWithJsonResponseBody(HttpRequest request, Class<T> type) throws Exception {
        HttpExecutionResult<String> r = this.executeWithResponseBody(request);
        this.verifyJsonResponse(r.response());
        return this.wrapHttpExecutionResultJson(r, type);
    }

    public <T> HttpExecutionResult<T> executeWithJsonResponseBody(HttpRequest request, TypeReference<T> typeRef) throws Exception {
        HttpExecutionResult<String> r = this.executeWithResponseBody(request);
        this.verifyJsonResponse(r.response());
        return this.wrapHttpExecutionResultJson(r, typeRef);
    }

    public HttpExecutionResult<Map<String, Object>> executeWithJsonAsMapResponseBody(HttpRequest request) throws Exception {
        HttpExecutionResult<String> r = this.executeWithResponseBody(request);
        this.verifyJsonResponse(r.response());
        return this.wrapHttpExecutionResultJson(r, new TypeReference<Map<String, Object>>(){});
    }

    public HttpExecutionResult<Void> executeNoResponseBody(HttpRequest request) throws Exception {
        return this.execute(request, HttpResponse.BodyHandlers.discarding());
    }

    public HttpExecutionResult<Void> executeHEADOrGETNoResponseBody(URI uri) throws Exception {
        HttpRequest request = null;
        boolean isHEAD = false;
        if (this.isHEADMethodAllowed == null || this.isHEADMethodAllowed.booleanValue()) {
            request = this.createHEADRequest(uri);
            isHEAD = true;
        } else {
            request = this.createGETRequest(uri);
        }
        HttpExecutionResult<Void> result = this.executeNoResponseBody(request);
        if (isHEAD) {
            if (HttpUtils.isMethodNotAllowed((int)result.response().statusCode())) {
                this.isHEADMethodAllowed = false;
                result = this.executeNoResponseBody(this.createGETRequest(uri));
            } else {
                this.isHEADMethodAllowed = true;
            }
        }
        return result;
    }

    public <T> HttpExecutionResult<T> executeGET(URI uri, HttpResponse.BodyHandler<T> handler) throws Exception {
        return this.execute(this.createGETRequest(uri), handler);
    }

    public HttpExecutionResult<String> executeGET(URI uri) throws Exception {
        return this.executeWithResponseBody(this.createGETRequest(uri));
    }

    public HttpExecutionResult<JsonNode> executeGETJson(URI uri) throws Exception {
        return this.executeWithJsonNodeResponseBody(this.createGETRequest(uri));
    }

    public <T> HttpExecutionResult<T> executeGETJson(URI uri, Class<T> type) throws Exception {
        return this.executeWithJsonResponseBody(this.createGETRequest(uri), type);
    }

    public <T> HttpExecutionResult<T> executeGETJson(URI uri, TypeReference<T> typeRef) throws Exception {
        return this.executeWithJsonResponseBody(this.createGETRequest(uri), typeRef);
    }

    public HttpExecutionResult<Void> executeGETNoResponseBody(URI uri) throws Exception {
        return this.executeNoResponseBody(this.createGETRequest(uri));
    }

    public <T> HttpExecutionResult<T> executePOST(URI uri, HttpResponse.BodyHandler<T> handler) throws Exception {
        return this.execute(this.createPOSTRequest(uri, HttpRequest.BodyPublishers.noBody()), handler);
    }

    public <T> HttpExecutionResult<T> executePOST(URI uri, HttpRequest.BodyPublisher bodyPublisher, HttpResponse.BodyHandler<T> handler) throws Exception {
        return this.execute(this.createPOSTRequest(uri, bodyPublisher), handler);
    }

    public <T> HttpExecutionResult<T> executePOST(URI uri, String requestBody, HttpResponse.BodyHandler<T> handler) throws Exception {
        return this.execute(this.createPOSTRequest(uri, HttpRequest.BodyPublishers.ofString(requestBody)), handler);
    }

    public HttpExecutionResult<String> executePOST(URI uri) throws Exception {
        return this.executeWithResponseBody(this.createPOSTRequest(uri, HttpRequest.BodyPublishers.noBody()));
    }

    public HttpExecutionResult<String> executePOST(URI uri, HttpRequest.BodyPublisher bodyPublisher) throws Exception {
        return this.executeWithResponseBody(this.createPOSTRequest(uri, bodyPublisher));
    }

    public HttpExecutionResult<String> executePOST(URI uri, String requestBody) throws Exception {
        return this.executeWithResponseBody(this.createPOSTRequest(uri, HttpRequest.BodyPublishers.ofString(requestBody)));
    }

    public HttpExecutionResult<JsonNode> executePOSTJson(URI uri, HttpRequest.BodyPublisher bodyPublisher) throws Exception {
        return this.executeWithJsonNodeResponseBody(this.createPOSTRequest(uri, bodyPublisher));
    }

    public HttpExecutionResult<JsonNode> executePOSTJson(URI uri, String requestBody) throws Exception {
        return this.executeWithJsonNodeResponseBody(this.createPOSTRequest(uri, HttpRequest.BodyPublishers.ofString(requestBody)));
    }

    public HttpExecutionResult<JsonNode> executePOSTJson(URI uri) throws Exception {
        return this.executeWithJsonNodeResponseBody(this.createPOSTRequest(uri, HttpRequest.BodyPublishers.noBody()));
    }

    public <T> HttpExecutionResult<T> executePOSTJson(URI uri, HttpRequest.BodyPublisher bodyPublisher, Class<T> type) throws Exception {
        return this.executeWithJsonResponseBody(this.createPOSTRequest(uri, bodyPublisher), type);
    }

    public <T> HttpExecutionResult<T> executePOSTJson(URI uri, String requestBody, Class<T> type) throws Exception {
        return this.executeWithJsonResponseBody(this.createPOSTRequest(uri, HttpRequest.BodyPublishers.ofString(requestBody)), type);
    }

    public <T> HttpExecutionResult<T> executePOSTJson(URI uri, Class<T> type) throws Exception {
        return this.executeWithJsonResponseBody(this.createPOSTRequest(uri, HttpRequest.BodyPublishers.noBody()), type);
    }

    public <T> HttpExecutionResult<T> executePOSTJson(URI uri, HttpRequest.BodyPublisher bodyPublisher, TypeReference<T> typeRef) throws Exception {
        return this.executeWithJsonResponseBody(this.createPOSTRequest(uri, bodyPublisher), typeRef);
    }

    public <T> HttpExecutionResult<T> executePOSTJson(URI uri, String requestBody, TypeReference<T> typeRef) throws Exception {
        return this.executeWithJsonResponseBody(this.createPOSTRequest(uri, HttpRequest.BodyPublishers.ofString(requestBody)), typeRef);
    }

    public <T> HttpExecutionResult<T> executePOSTJson(URI uri, TypeReference<T> typeRef) throws Exception {
        return this.executeWithJsonResponseBody(this.createPOSTRequest(uri, HttpRequest.BodyPublishers.noBody()), typeRef);
    }

    public HttpExecutionResult<Map<String, Object>> executePOSTJsonAsMap(URI uri, String requestBody) throws Exception {
        return this.executeWithJsonResponseBody(this.createPOSTRequest(uri, HttpRequest.BodyPublishers.ofString(requestBody)), new TypeReference<Map<String, Object>>(){});
    }

    public HttpExecutionResult<Map<String, Object>> executePOSTJsonAsMap(URI uri) throws Exception {
        return this.executeWithJsonResponseBody(this.createPOSTRequest(uri, HttpRequest.BodyPublishers.noBody()), new TypeReference<Map<String, Object>>(){});
    }

    public <T> HttpExecutionResult<T> executeDELETE(URI uri, HttpResponse.BodyHandler<T> handler) throws Exception {
        return this.execute(this.createDELETERequest(uri), handler);
    }

    public HttpExecutionResult<String> executeDELETE(URI uri) throws Exception {
        return this.executeWithResponseBody(this.createDELETERequest(uri));
    }

    public HttpExecutionResult<Void> executeDELETENoResponseBody(URI uri) throws Exception {
        return this.executeNoResponseBody(this.createDELETERequest(uri));
    }

    public <T> HttpExecutionResult<T> executePUT(URI uri, HttpResponse.BodyHandler<T> handler, String content) throws Exception {
        return this.execute(this.createPUTRequest(uri, content, false), handler);
    }

    public HttpExecutionResult<String> executePUT(URI uri, String content) throws Exception {
        return this.executeWithResponseBody(this.createPUTRequest(uri, content, false));
    }

    public HttpExecutionResult<Void> executePUTNoResponseBody(URI uri, String content) throws Exception {
        return this.executeNoResponseBody(this.createPUTRequest(uri, content, false));
    }

    public HttpExecutionResult<Void> executePUTNoResponseBody(URI uri, String content, boolean isWebDAV) throws Exception {
        return this.executeNoResponseBody(this.createPUTRequest(uri, content, isWebDAV));
    }

    public <T> HttpExecutionResult<T> executePUT(URI uri, HttpResponse.BodyHandler<T> handler, InputStream is, long size) throws Exception {
        return this.execute(this.createPUTInputStreamRequest(uri, is, size, false), handler);
    }

    public HttpExecutionResult<String> executePUT(URI uri, InputStream is, long size) throws Exception {
        return this.executeWithResponseBody(this.createPUTInputStreamRequest(uri, is, size, false));
    }

    public HttpExecutionResult<Void> executePUTNoResponseBody(URI uri, InputStream is, long size) throws Exception {
        return this.executeNoResponseBody(this.createPUTInputStreamRequest(uri, is, size, false));
    }

    public HttpExecutionResult<Void> executePUTNoResponseBody(URI uri, InputStream is, long size, boolean isWebDAV) throws Exception {
        return this.executeNoResponseBody(this.createPUTInputStreamRequest(uri, is, size, isWebDAV));
    }

    public static void withWebDAVOverwrite(HttpRequest.Builder builder, boolean withWebDAVOverwrite) {
        if (withWebDAVOverwrite) {
            builder.header("Overwrite", "T");
        }
    }

    public InputStream getHTTPInputStream(URI uri) throws Exception {
        HttpRequest request = this.createGETRequest(uri);
        HttpResponse<InputStream> response = this.client.send(request, HttpResponse.BodyHandlers.ofInputStream());
        int code = response.statusCode();
        if (!HttpUtils.isSuccessful((int)code)) {
            HttpExecutionResult<InputStream> result = new HttpExecutionResult<InputStream>(request, response);
            if (HttpUtils.isNotFound((int)code)) {
                throw new SOSNoSuchFileException(uri.toString(), (Throwable)new Exception(ABaseHttpClient.formatExecutionResult(result)));
            }
            throw new Exception(ABaseHttpClient.formatExecutionResult(result));
        }
        return response.body();
    }

    public long getFileSize(HttpResponse<?> response) throws Exception {
        long size = response.headers().firstValueAsLong("Content-Length").orElse(-1L);
        if (size < 0L) {
            size = this.getFileSizeIfChunkedTransferEncoding(response.uri());
        }
        return size;
    }

    public static long getLastModifiedInMillis(HttpResponse<?> response) {
        if (response == null) {
            return -1L;
        }
        Optional<String> header = response.headers().firstValue("Last-Modified");
        if (!header.isPresent()) {
            return -1L;
        }
        return HttpUtils.httpDateToMillis((String)header.get());
    }

    public static String maskSensitiveUri(URI uri) {
        if (uri == null) {
            return "";
        }
        if (SOSString.isEmpty((String)uri.getQuery())) {
            return uri.toString();
        }
        String base = uri.getScheme() + "://" + uri.getHost();
        if (uri.getPath() != null) {
            base = base + uri.getPath();
        }
        base = base.endsWith("/") ? base : base + "/";
        return base + MASKED_STRING;
    }

    public static String formatExecutionResult(HttpExecutionResult<?> result) {
        return ABaseHttpClient.buildExecutionResultSummary(result);
    }

    private static String buildExecutionResultSummary(HttpExecutionResult<?> result) {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(result.request().method()).append("]");
        if (result.formatWithMaskRequestURIQueryParams()) {
            sb.append("[").append(ABaseHttpClient.maskSensitiveUri(result.request().uri())).append("]");
        } else {
            sb.append("[").append(result.request().uri()).append("]");
        }
        sb.append("[").append(result.response().statusCode()).append("]");
        if (result.formatWithResponseBody()) {
            Object body = result.response().body();
            if (body == null) {
                sb.append(HttpUtils.getReasonPhrase((int)result.response().statusCode()));
            } else {
                sb.append(body);
            }
        } else {
            sb.append(HttpUtils.getReasonPhrase((int)result.response().statusCode()));
        }
        return sb.toString();
    }

    public boolean isChunkedTransfer() {
        return this.chunkedTransfer;
    }

    public void setSensitiveHeaders(Set<String> val) {
        this.sensitiveHeaders = new LinkedHashSet<String>(val);
    }

    public void addSensitiveHeader(String val) {
        this.sensitiveHeaders.add(val);
    }

    public boolean isSensitiveHeader(String headerName) {
        return this.sensitiveHeaders.stream().anyMatch(h -> h.equalsIgnoreCase(headerName));
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public HttpRequest createHEADRequest(URI uri) {
        return this.createHEADRequest(uri, this.headers);
    }

    public HttpRequest createHEADRequest(URI uri, Map<String, String> headers) {
        return this.createRequestBuilder(uri, headers).method("HEAD", HttpRequest.BodyPublishers.noBody()).build();
    }

    public ISOSLogger getLogger() {
        return this.logger;
    }

    private HttpRequest createGETRequest(URI uri) {
        return this.createRequestBuilder(uri).GET().build();
    }

    private HttpRequest createPOSTRequest(URI uri, HttpRequest.BodyPublisher bodyPublisher) {
        return this.createRequestBuilder(uri).POST(bodyPublisher == null ? HttpRequest.BodyPublishers.noBody() : bodyPublisher).build();
    }

    private HttpRequest createDELETERequest(URI uri) {
        return this.createRequestBuilder(uri).DELETE().build();
    }

    private HttpRequest createPUTRequest(URI uri, String content, boolean isWebDAV) {
        HttpRequest.Builder builder = this.createRequestBuilder(uri);
        builder.header("Content-Type", "application/octet-stream");
        ABaseHttpClient.withWebDAVOverwrite(builder, isWebDAV);
        byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
        if (!this.chunkedTransfer) {
            builder.header("Content-Length", String.valueOf(bytes.length));
        }
        return builder.PUT(HttpRequest.BodyPublishers.ofByteArray(bytes)).build();
    }

    private HttpRequest createPUTInputStreamRequest(URI uri, InputStream is, long size, boolean isWebDAV) {
        HttpRequest.Builder builder = this.createRequestBuilder(uri);
        builder.header("Content-Type", "application/octet-stream");
        ABaseHttpClient.withWebDAVOverwrite(builder, isWebDAV);
        if (!this.chunkedTransfer) {
            builder.header("Content-Length", String.valueOf(size));
        }
        return builder.PUT(HttpRequest.BodyPublishers.ofInputStream(() -> is)).build();
    }

    protected void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    private long getFileSizeIfChunkedTransferEncoding(URI uri) throws Exception {
        try (InputStream is = this.getHTTPInputStream(uri);){
            long l = SOSClassUtil.countBytes((InputStream)is);
            return l;
        }
    }

    private void setRequestHeaders(HttpRequest.Builder builder, Map<String, String> headers) {
        if (headers == null) {
            return;
        }
        headers.forEach((name, value) -> {
            if (value.isEmpty()) {
                builder.header((String)name, "");
            } else {
                builder.header((String)name, (String)value);
            }
        });
    }

    private void verifyJsonResponse(HttpResponse<String> response) throws Exception {
        String contentType = response.headers().firstValue("Content-Type").orElse("");
        if (!contentType.contains("application/json")) {
            throw new Exception("Expected application/json but got: " + contentType);
        }
    }

    private <T> HttpResponse<T> wrapResponse(final HttpResponse<String> original, final T parsedBody) {
        return new HttpResponse<T>(){

            @Override
            public int statusCode() {
                return original.statusCode();
            }

            @Override
            public HttpRequest request() {
                return original.request();
            }

            @Override
            public Optional<HttpResponse<T>> previousResponse() {
                return Optional.empty();
            }

            @Override
            public HttpHeaders headers() {
                return original.headers();
            }

            @Override
            public T body() {
                return parsedBody;
            }

            @Override
            public Optional<SSLSession> sslSession() {
                return original.sslSession();
            }

            @Override
            public URI uri() {
                return original.uri();
            }

            @Override
            public HttpClient.Version version() {
                return original.version();
            }
        };
    }

    private HttpExecutionResult<JsonNode> wrapHttpExecutionResultJsonNode(HttpExecutionResult<String> original) throws Exception {
        return new HttpExecutionResult<JsonNode>(original.request(), this.wrapResponse(original.response(), OBJECT_MAPPER.readTree(original.response().body())));
    }

    private <T> HttpExecutionResult<T> wrapHttpExecutionResultJson(HttpExecutionResult<String> original, Class<T> type) throws Exception {
        return new HttpExecutionResult<Object>(original.request(), this.wrapResponse(original.response(), OBJECT_MAPPER.readValue(original.response().body(), type)));
    }

    private <T> HttpExecutionResult<T> wrapHttpExecutionResultJson(HttpExecutionResult<String> original, TypeReference<T> typeRef) throws Exception {
        return new HttpExecutionResult<Object>(original.request(), this.wrapResponse(original.response(), OBJECT_MAPPER.readValue(original.response().body(), typeRef)));
    }
}

