/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.httpclient.commons.auth;

import com.sos.commons.httpclient.commons.auth.IHttpClientAuthStrategy;
import java.net.Authenticator;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;

public class HttpClientBasicAuthStrategy
implements IHttpClientAuthStrategy {
    private Map<String, String> authHeaders = new LinkedHashMap<String, String>();

    public HttpClientBasicAuthStrategy(String username, String password) {
        if (username != null && password != null) {
            this.authHeaders.put("Authorization", "Basic " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes()));
        }
    }

    @Override
    public boolean hasAuthenticator() {
        return false;
    }

    @Override
    public Authenticator toAuthenticator() {
        return null;
    }

    @Override
    public Map<String, String> getAuthHeaders() {
        return this.authHeaders;
    }

    public void setAuthHeaders(Map<String, String> headers) {
        this.authHeaders = headers;
    }
}

