/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSClassList {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSClassList.class);
    private final ClassLoader classLoader;
    private final Set<Class<?>> classes = new HashSet();

    public SOSClassList() {
        this.classLoader = ClassLoader.getSystemClassLoader();
    }

    public void addClassIfExist(String className) {
        try {
            Class<?> c = this.classLoader.loadClass(className);
            this.add(c);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn(String.format("Class %s not found in the classpath", className));
        }
    }

    public void add(Class<?> c) {
        this.classes.add(c);
    }

    public void merge(Collection<Class<?>> classesToMerge) {
        this.classes.addAll(classesToMerge);
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }
}

