/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SOSMapVariableReplacer {
    private static final String REGEX_ENV_VAR_UNIX = "\\$\\{([\\p{L}\\p{N}_.-]+)\\}|\\$([\\p{L}\\p{N}_.-]+)";
    private static final Pattern PATTERN_ENV_VAR_UNIX = Pattern.compile("\\$\\{([\\p{L}\\p{N}_.-]+)\\}|\\$([\\p{L}\\p{N}_.-]+)");
    private static final String REGEX_ENV_VAR_WINDOWS = "%([\\p{L}\\p{N}_.-]+)%|%\\{([\\p{L}\\p{N}_.-]+)\\}";
    private static final Pattern PATTERN_ENV_VAR_WINDOWS = Pattern.compile("%([\\p{L}\\p{N}_.-]+)%|%\\{([\\p{L}\\p{N}_.-]+)\\}");
    private static final Pattern PATTERN_ENV_VAR_ALL = Pattern.compile("\\$\\{([\\p{L}\\p{N}_.-]+)\\}|\\$([\\p{L}\\p{N}_.-]+)|%([\\p{L}\\p{N}_.-]+)%|%\\{([\\p{L}\\p{N}_.-]+)\\}");
    private final Map<String, String> map;
    private final boolean caseSensitive;
    private final boolean keepUnresolved;

    public SOSMapVariableReplacer(Map<String, String> map, boolean caseSensitive) {
        this(map, caseSensitive, true);
    }

    public SOSMapVariableReplacer(Map<String, String> map, boolean caseSensitive, boolean keepUnresolved) {
        this.map = caseSensitive ? map : SOSMapVariableReplacer.prepareEnvMapForCaseInsensitive(map);
        this.caseSensitive = caseSensitive;
        this.keepUnresolved = keepUnresolved;
    }

    public String replaceUnixVars(String input) {
        return this.replaceVars(input, PATTERN_ENV_VAR_UNIX);
    }

    public String replaceWindowsVars(String input) {
        return this.replaceVars(input, PATTERN_ENV_VAR_WINDOWS);
    }

    public String replaceAllVars(String input) {
        return this.replaceVars(input, PATTERN_ENV_VAR_ALL);
    }

    private static Map<String, String> prepareEnvMapForCaseInsensitive(Map<String, String> originalMap) {
        return originalMap.entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toLowerCase(), Map.Entry::getValue));
    }

    private String replaceVars(String input, Pattern pattern) {
        if (input == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(input);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String replacement;
            String varName = this.getVarName(matcher);
            String string = replacement = this.caseSensitive ? this.map.get(varName) : this.map.get(varName.toLowerCase());
            if (replacement == null) {
                replacement = this.keepUnresolved ? matcher.group(0) : "";
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private String getVarName(Matcher matcher) {
        for (int i = 1; i <= matcher.groupCount(); ++i) {
            String varName = matcher.group(i);
            if (varName == null) continue;
            return varName;
        }
        return null;
    }
}

