/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util.arguments.base;

import com.sos.commons.util.SOSReflection;
import com.sos.commons.util.arguments.base.SOSArgument;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public abstract class ASOSArguments {
    private List<Field> argumentFields;

    public List<Field> getArgumentFields() {
        if (this.argumentFields == null) {
            this.argumentFields = SOSReflection.getAllDeclaredFields(this.getClass()).stream().filter(f -> f.getType().equals(SOSArgument.class)).collect(Collectors.toList());
        }
        return this.argumentFields;
    }

    public String getIdentifier() {
        return this.getClass().getName();
    }

    public <T> void applyDefaultIfNull() throws Exception {
        this.getArgumentFields();
        for (Field f : this.argumentFields) {
            f.setAccessible(true);
            SOSArgument current = (SOSArgument)f.get(this);
            if (current.getName() == null || current.getDefaultValue() == null || !current.isEmpty()) continue;
            current.setValue(current.getDefaultValue());
            f.set(this, current);
        }
    }

    public void applyDefaultIfNullQuietly() {
        try {
            this.applyDefaultIfNull();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setArguments(List<SOSArgument<?>> args) throws Exception {
        this.getArgumentFields();
        for (Field f : this.argumentFields) {
            f.setAccessible(true);
            SOSArgument<?> current = (SOSArgument<?>)f.get(this);
            if (current.getName() == null) continue;
            SOSArgument<?> extern = this.find(args, current.getName());
            if (extern != null) {
                current = extern;
            }
            f.set(this, current);
        }
    }

    public List<SOSArgument<?>> getArguments() throws Exception {
        this.getArgumentFields();
        ArrayList l = new ArrayList();
        for (Field f : this.argumentFields) {
            f.setAccessible(true);
            SOSArgument current = (SOSArgument)f.get(this);
            if (current.getName() == null) continue;
            l.add(current);
        }
        return l;
    }

    public List<ASOSArguments> getIncludedArgumentsIfNotNull() throws Exception {
        this.getArgumentFields();
        ArrayList<ASOSArguments> l = new ArrayList<ASOSArguments>();
        List included = SOSReflection.getAllDeclaredFields(this.getClass()).stream().filter(f -> ASOSArguments.class.isAssignableFrom(f.getType())).collect(Collectors.toList());
        for (Field f2 : included) {
            f2.setAccessible(true);
            Object include = f2.get(this);
            if (include == null) continue;
            l.add((ASOSArguments)include);
        }
        return l;
    }

    private SOSArgument<?> find(List<SOSArgument<?>> args, String name) {
        return args.stream().filter(a -> a.getName() != null && a.getName().equals(name)).findAny().orElse(null);
    }
}

