/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util.arguments.base;

import com.sos.commons.util.SOSDate;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.arguments.base.SOSArgument;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SOSArgumentHelper {
    public static final String DEFAULT_LIST_VALUE_DELIMITER = ";";
    private static final String DISPLAY_VALUE_TRUNCATING_SUFFIX = "<truncated>";
    private static final int DISPLAY_VALUE_MAX_LENGTH = 255;
    private static final int DISPLAY_VALUE_USED_LENGTH = 255 - "<truncated>".length();

    public static String getDisplayValue(Object value, SOSArgument.DisplayMode mode) {
        if (value == null) {
            return null;
        }
        switch (mode) {
            case NONE: {
                return SOSArgument.DisplayMode.NONE.getValue();
            }
            case UNMASKED: {
                return SOSArgumentHelper.truncatingIfNeeded(value.toString());
            }
            case MASKED: {
                return SOSArgument.DisplayMode.MASKED.getValue();
            }
        }
        return SOSArgument.DisplayMode.UNKNOWN.getValue();
    }

    public static String getClassName(String fullyQualifiedName) {
        if (fullyQualifiedName == null) {
            return null;
        }
        int indx = fullyQualifiedName.lastIndexOf(46);
        return indx > -1 ? fullyQualifiedName.substring(indx + 1) : fullyQualifiedName;
    }

    public static long asMillis(SOSArgument<String> arg) {
        return SOSArgumentHelper.asSeconds(arg, 0L) * 1000L;
    }

    public static long asSeconds(SOSArgument<String> arg, long defaultValue) {
        if (arg.getValue() == null) {
            return defaultValue;
        }
        try {
            return SOSDate.resolveAge("s", arg.getValue());
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public static void setListStringArgumentValue(SOSArgument<List<String>> arg, String value) {
        SOSArgumentHelper.setListStringArgumentValue(arg, value, DEFAULT_LIST_VALUE_DELIMITER);
    }

    public static void setListStringArgumentValue(SOSArgument<List<String>> arg, String value, String listValueDelimiter) {
        if (arg == null) {
            return;
        }
        if (SOSString.isEmpty(value)) {
            arg.setValue(null);
        } else {
            arg.setValue(Stream.of(value.split(listValueDelimiter)).filter(e -> !SOSString.isEmpty(e)).collect(Collectors.toList()));
        }
    }

    public static void setListPathArgumentValue(SOSArgument<List<Path>> arg, String value) {
        SOSArgumentHelper.setListPathArgumentValue(arg, value, DEFAULT_LIST_VALUE_DELIMITER);
    }

    public static void setListPathArgumentValue(SOSArgument<List<Path>> arg, String value, String listValueDelimiter) {
        if (arg == null) {
            return;
        }
        if (SOSString.isEmpty(value)) {
            arg.setValue(null);
        } else {
            arg.setValue(Stream.of(value.split(listValueDelimiter)).filter(e -> !SOSString.isEmpty(e)).map(p -> Path.of(p, new String[0])).collect(Collectors.toList()));
        }
    }

    public static String getListStringArgumentValueAsString(SOSArgument<List<String>> arg) {
        return SOSArgumentHelper.getListStringArgumentValueAsString(arg, DEFAULT_LIST_VALUE_DELIMITER);
    }

    public static String getListStringArgumentValueAsString(SOSArgument<List<String>> arg, String listValueDelimiter) {
        if (arg == null || arg.getValue() == null) {
            return null;
        }
        return String.join((CharSequence)listValueDelimiter, (Iterable<? extends CharSequence>)arg.getValue());
    }

    private static String truncatingIfNeeded(String val) {
        if (val == null) {
            return val;
        }
        Object v = val;
        if (((String)v).length() > 255) {
            v = ((String)v).substring(0, DISPLAY_VALUE_USED_LENGTH) + DISPLAY_VALUE_TRUNCATING_SUFFIX;
        }
        return v;
    }
}

