/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util.keystore;

import com.sos.commons.util.keystore.KeyStoreArguments;
import com.sos.commons.util.keystore.KeyStoreType;
import com.sos.commons.util.loggers.base.ISOSLogger;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;

public class KeyStoreReader {
    private static final String SYSTEM_PROPERTY_KEYSTORE_PATH = "javax.net.ssl.keyStore";
    private static final String SYSTEM_PROPERTY_KEYSTORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    private static final String SYSTEM_PROPERTY_TRUSTSTORE_PATH = "javax.net.ssl.trustStore";
    private static final String SYSTEM_PROPERTY_TRUSTSTORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    private final Type type;
    private Path path;
    private String password;
    private String storeType;

    private KeyStoreReader() {
        this(null, null, null, null);
    }

    private KeyStoreReader(Type type, Path path, String password, String storeType) {
        this.type = type;
        this.path = path;
        this.password = password;
        this.storeType = KeyStoreReader.getType(storeType);
    }

    public KeyStore read() throws Exception {
        if (this.path == null) {
            return null;
        }
        this.resolvePathAndPassword();
        return KeyStoreReader.load(this.path, this.password, this.storeType);
    }

    public static KeyStoreResult read(ISOSLogger logger, KeyStoreArguments args) throws Exception {
        if (args == null || !args.isCustomStoresEnabled()) {
            return null;
        }
        KeyStoreResult result = new KeyStoreReader().new KeyStoreResult();
        if (!args.getKeyStoreFile().isEmpty()) {
            result.setKeyStoreResult(KeyStoreReader.read(Type.KEYSTORE, args.getKeyStoreFile().getValue(), args.getKeyStorePassword().getValue(), args.getKeyStoreType().getValue().name()));
        }
        if (!args.getTrustStoreFile().isEmpty()) {
            result.setTrustStoreResult(KeyStoreReader.read(Type.TRUSTSTORE, args.getTrustStoreFile().getValue(), args.getTrustStorePassword().getValue(), args.getTrustStoreType().getValue().name()));
        }
        return result;
    }

    public static KeyStore load(Path path, String password, KeyStoreType storeType) throws Exception {
        return KeyStoreReader.load(path, password, KeyStoreReader.getType(storeType));
    }

    public static KeyStore load(Path path, String password, String storeType) throws Exception {
        KeyStore keyStore;
        block9: {
            if (path == null) {
                return null;
            }
            String type = KeyStoreReader.getType(storeType);
            char[] pass = password == null ? null : password.toCharArray();
            InputStream is = Files.newInputStream(path, new OpenOption[0]);
            try {
                KeyStore ks = KeyStore.getInstance(type);
                ks.load(is, pass);
                keyStore = ks;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    throw new Exception(String.format("[%s.load][%s][%s]%s", KeyStoreReader.class.getSimpleName(), storeType, path, e), e);
                }
            }
            is.close();
        }
        return keyStore;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("type").append((Object)this.type);
        if (this.storeType != null) {
            sb.append(",storeType=").append(this.storeType);
        }
        if (this.path != null) {
            sb.append(",path=").append(this.path);
        }
        return sb.toString();
    }

    private static KeyStoreObject read(Type type, Path path, String password, String storeType) throws Exception {
        KeyStoreReader reader = new KeyStoreReader(type, path, password, storeType);
        reader.resolvePathAndPassword();
        KeyStoreObject result = new KeyStoreReader().new KeyStoreObject();
        result.type = reader.storeType;
        result.keyStore = KeyStoreReader.load(reader.path, reader.password, reader.storeType);
        result.path = reader.path;
        result.password = reader.getPassword();
        return result;
    }

    public char[] getPassword() {
        return this.password == null ? null : this.password.toCharArray();
    }

    public Path getPath() {
        return this.path;
    }

    public String getStoreType() {
        return this.storeType;
    }

    private void resolvePathAndPassword() {
        switch (this.type) {
            case KEYSTORE: {
                this.setPathAndPassword(SYSTEM_PROPERTY_KEYSTORE_PATH, SYSTEM_PROPERTY_KEYSTORE_PASSWORD);
                break;
            }
            case TRUSTSTORE: {
                this.setPathAndPassword(SYSTEM_PROPERTY_TRUSTSTORE_PATH, SYSTEM_PROPERTY_TRUSTSTORE_PASSWORD);
                break;
            }
            case KEY_AND_TRUSTSTORE: {
                this.setPathAndPassword(SYSTEM_PROPERTY_KEYSTORE_PATH, SYSTEM_PROPERTY_KEYSTORE_PASSWORD);
                this.setPathAndPassword(SYSTEM_PROPERTY_TRUSTSTORE_PATH, SYSTEM_PROPERTY_TRUSTSTORE_PASSWORD);
                break;
            }
        }
    }

    private static String getType(KeyStoreType storeType) {
        return KeyStoreReader.getType(storeType == null ? null : storeType.name());
    }

    private static String getType(String storeType) {
        return storeType == null ? KeyStore.getDefaultType() : storeType;
    }

    private void setPathAndPassword(String pathProperty, String passwordProperty) {
        String val;
        if (this.path == null && (val = System.getProperty(pathProperty)) != null) {
            this.path = Paths.get(val, new String[0]);
        }
        if (this.password == null && (val = System.getProperty(passwordProperty)) != null) {
            this.password = val;
        }
    }

    public static enum Type {
        KEYSTORE,
        TRUSTSTORE,
        KEY_AND_TRUSTSTORE;

    }

    public class KeyStoreResult {
        private String keyStoreType;
        private KeyStore keyStore;
        private Path keyStorePath;
        private char[] keyStorePassword;
        private String trustStoreType;
        private KeyStore trustStore;
        private Path trustStorePath;
        private char[] trustStorePassword;

        public String getKeyStoreType() {
            return this.keyStoreType;
        }

        public KeyStore getKeyStore() {
            return this.keyStore;
        }

        public Path getKeyStorePath() {
            return this.keyStorePath;
        }

        public char[] getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public String getTrustStoreType() {
            return this.trustStoreType;
        }

        public KeyStore getTrustStore() {
            return this.trustStore;
        }

        public Path getTrustStorePath() {
            return this.trustStorePath;
        }

        public char[] getTrustStorePassword() {
            return this.trustStorePassword;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.keyStorePath != null && this.trustStorePath != null) {
                if (this.keyStorePath.equals(this.trustStorePath)) {
                    sb.append("keystore/truststore ").append(this.keyStoreType);
                    sb.append(" ").append(this.keyStorePath);
                } else {
                    sb.append("keystore ").append(this.keyStoreType);
                    sb.append(" ").append(this.keyStorePath);
                    sb.append(",truststore ").append(this.trustStoreType);
                    sb.append(" ").append(this.trustStorePath);
                }
            } else if (this.keyStorePath != null) {
                sb.append("keystore ").append(this.keyStoreType);
                sb.append(" ").append(this.keyStorePath);
            } else if (this.trustStorePath != null) {
                sb.append("truststore ").append(this.trustStoreType);
                sb.append(" ").append(this.trustStorePath);
            }
            return sb.toString();
        }

        private void setKeyStoreResult(KeyStoreObject ks) {
            this.keyStoreType = ks.type;
            this.keyStorePath = ks.path;
            this.keyStorePassword = ks.password;
            this.keyStore = ks.keyStore;
        }

        private void setTrustStoreResult(KeyStoreObject ks) {
            this.trustStoreType = ks.type;
            this.trustStorePath = ks.path;
            this.trustStorePassword = ks.password;
            this.trustStore = ks.keyStore;
        }
    }

    private class KeyStoreObject {
        private String type;
        private KeyStore keyStore;
        private Path path;
        private char[] password;

        private KeyStoreObject() {
        }
    }
}

