/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util.ssl;

import com.sos.commons.exception.SOSMissingDataException;
import com.sos.commons.util.keystore.KeyStoreReader;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.util.ssl.SslArguments;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

public class SslContextFactory {
    public static final String DEFAULT_PROTOCOL = "TLS";

    public static SSLContext create(ISOSLogger logger, SslArguments args) throws Exception {
        if (args == null) {
            throw new SOSMissingDataException("SSLArguments");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[SslContextFactory]%s", args);
        }
        SSLContext sslContext = SSLContext.getInstance(DEFAULT_PROTOCOL);
        if (args.getUntrustedSsl().isTrue()) {
            if (args.getTrustedSsl().isCustomStoresEnabled()) {
                logger.info("[SslContextFactory][%s=true][ignored]%s", args.getUntrustedSsl().getName(), args.getTrustedSslInfo());
            }
            if (args.getUntrustedSslVerifyCertificateHostname().isTrue()) {
                sslContext.init(null, SslContextFactory.getAcceptUntrustedCertificateTrustManagers(), new SecureRandom());
            } else {
                sslContext.init(null, SslContextFactory.getAcceptUntrustedCertificateAndHostnameTrustManagers(), new SecureRandom());
            }
        } else {
            KeyStoreReader.KeyStoreResult result;
            if (!args.getUntrustedSslVerifyCertificateHostname().isTrue()) {
                String name = args.getUntrustedSslVerifyCertificateHostname().getName();
                Boolean val = args.getUntrustedSslVerifyCertificateHostname().getValue();
                if (args.getUntrustedSslVerifyCertificateHostnameOppositeName() != null) {
                    name = args.getUntrustedSslVerifyCertificateHostnameOppositeName();
                    val = val == false;
                }
                logger.info("[SslContextFactory][ignored]%s=%s", name, val);
                args.getUntrustedSslVerifyCertificateHostname().setValue(true);
            }
            if ((result = KeyStoreReader.read(logger, args.getTrustedSsl())) == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("[SslContextFactory]use defaultJVMTrustManagers");
                }
                sslContext.init(null, SslContextFactory.getDefaultJVMTrustManagers(), new SecureRandom());
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("[SslContextFactory][KeyStoreResult]%s", result);
                }
                try {
                    sslContext.init(SslContextFactory.getKeyManagers(result.getKeyStore(), result.getKeyStorePassword()), SslContextFactory.getTrustManagers(result.getTrustStore()), new SecureRandom());
                }
                catch (Exception e) {
                    throw new Exception("[" + result.toString() + "][KeyManagerFactory.getDefaultAlgorithm()=" + KeyManagerFactory.getDefaultAlgorithm() + "]" + e, e);
                }
            }
        }
        CharSequence[] enabledProtocols = SslContextFactory.getFilteredEnabledProtocols(args);
        if (enabledProtocols.length > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("[SslContextFactory][setEnabledProtocols]%s", String.join((CharSequence)",", enabledProtocols));
            }
            sslContext.createSSLEngine().setEnabledProtocols((String[])enabledProtocols);
        }
        return sslContext;
    }

    public static String[] getFilteredEnabledProtocols(SslArguments args) {
        if (args == null || args.getEnabledProtocols().isEmpty()) {
            return new String[0];
        }
        return (String[])Arrays.stream(args.getEnabledProtocols().getValue().split(",")).map(String::trim).filter(s -> !s.isEmpty()).filter(s -> !s.equalsIgnoreCase(DEFAULT_PROTOCOL) && !s.equalsIgnoreCase("SSL")).toArray(String[]::new);
    }

    private static KeyManager[] getKeyManagers(KeyStore keystore, char[] keyPassword) throws Exception {
        KeyManagerFactory f = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        f.init(keystore, keyPassword);
        return f.getKeyManagers();
    }

    private static TrustManager[] getDefaultJVMTrustManagers() throws Exception {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init((KeyStore)null);
        return factory.getTrustManagers();
    }

    private static TrustManager[] getTrustManagers(KeyStore truststore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory f = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        f.init(truststore);
        return f.getTrustManagers();
    }

    private static TrustManager[] getAcceptUntrustedCertificateTrustManagers() throws Exception {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
    }

    private static TrustManager[] getAcceptUntrustedCertificateAndHostnameTrustManagers() throws Exception {
        return new TrustManager[]{new X509ExtendedTrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
    }
}

