/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.commons;

import com.sos.commons.util.SOSPathUtils;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.http.HttpUtils;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.vfs.exceptions.ProviderException;
import com.sos.yade.engine.commons.YADEProviderFile;
import com.sos.yade.engine.commons.delegators.YADESourceProviderDelegator;
import com.sos.yade.engine.commons.delegators.YADETargetProviderDelegator;
import com.sos.yade.engine.handlers.operations.copymove.YADECopyMoveOperationsConfig;
import com.sos.yade.engine.handlers.operations.copymove.file.commons.YADEFileNameInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class YADEDirectoryMapper {
    private final Set<String> sourceFilesDirectories = new HashSet<String>();
    private final Map<String, String> sourceTarget = new HashMap<String, String>();
    private Set<String> target;
    private Set<String> sourceReplacement;

    public void addSourceFileDirectory(String directoryPathWithoutTrailinSeparator) {
        if (SOSString.isEmpty((String)directoryPathWithoutTrailinSeparator)) {
            return;
        }
        this.sourceFilesDirectories.add(directoryPathWithoutTrailinSeparator);
    }

    public void tryCreateAllTargetDirectoriesBeforeOperation(ISOSLogger logger, YADECopyMoveOperationsConfig config, YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator) throws ProviderException {
        this.tryMapSourceTarget(logger, config, sourceDelegator, targetDelegator);
        boolean isDebugEnabled = logger.isDebugEnabled();
        Set<String> targetDirs = this.getTargetDirectoriesToCreate(logger, targetDelegator);
        if (targetDirs.size() > 0) {
            if (targetDelegator.getProvider().createDirectoriesIfNotExists(targetDirs)) {
                if (isDebugEnabled) {
                    logger.debug("[tryCreateAllTargetDirectoriesBeforeOperation][targetDirs=%s]created", new Object[]{targetDirs});
                }
            } else if (isDebugEnabled) {
                logger.debug("[tryCreateAllTargetDirectoriesBeforeOperation][targetDirs=%s][skip]already exist", new Object[]{targetDirs});
            }
        } else if (isDebugEnabled) {
            logger.debug((Object)"[tryCreateAllTargetDirectoriesBeforeOperation][skip]targetDirs is empty");
        }
    }

    public synchronized void tryCreateSourceDirectory(ISOSLogger logger, YADESourceProviderDelegator sourceDelegator, YADEProviderFile sourceFile, YADEFileNameInfo newNameInfo) throws ProviderException {
        if (newNameInfo.needsParent()) {
            String directory;
            if (this.sourceReplacement == null) {
                this.sourceReplacement = new HashSet<String>();
            }
            if (!this.sourceReplacement.contains(directory = sourceFile.getFinalFullPathParent(sourceDelegator))) {
                if (sourceDelegator.getProvider().createDirectoriesIfNotExists(directory)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("[tryCreateSourceDirectory][directory=%s]created", new Object[]{directory});
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug("[tryCreateSourceDirectory][directory=%s][skip]already exists", new Object[]{directory});
                }
                this.sourceReplacement.add(directory);
            }
        }
    }

    private void tryMapSourceTarget(ISOSLogger logger, YADECopyMoveOperationsConfig config, YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator) throws ProviderException {
        this.sourceTarget.clear();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[tryMapSourceTarget]sourceFilesDirectories[size=" + this.sourceFilesDirectories.size() + "]" + this.sourceFilesDirectories));
        }
        if (!config.getTarget().isCreateDirectoriesEnabled()) {
            for (String sourceDirectory : this.sourceFilesDirectories) {
                this.sourceTarget.put(sourceDirectory, this.getTargetDirectory(logger, targetDelegator, ""));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[tryMapSourceTarget][isCreateDirectoriesEnabled=false][sourceTarget]" + this.sourceTarget));
            }
            return;
        }
        if (config.getTarget().getCumulate() != null) {
            for (String sourceDirectory : this.sourceFilesDirectories) {
                this.sourceTarget.put(sourceDirectory, config.getTarget().getCumulate().getFile().getParentFullPath());
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[tryMapSourceTarget][cumulate][sourceTarget]" + this.sourceTarget));
            }
            return;
        }
        if (targetDelegator.getArgs().isReplacementEnabled()) {
            this.target = new HashSet<String>();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[tryMapSourceTarget][isReplacementEnabled=true][target]" + this.target));
            }
            return;
        }
        for (String sourceDirectory : this.sourceFilesDirectories) {
            this.sourceTarget.put(sourceDirectory, this.getTargetDirectory(logger, targetDelegator, this.getSourceDirectoryForMapping(logger, config, sourceDelegator, sourceDirectory)));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[tryMapSourceTarget][sourceTarget]" + this.sourceTarget));
        }
    }

    private String getSourceDirectoryForMapping(ISOSLogger logger, YADECopyMoveOperationsConfig config, YADESourceProviderDelegator sourceDelegator, String sourceDirectory) {
        String result;
        if (config.getSource().isRecursiveSelection()) {
            if (logger.isDebugEnabled()) {
                logger.debug("[getSourceDirectoryForMapping][1][isRecursiveSelection=true][configured=%s]%s", new Object[]{config.getSource().getDirectory(), sourceDirectory});
            }
            if (!SOSString.isEmpty((String)config.getSource().getDirectory()) && sourceDirectory.startsWith(config.getSource().getDirectory())) {
                if (sourceDirectory.equalsIgnoreCase(config.getSource().getDirectory())) {
                    result = "";
                    if (logger.isDebugEnabled()) {
                        logger.debug("    [getSourceDirectoryForMapping][2.1][result]%s", new Object[]{result});
                    }
                } else {
                    result = sourceDirectory.substring(config.getSource().getDirectory().length());
                    result = SOSString.trimStart((String)result, (String[])new String[]{config.getSource().getPathSeparator()});
                    if (logger.isDebugEnabled()) {
                        logger.debug("    [getSourceDirectoryForMapping][2.2][result]%s", new Object[]{result});
                    }
                    if (sourceDelegator.isHTTP()) {
                        result = HttpUtils.decodeUriPath((String)result);
                    }
                }
            } else {
                int colon = sourceDirectory.indexOf(":");
                if (colon > -1) {
                    if (SOSPathUtils.isAbsoluteURIPath((String)sourceDirectory)) {
                        result = sourceDirectory.replaceFirst("^[a-zA-Z]+://", "");
                        int slash = result.indexOf("/");
                        if (slash > -1) {
                            result = result.substring(slash + 1);
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("    [getSourceDirectoryForMapping][3.1][result]%s", new Object[]{result});
                        }
                        result = HttpUtils.decodeUriPath((String)result);
                    } else {
                        result = sourceDirectory.substring(colon + 1);
                        result = SOSString.trimStart((String)result, (String[])new String[]{config.getSource().getPathSeparator()});
                        if (logger.isDebugEnabled()) {
                            logger.debug("    [getSourceDirectoryForMapping][3.2][result]%s", new Object[]{result});
                        }
                    }
                } else if (SOSPathUtils.isAbsoluteWindowsUNCPath((String)sourceDirectory)) {
                    result = SOSString.trimStart((String)sourceDirectory, (String[])new String[]{config.getSource().getPathSeparator()});
                    if (logger.isDebugEnabled()) {
                        logger.debug("    [getSourceDirectoryForMapping][3.3][result]%s", new Object[]{result});
                    }
                } else {
                    result = SOSString.trimStart((String)sourceDirectory, (String[])new String[]{config.getSource().getPathSeparator()});
                    if (logger.isDebugEnabled()) {
                        logger.debug("    [getSourceDirectoryForMapping][3.4][result]%s", new Object[]{result});
                    }
                }
            }
        } else {
            result = "";
            if (logger.isDebugEnabled()) {
                logger.debug("    [getSourceDirectoryForMapping][4][result]%s", new Object[]{result});
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[getSourceDirectoryForMapping]result=" + result));
        }
        return result;
    }

    private String getTargetDirectory(ISOSLogger logger, YADETargetProviderDelegator targetDelegator, String sourceDirectoryPathForMapping) throws ProviderException {
        String targetPath;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[getTargetDirectory]sourceDirectoryPathForMapping=" + sourceDirectoryPathForMapping));
        }
        String string = targetPath = sourceDirectoryPathForMapping.isEmpty() ? "" : targetDelegator.getProvider().toPathStyle(sourceDirectoryPathForMapping);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[getTargetDirectory][1]targetPath=" + targetPath));
        }
        if (targetDelegator.getDirectory() != null) {
            if (targetPath.isEmpty()) {
                targetPath = targetDelegator.getDirectory();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("[getTargetDirectory][1.1]targetPath=" + targetPath));
                }
            } else {
                targetPath = targetDelegator.appendPath(targetDelegator.getDirectory(), targetPath);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("[getTargetDirectory][1.2]targetPath=" + targetPath));
                }
            }
        }
        if (targetPath == null) {
            throw new ProviderException("[" + targetDelegator.getLabel() + "]Target directory can't be evaluated");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[getTargetDirectory]targetPath=" + targetPath));
        }
        return targetPath;
    }

    private Set<String> getTargetDirectoriesToCreate(ISOSLogger logger, YADETargetProviderDelegator targetDelegator) throws ProviderException {
        if (this.target == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[getTargetDirectoriesToCreate][original]" + this.sourceTarget.values()));
            }
            Set<String> result = SOSPathUtils.selectDeepestLevelPaths(this.sourceTarget.values(), (String)targetDelegator.getProvider().getPathSeparator()).stream().filter(d -> !SOSString.isEmpty((String)d)).collect(Collectors.toSet());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[getTargetDirectoriesToCreate][deepestLevelPaths]" + result));
            }
            return result;
        }
        TreeSet<String> set = new TreeSet<String>();
        if (targetDelegator.getDirectory() != null) {
            set.add(targetDelegator.getDirectory());
            this.tryCreateTargetDirectory(logger, targetDelegator, targetDelegator.getDirectory(), false);
        }
        return set;
    }

    public String getTargetDirectory(ISOSLogger logger, YADECopyMoveOperationsConfig config, YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator, YADEProviderFile sourceFile, YADEFileNameInfo fileNameInfo) throws ProviderException {
        String targetDirectory;
        if (this.target == null) {
            targetDirectory = this.sourceTarget.get(sourceFile.getParentFullPath());
        } else {
            if (fileNameInfo.isAbsolutePath()) {
                targetDirectory = fileNameInfo.getParent();
            } else {
                targetDirectory = this.getTargetDirectory(logger, targetDelegator, this.getSourceDirectoryForMapping(logger, config, sourceDelegator, sourceFile.getParentFullPath()));
                if (!SOSString.isEmpty((String)fileNameInfo.getParent())) {
                    targetDirectory = targetDelegator.appendPath(targetDirectory, fileNameInfo.getParent());
                }
            }
            this.tryCreateTargetDirectory(logger, targetDelegator, targetDirectory, config.getTarget().isCreateDirectoriesEnabled());
        }
        return targetDirectory;
    }

    private synchronized void tryCreateTargetDirectory(ISOSLogger logger, YADETargetProviderDelegator targetDelegator, String targetDirectory, boolean createDirectory) throws ProviderException {
        if (!this.target.contains(targetDirectory)) {
            if (createDirectory) {
                if (targetDelegator.getProvider().createDirectoriesIfNotExists(targetDirectory)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("[tryCreateTargetDirectory][directory=%s]created", new Object[]{targetDirectory});
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug("[tryCreateTargetDirectory][directory=%s][skip]already exists", new Object[]{targetDirectory});
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("[tryCreateTargetDirectory][directory=%s][skip]create=false", new Object[]{targetDirectory});
            }
            this.target.add(targetDirectory);
        }
    }
}

