/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.commons;

import com.sos.commons.exception.SOSMissingDataException;
import com.sos.commons.util.SOSCollection;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.vfs.commons.AProviderArguments;
import com.sos.commons.vfs.commons.file.ProviderFile;
import com.sos.yade.commons.Yade;
import com.sos.yade.commons.result.YadeTransferResult;
import com.sos.yade.commons.result.YadeTransferResultEntry;
import com.sos.yade.commons.result.YadeTransferResultProtocol;
import com.sos.yade.commons.result.YadeTransferResultSerializer;
import com.sos.yade.engine.commons.YADEProviderFile;
import com.sos.yade.engine.commons.arguments.YADEJumpHostArguments;
import com.sos.yade.engine.commons.arguments.YADESourceTargetArguments;
import com.sos.yade.engine.commons.arguments.loaders.AYADEArgumentsLoader;
import java.io.Serializable;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public class YADEOutcomeHistory {
    public static String get(AYADEArgumentsLoader argsLoader, List<ProviderFile> files, Throwable exception) throws Exception {
        if (argsLoader == null) {
            throw new SOSMissingDataException("argsLoader");
        }
        YadeTransferResult result = new YadeTransferResult();
        result.setSource(YADEOutcomeHistory.getProviderResult(argsLoader.getSourceArgs()));
        result.setTarget(YADEOutcomeHistory.getProviderResult(argsLoader.getTargetArgs()));
        result.setJump(YADEOutcomeHistory.getJumpResult(argsLoader.getJumpHostArgs()));
        result.setSettings(YADEOutcomeHistory.getSettings(argsLoader.getArgs().getSettings()));
        result.setProfile((String)argsLoader.getArgs().getProfile().getValue());
        result.setOperation(YADEOutcomeHistory.getOperation(argsLoader.getArgs().getOperation()));
        result.setStart((Instant)argsLoader.getArgs().getStart().getValue());
        result.setEnd((Instant)argsLoader.getArgs().getEnd().getValue());
        result.setEntries(YADEOutcomeHistory.getEntries(argsLoader, files));
        if (exception != null) {
            result.setErrorMessage(exception.getMessage());
        }
        return new YadeTransferResultSerializer().serialize((Serializable)result);
    }

    private static YadeTransferResultProtocol getProviderResult(YADESourceTargetArguments args) {
        if (args == null || args.getProvider() == null) {
            return null;
        }
        YadeTransferResultProtocol result = new YadeTransferResultProtocol();
        result.setProtocol(YADEOutcomeHistory.toTransferProtocol((SOSArgument<AProviderArguments.Protocol>)args.getProvider().getProtocol()));
        result.setHost((String)args.getProvider().getHost().getValue());
        result.setPort(YADEOutcomeHistory.getPort((SOSArgument<Integer>)args.getProvider().getPort()));
        result.setAccount(YADEOutcomeHistory.getAccount((SOSArgument<String>)args.getProvider().getUser()));
        return result;
    }

    private static YadeTransferResultProtocol getJumpResult(YADEJumpHostArguments args) {
        if (args == null || args.getProvider() == null) {
            return null;
        }
        YadeTransferResultProtocol result = new YadeTransferResultProtocol();
        result.setProtocol(YADEOutcomeHistory.toTransferProtocol((SOSArgument<AProviderArguments.Protocol>)args.getProvider().getProtocol()));
        result.setHost((String)args.getProvider().getHost().getValue());
        result.setPort(YADEOutcomeHistory.getPort((SOSArgument<Integer>)args.getProvider().getPort()));
        result.setAccount(YADEOutcomeHistory.getAccount((SOSArgument<String>)args.getProvider().getUser()));
        return result;
    }

    private static String toTransferProtocol(SOSArgument<AProviderArguments.Protocol> arg) {
        Yade.TransferProtocol result = arg.isEmpty() ? Yade.TransferProtocol.LOCAL : Yade.TransferProtocol.fromValue((String)((AProviderArguments.Protocol)arg.getValue()).name());
        return result.value();
    }

    private static Integer getPort(SOSArgument<Integer> arg) {
        return arg.isEmpty() ? Integer.valueOf(0) : (Integer)arg.getValue();
    }

    private static String getAccount(SOSArgument<String> arg) {
        return arg.isEmpty() ? "." : (String)arg.getValue();
    }

    private static String getSettings(SOSArgument<Path> arg) {
        return arg.isEmpty() ? null : ((Path)arg.getValue()).toString();
    }

    private static String getOperation(SOSArgument<Yade.TransferOperation> arg) {
        return arg.isEmpty() ? Yade.TransferOperation.UNKNOWN.value() : ((Yade.TransferOperation)arg.getValue()).value();
    }

    private static List<YadeTransferResultEntry> getEntries(AYADEArgumentsLoader argsLoader, List<ProviderFile> files) {
        if (SOSCollection.isEmpty(files)) {
            return null;
        }
        ArrayList<YadeTransferResultEntry> entries = new ArrayList<YadeTransferResultEntry>();
        for (ProviderFile pf : files) {
            YADEProviderFile f = (YADEProviderFile)pf;
            YadeTransferResultEntry entry = new YadeTransferResultEntry();
            entry.setSource(f.getFinalFullPath());
            entry.setSize(f.getSize());
            entry.setModificationDate(f.getLastModifiedMillis());
            if (f.getTarget() == null) {
                entry.setState(YADEOutcomeHistory.getEntryState(f));
                entry.setIntegrityHash(f.getIntegrityHash());
            } else {
                entry.setTarget(f.getTarget().getFinalFullPath());
                entry.setState(YADEOutcomeHistory.getEntryState(f.getTarget()));
                if (f.getTarget().getIntegrityHash() == null) {
                    entry.setIntegrityHash(f.getIntegrityHash());
                } else {
                    entry.setIntegrityHash(f.getTarget().getIntegrityHash());
                }
            }
            entries.add(entry);
        }
        return entries;
    }

    private static String getEntryState(YADEProviderFile f) {
        return f.getState() == null ? Yade.TransferEntryState.UNKNOWN.value() : f.getState().value();
    }
}

