/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.commons.arguments.loaders;

import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.yade.engine.commons.arguments.YADEArguments;
import com.sos.yade.engine.commons.arguments.YADEClientArguments;
import com.sos.yade.engine.commons.arguments.YADEJumpHostArguments;
import com.sos.yade.engine.commons.arguments.YADENotificationArguments;
import com.sos.yade.engine.commons.arguments.YADESourceArguments;
import com.sos.yade.engine.commons.arguments.YADETargetArguments;
import com.sos.yade.engine.exceptions.YADEEngineSettingsLoadException;

public abstract class AYADEArgumentsLoader {
    private final YADEArguments args;
    private final YADEClientArguments clientArgs;
    private YADESourceArguments sourceArgs;
    private YADETargetArguments targetArgs;
    private YADEJumpHostArguments jumpHostArgs;
    private YADENotificationArguments notificationArgs;

    public AYADEArgumentsLoader() {
        this.args = new YADEArguments();
        this.clientArgs = new YADEClientArguments();
        this.sourceArgs = new YADESourceArguments();
        this.args.applyDefaultIfNullQuietly();
        this.clientArgs.applyDefaultIfNullQuietly();
        this.sourceArgs.applyDefaultIfNullQuietly();
    }

    protected AYADEArgumentsLoader(YADEArguments args, YADEClientArguments clientArgs, YADESourceArguments sourceArgs, YADETargetArguments targetArgs, YADEJumpHostArguments jumpHostArgs) {
        this.args = args;
        this.clientArgs = clientArgs;
        this.sourceArgs = sourceArgs;
        this.targetArgs = targetArgs;
        this.jumpHostArgs = jumpHostArgs;
    }

    public abstract AYADEArgumentsLoader load(ISOSLogger var1, Object ... var2) throws YADEEngineSettingsLoadException;

    public YADEArguments getArgs() {
        return this.args;
    }

    public YADEClientArguments getClientArgs() {
        return this.clientArgs;
    }

    public YADESourceArguments getSourceArgs() {
        return this.sourceArgs;
    }

    public void setSourceArgs(YADESourceArguments val) {
        this.sourceArgs = val;
    }

    public YADETargetArguments getTargetArgs() {
        return this.targetArgs;
    }

    public void setTargetArgs(YADETargetArguments val) {
        this.targetArgs = val;
    }

    public YADEJumpHostArguments getJumpHostArgs() {
        return this.jumpHostArgs;
    }

    public YADENotificationArguments getNotificationArgs() {
        return this.notificationArgs;
    }

    public void nullifyTargetArgs() {
        this.targetArgs = null;
    }

    public void initializeTargetArgsIfNull() {
        if (this.targetArgs == null) {
            this.targetArgs = new YADETargetArguments();
            this.targetArgs.applyDefaultIfNullQuietly();
        }
    }

    public void initializeJumpHostArgsIfNull() {
        if (this.jumpHostArgs == null) {
            this.jumpHostArgs = new YADEJumpHostArguments();
            this.jumpHostArgs.applyDefaultIfNullQuietly();
        }
    }

    public void initializeNotificationArgsIfNull() {
        if (this.notificationArgs == null) {
            this.notificationArgs = new YADENotificationArguments();
        }
    }
}

