/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.commons.arguments.loaders.xml;

import com.sos.commons.util.SOSDate;
import com.sos.commons.util.SOSMapVariableReplacer;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.util.arguments.base.SOSArgumentHelper;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.xml.SOSXML;
import com.sos.yade.engine.commons.arguments.loaders.AYADEArgumentsLoader;
import com.sos.yade.engine.commons.arguments.loaders.xml.YADEXMLGeneralHelper;
import com.sos.yade.engine.commons.arguments.loaders.xml.YADEXMLProfileHelper;
import com.sos.yade.engine.exceptions.YADEEngineSettingsLoadException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class YADEXMLArgumentsLoader
extends AYADEArgumentsLoader {
    public static final String INTERNAL_ATTRIBUTE_LABEL = "label";
    private SOSXML.SOSXMLXPath xpath;
    private Element root;
    private SOSMapVariableReplacer varReplacer;

    @Override
    public YADEXMLArgumentsLoader load(ISOSLogger logger, Object ... params) throws YADEEngineSettingsLoadException {
        if (params == null || params.length != 5) {
            throw new YADEEngineSettingsLoadException("missing settingsFile,profile,replacerMap,replaceCaseSensitive,replacerKeepUnresolvedVariables");
        }
        if (params[0] == null || !(params[0] instanceof Path)) {
            throw new YADEEngineSettingsLoadException("missing settingsFile");
        }
        if (params[1] == null || !(params[1] instanceof String)) {
            throw new YADEEngineSettingsLoadException("missing profile");
        }
        try {
            this.getArgs().getStart().setValue((Object)Instant.now());
            this.getArgs().getSettings().setValue((Object)((Path)params[0]));
            this.getArgs().getProfile().setValue((Object)((String)params[1]));
            this.root = SOSXML.parse((Path)((Path)this.getArgs().getSettings().getValue())).getDocumentElement();
            this.xpath = SOSXML.newXPath();
            Node profile = this.xpath.selectNode(this.root, "Profiles/Profile[@profile_id='" + (String)this.getArgs().getProfile().getValue() + "']");
            if (profile == null) {
                throw new YADEEngineSettingsLoadException("[" + this.getArgs().getSettings().getValue() + "][profile=" + (String)this.getArgs().getProfile().getValue() + "]not found");
            }
            this.varReplacer = new SOSMapVariableReplacer((Map)params[2], ((Boolean)params[3]).booleanValue(), ((Boolean)params[4]).booleanValue());
            YADEXMLGeneralHelper.parse(this, this.xpath.selectNode(this.root, "General"));
            YADEXMLProfileHelper.parse(this, profile);
            if (logger.isDebugEnabled()) {
                logger.debug("[%s][load][duration]%s", new Object[]{YADEXMLArgumentsLoader.class.getSimpleName(), SOSDate.getDuration((Instant)((Instant)this.getArgs().getStart().getValue()), (Instant)Instant.now())});
            }
        }
        catch (YADEEngineSettingsLoadException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new YADEEngineSettingsLoadException(e.toString(), e);
        }
        finally {
            this.root = null;
            this.xpath = null;
            this.varReplacer = null;
        }
        return this;
    }

    protected Element getRoot() {
        return this.root;
    }

    protected SOSXML.SOSXMLXPath getXPath() {
        return this.xpath;
    }

    protected String getValue(Node node, String attrName) {
        if (node == null) {
            return null;
        }
        String attrValue = SOSXML.getAttributeValue((Node)node, (String)attrName);
        if (attrValue == null) {
            return null;
        }
        return this.varReplacer.replaceAllVars(attrValue);
    }

    protected String getValue(Node node) {
        if (node == null) {
            return null;
        }
        return this.varReplacer.replaceAllVars(SOSXML.getTrimmedValue((Node)node));
    }

    protected void setIntegerArgumentValue(SOSArgument<Integer> arg, Node node) {
        if (arg == null || node == null) {
            return;
        }
        arg.setValue((Object)Integer.parseInt(this.getValue(node)));
    }

    protected void setBooleanArgumentValue(SOSArgument<Boolean> arg, Node node) {
        if (arg == null || node == null) {
            return;
        }
        arg.setValue((Object)Boolean.parseBoolean(this.getValue(node)));
    }

    protected void setOppositeBooleanArgumentValue(SOSArgument<Boolean> arg, Node node) {
        if (arg == null || node == null) {
            return;
        }
        arg.setValue((Object)(!Boolean.parseBoolean(this.getValue(node)) ? 1 : 0));
    }

    protected void setStringArgumentValue(SOSArgument<String> arg, Node node) {
        if (arg == null || node == null) {
            return;
        }
        arg.setValue((Object)this.getValue(node));
    }

    protected void setListStringArgumentValue(SOSArgument<List<String>> arg, Node node) {
        if (arg == null || node == null) {
            return;
        }
        SOSArgumentHelper.setListStringArgumentValue(arg, (String)this.getValue(node));
    }

    protected void setListPathArgumentValue(SOSArgument<List<Path>> arg, Node node) {
        if (arg == null || node == null) {
            return;
        }
        SOSArgumentHelper.setListPathArgumentValue(arg, (String)this.getValue(node));
    }

    protected void setPathArgumentValue(SOSArgument<Path> arg, Node node) {
        if (arg == null || node == null) {
            return;
        }
        arg.setValue((Object)Path.of(this.getValue(node), new String[0]));
    }
}

