/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.handlers.operations.copymove;

import com.sos.commons.vfs.commons.IProvider;
import com.sos.commons.vfs.ftp.FTPProvider;
import com.sos.commons.vfs.ftp.commons.FTPProviderArguments;
import com.sos.yade.commons.Yade;
import com.sos.yade.engine.commons.arguments.YADEArguments;
import com.sos.yade.engine.commons.delegators.YADESourceProviderDelegator;
import com.sos.yade.engine.commons.delegators.YADETargetProviderDelegator;
import com.sos.yade.engine.commons.helpers.YADEParallelExecutorFactory;
import com.sos.yade.engine.handlers.operations.copymove.file.commons.YADETargetProviderFile;

public class YADECopyMoveOperationsConfig {
    private final Source source;
    private final Target target;
    private final Yade.TransferOperation operation;
    private final String integrityHashAlgorithm;
    private final int bufferSize;
    private final int maxRetries;
    private final int parallelism;
    private final boolean transactional;
    private final boolean checkFileSize;

    public YADECopyMoveOperationsConfig(Yade.TransferOperation operation, YADEArguments args, YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator, int sourceFilesSize) {
        this.operation = operation;
        this.transactional = args.getTransactional().isTrue();
        this.integrityHashAlgorithm = (String)sourceDelegator.getArgs().getIntegrityHashAlgorithm().getValue();
        this.bufferSize = (Integer)args.getBufferSize().getValue();
        this.source = new Source(sourceDelegator);
        this.target = new Target(targetDelegator);
        this.maxRetries = this.getMaxRetries(sourceDelegator, targetDelegator);
        this.parallelism = this.getParallelism(args, sourceFilesSize);
        this.checkFileSize = this.getCheckFileSize(sourceDelegator, targetDelegator, this.target);
    }

    public boolean isMoveOperation() {
        return Yade.TransferOperation.MOVE.equals((Object)this.operation);
    }

    private boolean isCopyOperation() {
        return Yade.TransferOperation.COPY.equals((Object)this.operation);
    }

    private int getMaxRetries(YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator) {
        if (sourceDelegator.getArgs().isRetryOnConnectionErrorEnabled() && targetDelegator.getArgs().isRetryOnConnectionErrorEnabled()) {
            return Math.max((Integer)sourceDelegator.getArgs().getConnectionErrorRetryCountMax().getValue(), (Integer)targetDelegator.getArgs().getConnectionErrorRetryCountMax().getValue());
        }
        if (sourceDelegator.getArgs().isRetryOnConnectionErrorEnabled()) {
            return (Integer)sourceDelegator.getArgs().getConnectionErrorRetryCountMax().getValue();
        }
        if (targetDelegator.getArgs().isRetryOnConnectionErrorEnabled()) {
            return (Integer)targetDelegator.getArgs().getConnectionErrorRetryCountMax().getValue();
        }
        return 1;
    }

    private boolean getCheckFileSize(YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator, Target target) {
        if (!targetDelegator.getArgs().getCheckSize().isTrue()) {
            return false;
        }
        if (target.getCompress() != null) {
            return false;
        }
        if (!this.isBinaryMode((IProvider)sourceDelegator.getProvider())) {
            return false;
        }
        return this.isBinaryMode((IProvider)targetDelegator.getProvider());
    }

    private boolean isBinaryMode(IProvider provider) {
        if (!(provider instanceof FTPProvider)) {
            return true;
        }
        return ((FTPProviderArguments)((FTPProvider)provider).getArguments()).isBinaryTransferMode();
    }

    public String getIntegrityHashAlgorithm() {
        return this.integrityHashAlgorithm;
    }

    public String getIntegrityHashFileExtensionWithDot() {
        return "." + this.integrityHashAlgorithm;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    private int getParallelism(YADEArguments args, int sourceFilesSize) {
        if (this.target.getCumulate() != null) {
            return 1;
        }
        return YADEParallelExecutorFactory.getParallelism(args, sourceFilesSize);
    }

    public boolean processFilesSequentially() {
        return this.parallelism == 1;
    }

    public boolean isCheckFileSizeEnabled() {
        return this.checkFileSize;
    }

    public boolean isTransactionalEnabled() {
        return this.transactional;
    }

    public Source getSource() {
        return this.source;
    }

    public Target getTarget() {
        return this.target;
    }

    public class Source {
        private final String directory;
        private final String pathSeparator;
        private final boolean recursiveSelection;
        private final boolean replacemenEnabled;
        private final boolean checkIntegrityHash;
        private final boolean needsFilePostProcessing;

        private Source(YADESourceProviderDelegator sourceDelegator) {
            this.directory = sourceDelegator.getDirectory() == null ? "" : sourceDelegator.getDirectory();
            this.pathSeparator = sourceDelegator.getProvider().getPathSeparator();
            this.recursiveSelection = sourceDelegator.getArgs().getRecursive().isTrue();
            this.replacemenEnabled = YADECopyMoveOperationsConfig.this.isCopyOperation() && sourceDelegator.getArgs().isReplacementEnabled();
            this.checkIntegrityHash = sourceDelegator.getArgs().getCheckIntegrityHash().isTrue();
            this.needsFilePostProcessing = !YADECopyMoveOperationsConfig.this.isMoveOperation() && sourceDelegator.getArgs().isReplacementEnabled() || sourceDelegator.getArgs().getCommands().isFilePostProcessingEnabled();
        }

        public String getDirectory() {
            return this.directory;
        }

        public String getPathSeparator() {
            return this.pathSeparator;
        }

        public boolean isRecursiveSelection() {
            return this.recursiveSelection;
        }

        public boolean isReplacementEnabled() {
            return this.replacemenEnabled;
        }

        public boolean isCheckIntegrityHashEnabled() {
            return this.checkIntegrityHash;
        }

        public boolean needsFilePostProcessing() {
            return this.needsFilePostProcessing;
        }
    }

    public class Target {
        private final Cumulate cumulate;
        private final Compress compress;
        private final Atomic atomic;
        private final boolean createDirectories;
        private final boolean replacementEnabled;
        private final boolean overwriteFiles;
        private final boolean append;
        private final boolean createIntegrityHashFile;
        private final boolean keepModificationDate;
        private final boolean needsFilePostProcessing;

        private Target(YADETargetProviderDelegator targetDelegator) {
            this.compress = this.initializeCompress(targetDelegator);
            this.atomic = this.initializeAtomic(targetDelegator);
            this.cumulate = this.initializeCumulate(targetDelegator, this.compress, this.atomic);
            this.createDirectories = targetDelegator.getArgs().getCreateDirectories().isTrue();
            this.replacementEnabled = this.cumulate == null && targetDelegator.getArgs().isReplacementEnabled();
            this.overwriteFiles = this.cumulate == null && targetDelegator.getArgs().getOverwriteFiles().isTrue();
            this.append = this.cumulate == null ? targetDelegator.getArgs().getAppendFiles().isTrue() : true;
            this.createIntegrityHashFile = targetDelegator.getArgs().getCreateIntegrityHashFile().isTrue();
            this.keepModificationDate = targetDelegator.getArgs().getKeepModificationDate().isTrue();
            this.needsFilePostProcessing = targetDelegator.getArgs().getCommands().isFilePostProcessingEnabled() || this.atomic != null || this.replacementEnabled || this.keepModificationDate || this.createIntegrityHashFile;
        }

        private Cumulate initializeCumulate(YADETargetProviderDelegator targetDelegator, Compress compress, Atomic atomic) {
            if (!targetDelegator.getArgs().isCumulateFilesEnabled()) {
                return null;
            }
            return new Cumulate(targetDelegator, compress, atomic);
        }

        private Compress initializeCompress(YADETargetProviderDelegator targetDelegator) {
            if (!targetDelegator.getArgs().isCompressFilesEnabled()) {
                return null;
            }
            return new Compress((String)targetDelegator.getArgs().getCompressedFileExtension().getValue());
        }

        private Atomic initializeAtomic(YADETargetProviderDelegator targetDelegator) {
            if (!YADECopyMoveOperationsConfig.this.transactional && !targetDelegator.getArgs().isAtomicityEnabled()) {
                return null;
            }
            if (YADECopyMoveOperationsConfig.this.transactional && targetDelegator.isJumpHost() && !targetDelegator.getArgs().isAtomicityEnabled()) {
                return null;
            }
            return new Atomic((String)targetDelegator.getArgs().getAtomicPrefix().getValue(), (String)targetDelegator.getArgs().getAtomicSuffix().getValue());
        }

        public Cumulate getCumulate() {
            return this.cumulate;
        }

        public Compress getCompress() {
            return this.compress;
        }

        public Atomic getAtomic() {
            return this.atomic;
        }

        public boolean isReplacementEnabled() {
            return this.replacementEnabled;
        }

        public boolean isCreateDirectoriesEnabled() {
            return this.createDirectories;
        }

        public boolean isOverwriteFilesEnabled() {
            return this.overwriteFiles;
        }

        public boolean isAppendEnabled() {
            return this.append;
        }

        public boolean isCreateIntegrityHashFileEnabled() {
            return this.createIntegrityHashFile;
        }

        public boolean isKeepModificationDateEnabled() {
            return this.keepModificationDate;
        }

        public boolean isDeleteCumulativeFileEnabled() {
            return this.cumulate != null && this.cumulate.deleteFile;
        }

        public boolean needsFilePostProcessing() {
            return this.needsFilePostProcessing;
        }
    }

    public class Compress {
        private final String fileExtension;

        private Compress(String fileExtension) {
            this.fileExtension = this.getFileExtension(fileExtension);
        }

        public String getFileExtension() {
            return this.fileExtension;
        }

        private String getFileExtension(String extension) {
            return extension.startsWith(".") ? extension : "." + extension;
        }
    }

    public class Cumulate {
        private static final String EXISTING_FILE_SUFFIX_IF_COMPRESS = ".tmp.orig";
        private static final String TRANSFER_FILE_SUFFIX_IF_COMPRESS = ".tmp.current";
        private final YADETargetProviderFile file;
        private final String fileSeparator;
        private final boolean deleteFile;

        private Cumulate(YADETargetProviderDelegator targetDelegator, Compress compress, Atomic atomic) {
            this.file = this.getFile(targetDelegator, compress, atomic);
            this.fileSeparator = (String)targetDelegator.getArgs().getCumulativeFileSeparator().getValue();
            this.deleteFile = targetDelegator.getArgs().getCumulativeFileDelete().isTrue();
        }

        private YADETargetProviderFile getFile(YADETargetProviderDelegator targetDelegator, Compress compress, Atomic atomic) {
            YADETargetProviderFile tmp = new YADETargetProviderFile(targetDelegator, this.getFileFullPath(targetDelegator));
            String finalFileName = tmp.getName();
            Object transferFileName = finalFileName;
            if (compress != null) {
                transferFileName = finalFileName + TRANSFER_FILE_SUFFIX_IF_COMPRESS;
            } else if (atomic != null) {
                transferFileName = atomic.getPrefix() + finalFileName + atomic.getSuffix();
            }
            String transferFileFullPath = targetDelegator.appendPath(tmp.getParentFullPath(), (String)transferFileName);
            YADETargetProviderFile file = new YADETargetProviderFile(targetDelegator, transferFileFullPath);
            file.setFinalFullPath(targetDelegator, finalFileName);
            return file;
        }

        private String getFileFullPath(YADETargetProviderDelegator targetDelegator) {
            String path = targetDelegator.getProvider().toPathStyle((String)targetDelegator.getArgs().getCumulativeFileName().getValue());
            if (!targetDelegator.getProvider().isAbsolutePath(path) && targetDelegator.getDirectory() != null) {
                path = targetDelegator.appendPath(targetDelegator.getDirectory(), path);
            }
            return path;
        }

        public YADETargetProviderFile getFile() {
            return this.file;
        }

        public String getTmpFullPathOfExistingFileForDecompress() {
            return this.file.getFinalFullPath() + EXISTING_FILE_SUFFIX_IF_COMPRESS;
        }

        public String getFileSeparator() {
            return this.fileSeparator;
        }
    }

    public class Atomic {
        private final String prefix;
        private final String suffix;

        private Atomic(String prefix, String suffix) {
            this.prefix = Atomic.getOrDefault(prefix, "");
            this.suffix = this.prefix.isEmpty() ? Atomic.getOrDefault(suffix, "~") : Atomic.getOrDefault(suffix, "");
        }

        private static String getOrDefault(String val, String defaultVal) {
            return val == null ? defaultVal : val.trim();
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getSuffix() {
            return this.suffix;
        }
    }
}

