/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.handlers.source;

import com.sos.commons.util.SOSCollection;
import com.sos.commons.util.arguments.base.SOSArgumentHelper;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.vfs.commons.file.ProviderFile;
import com.sos.yade.engine.commons.YADEProviderFile;
import com.sos.yade.engine.commons.arguments.YADESourceArguments;
import com.sos.yade.engine.commons.delegators.YADESourceProviderDelegator;
import com.sos.yade.engine.commons.helpers.YADEClientHelper;
import com.sos.yade.engine.exceptions.YADEEngineSourceSteadyFilesException;
import java.util.List;
import java.util.stream.Collectors;

public class YADESourceFilesSteadyStateChecker {
    public static void check(ISOSLogger logger, YADESourceProviderDelegator sourceDelegator, List<ProviderFile> sourceFiles) throws YADEEngineSourceSteadyFilesException {
        YADESourceArguments args = sourceDelegator.getArgs();
        if (!args.isCheckSteadyStateEnabled()) {
            return;
        }
        if (SOSCollection.isEmpty(sourceFiles)) {
            return;
        }
        boolean steady = true;
        int total = (Integer)args.getCheckSteadyCount().getValue();
        long interval = SOSArgumentHelper.asSeconds(args.getCheckSteadyStateInterval(), (long)1L);
        for (int i = 0; i < total; ++i) {
            steady = true;
            String position = String.format("checkSteadyCount=%s of %s", i + 1, total);
            logger.info((Object)String.format("[%s][%s][wait]%ss...", sourceDelegator.getLabel(), position, interval));
            YADEClientHelper.waitFor(interval);
            for (ProviderFile sourceFile : sourceFiles) {
                if (YADESourceFilesSteadyStateChecker.checkFileSteadyState(sourceDelegator, sourceFile)) continue;
                steady = false;
                break;
            }
            if (steady) {
                logger.info("[%s][%s][all files seem steady]extra waiting %ss for late comers", new Object[]{sourceDelegator.getLabel(), position, interval});
                YADEClientHelper.waitFor(interval);
                for (ProviderFile sourceFile : sourceFiles) {
                    if (YADESourceFilesSteadyStateChecker.checkFileSteadyState(sourceDelegator, sourceFile)) continue;
                    steady = false;
                    break;
                }
            }
            if (!steady) continue;
            logger.info("[%s][%s][break]all files are steady", new Object[]{sourceDelegator.getLabel(), position});
            break;
        }
        if (!steady) {
            throw new YADEEngineSourceSteadyFilesException("[not all files are steady][not steady]" + sourceFiles.stream().filter(f -> !((YADEProviderFile)((Object)f)).getSteady().isSteady()).map(f -> f.getFullPath()).collect(Collectors.joining(";")));
        }
    }

    private static boolean checkFileSteadyState(YADESourceProviderDelegator sourceDelegator, ProviderFile providerFile) throws YADEEngineSourceSteadyFilesException {
        YADEProviderFile file = (YADEProviderFile)providerFile;
        if (file.getSteady().isSteady()) {
            return true;
        }
        try {
            String path = providerFile.getFullPath();
            providerFile = sourceDelegator.getProvider().rereadFileIfExists(providerFile);
            if (providerFile == null) {
                throw new YADEEngineSourceSteadyFilesException("[" + path + "]not found");
            }
            file = (YADEProviderFile)providerFile;
            file.getSteady().checkIfSteady();
            return file.getSteady().isSteady();
        }
        catch (YADEEngineSourceSteadyFilesException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new YADEEngineSourceSteadyFilesException(e);
        }
    }
}

