/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.ftp;

import com.sos.commons.exception.SOSRequiredArgumentMissingException;
import com.sos.commons.util.SOSCollection;
import com.sos.commons.util.SOSDate;
import com.sos.commons.util.SOSPathUtils;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.util.beans.SOSCommandResult;
import com.sos.commons.util.beans.SOSEnv;
import com.sos.commons.util.beans.SOSTimeout;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.util.proxy.socket.ProxySocketFactory;
import com.sos.commons.util.ssl.SslArguments;
import com.sos.commons.util.ssl.SslContextFactory;
import com.sos.commons.vfs.commons.AProvider;
import com.sos.commons.vfs.commons.AProviderArguments;
import com.sos.commons.vfs.commons.file.ProviderFile;
import com.sos.commons.vfs.commons.file.selection.ProviderFileSelection;
import com.sos.commons.vfs.exceptions.ProviderAuthenticationException;
import com.sos.commons.vfs.exceptions.ProviderClientNotInitializedException;
import com.sos.commons.vfs.exceptions.ProviderConnectException;
import com.sos.commons.vfs.exceptions.ProviderException;
import com.sos.commons.vfs.exceptions.ProviderInitializationException;
import com.sos.commons.vfs.exceptions.ProviderNoSuchFileException;
import com.sos.commons.vfs.ftp.commons.FTPProtocolCommandListener;
import com.sos.commons.vfs.ftp.commons.FTPProtocolReply;
import com.sos.commons.vfs.ftp.commons.FTPProviderArguments;
import com.sos.commons.vfs.ftp.commons.FTPProviderUtils;
import com.sos.commons.vfs.ftp.commons.FTPSProviderArguments;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import javax.net.SocketFactory;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPCmd;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPHTTPClient;
import org.apache.commons.net.ftp.FTPSClient;

public class FTPProvider
extends AProvider<FTPProviderArguments> {
    private final boolean isFTPS = AProviderArguments.Protocol.FTPS.equals(((FTPProviderArguments)((Object)this.getArguments())).getProtocol().getValue());
    private FTPClient client;
    private boolean autodetectUTF8Enabled = true;

    public FTPProvider(ISOSLogger logger, FTPProviderArguments args) throws ProviderInitializationException {
        super(logger, args, new SOSArgument[0]);
        this.setAccessInfo(args.getAccessInfo());
    }

    @Override
    public String getPathSeparator() {
        return "/";
    }

    @Override
    public boolean isAbsolutePath(String path) {
        return SOSPathUtils.isAbsoluteUnixPath((String)path);
    }

    @Override
    public String normalizePath(String path) {
        return this.toPathStyle(Path.of(path, new String[0]).normalize().toString());
    }

    @Override
    public void connect() throws ProviderConnectException {
        if (SOSString.isEmpty((String)((String)((FTPProviderArguments)((Object)this.getArguments())).getHost().getValue()))) {
            throw new ProviderConnectException((Throwable)new SOSRequiredArgumentMissingException("host"));
        }
        try {
            this.getLogger().info((Object)this.getConnectMsg());
            this.client = this.createClient();
            this.client.connect((String)((FTPProviderArguments)((Object)this.getArguments())).getHost().getValue(), ((Integer)((FTPProviderArguments)((Object)this.getArguments())).getPort().getValue()).intValue());
            FTPProtocolReply reply = new FTPProtocolReply(this.client);
            if (!reply.isPositiveReply()) {
                throw new Exception(String.format("%s[connect][FTP server refused connection]%s", this.getLogPrefix(), reply));
            }
            this.postConnectOperations();
            try {
                this.client.login((String)((FTPProviderArguments)((Object)this.getArguments())).getUser().getValue(), (String)((FTPProviderArguments)((Object)this.getArguments())).getPassword().getValue());
            }
            catch (IOException e) {
                throw new ProviderAuthenticationException(e);
            }
            reply = new FTPProtocolReply(this.client);
            if (!reply.isPositiveReply()) {
                throw new Exception(String.format("%s[login]%s", this.getLogPrefix(), reply));
            }
            this.postLoginOperations();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("%s[connect][after login][printWorkingDirectory]%s", new Object[]{this.getLogPrefix(), this.client.printWorkingDirectory()});
            }
            this.getLogger().info((Object)this.getConnectedMsg(this.getConnectedInfos()));
        }
        catch (Throwable e) {
            if (this.isConnected()) {
                this.disconnect();
            }
            throw new ProviderConnectException(String.format("[%s]", this.getAccessInfo()), e);
        }
    }

    @Override
    public boolean isConnected() {
        if (this.client == null) {
            return false;
        }
        if (this.client.isConnected()) {
            try {
                this.client.sendNoOp();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void disconnect() {
        if (this.client == null) {
            return;
        }
        try {
            this.client.logout();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.client.disconnect();
            this.client = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getLogger().info((Object)this.getDisconnectedMsg());
    }

    @Override
    public List<ProviderFile> selectFiles(ProviderFileSelection selection) throws ProviderException {
        this.validatePrerequisites("selectFiles");
        selection = ProviderFileSelection.createIfNull(selection);
        selection.setFileTypeChecker(fileRepresentator -> {
            if (fileRepresentator == null) {
                return false;
            }
            FTPFile r = (FTPFile)fileRepresentator;
            return r.isFile() && ((EnumSet)((FTPProviderArguments)((Object)((Object)this.getArguments()))).getValidFileTypes().getValue()).contains((Object)AProviderArguments.FileType.REGULAR) || r.isSymbolicLink() && ((EnumSet)((FTPProviderArguments)((Object)((Object)this.getArguments()))).getValidFileTypes().getValue()).contains((Object)AProviderArguments.FileType.SYMLINK);
        });
        String directory = SOSString.isEmpty((String)selection.getConfig().getDirectory()) ? "/" : selection.getConfig().getDirectory();
        try {
            if (!this.client.changeWorkingDirectory(directory)) {
                throw new ProviderNoSuchFileException(this.getDirectoryNotFoundMsg(directory));
            }
            ArrayList<ProviderFile> result = new ArrayList<ProviderFile>();
            FTPProviderUtils.selectFiles(this, selection, directory, result);
            return result;
        }
        catch (Exception e) {
            throw new ProviderException(this.getPathOperationPrefix(directory), e);
        }
    }

    @Override
    public boolean exists(String path) throws ProviderException {
        this.validatePrerequisites("exists", path, "path");
        try {
            this.client.sendCommand(FTPCmd.SIZE, path);
            FTPProtocolReply reply = new FTPProtocolReply(this.client);
            if (reply.isFileStatusReply()) {
                return true;
            }
            if (!reply.isFileUnavailableReply() && !reply.isPositiveReply()) {
                throw new Exception(String.format("%s[exists]%s", this.getLogPrefix(), reply));
            }
            return false;
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public boolean createDirectoriesIfNotExists(String path) throws ProviderException {
        this.validatePrerequisites("createDirectoriesIfNotExists", path, "path");
        try {
            String dir = this.normalizePath(path);
            if (this.client.changeWorkingDirectory(dir)) {
                return false;
            }
            ArrayDeque<String> parentsToCreate = new ArrayDeque<String>();
            String parent = SOSPathUtils.getParentPath((String)dir, (String)this.getPathSeparator());
            while (!(SOSString.isEmpty((String)parent) || parent.equals(dir) || this.client.changeWorkingDirectory(parent))) {
                parentsToCreate.push(parent);
                parent = SOSPathUtils.getParentPath((String)parent, (String)this.getPathSeparator());
            }
            while (!parentsToCreate.isEmpty()) {
                this.createDirectory((String)parentsToCreate.pop());
            }
            this.createDirectory(path);
            return true;
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public boolean deleteIfExists(String path) throws ProviderException {
        this.validatePrerequisites("deleteIfExists", path, "path");
        try {
            Object[] files = this.client.listFiles(path);
            FTPProtocolReply reply = new FTPProtocolReply(this.client);
            if (!reply.isPositiveReply()) {
                throw new IOException(reply.toString());
            }
            if (SOSCollection.isEmpty((Object[])files)) {
                return false;
            }
            Object file = files[0];
            boolean deleted = false;
            if (file.isDirectory()) {
                FTPProviderUtils.deleteDirectoryFilesRecursively(this.client, this.getPathSeparator(), path);
                deleted = this.client.removeDirectory(path);
                if (!deleted) {
                    throw new Exception(String.format("[failed to remove directory][%s]%s", path, new FTPProtocolReply(this.client)));
                }
            } else if (file.isFile() && !(deleted = this.client.deleteFile(path))) {
                throw new Exception(String.format("[failed to delete file][%s]%s", path, new FTPProtocolReply(this.client)));
            }
            return deleted;
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public boolean deleteFileIfExists(String path) throws ProviderException {
        this.validatePrerequisites("deleteFileIfExists", path, "path");
        try {
            if (!this.client.deleteFile(path)) {
                FTPProtocolReply reply = new FTPProtocolReply(this.client);
                if (this.isReplyBasedOnFileNotFound(reply, path)) {
                    return false;
                }
                throw new Exception(String.format("[failed]%s", reply));
            }
            return true;
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public boolean renameFileIfSourceExists(String source, String target) throws ProviderException {
        this.validatePrerequisites("renameFileIfSourceExists", source, "source");
        this.validateArgument("renameFileIfSourceExists", target, "target");
        try {
            if (!this.client.rename(source, target)) {
                FTPProtocolReply reply = new FTPProtocolReply(this.client);
                if (this.isReplyBasedOnFileNotFound(reply, target)) {
                    return false;
                }
                throw new Exception(String.format("[failed]%s", reply));
            }
            return true;
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(source + "->" + target), e);
        }
    }

    @Override
    public ProviderFile getFileIfExists(String path) throws ProviderException {
        this.validatePrerequisites("getFileIfExists", path, "path");
        try {
            return this.createProviderFile(path, FTPProviderUtils.getFTPFile("getFileIfExists", this.client, path));
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getFileContentIfExists(String path) throws ProviderException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void writeFile(String path, String content) throws ProviderException {
        this.validatePrerequisites("writeFile", path, "path");
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));){
            if (!this.client.storeFile(path, (InputStream)inputStream)) {
                throw new ProviderException(String.format("%s[failed to write file]%s", this.getPathOperationPrefix(path), new FTPProtocolReply(this.client)));
            }
        }
        catch (ProviderException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public void setFileLastModifiedFromMillis(String path, long milliseconds) throws ProviderException {
        this.validatePrerequisites("setFileLastModifiedFromMillis", path, path);
        this.validateModificationTime(path, milliseconds);
        try {
            if (!this.client.setModificationTime(path, FTPProviderUtils.millisecondsToModificationTimeString(milliseconds))) {
                String featReplyMessage;
                FTPProtocolReply mfmtReply = new FTPProtocolReply(this.client);
                if (this.client.features()) {
                    FTPProtocolReply featuresReply = new FTPProtocolReply(this.client);
                    featReplyMessage = String.format("[FEAT]Server supports the following features: %s", featuresReply);
                } else {
                    featReplyMessage = "[FEAT]Server was queried to check support for the MFMT command, but did not respond with any supported features. It is likely that MFMT is not supported.";
                }
                throw new ProviderException(String.format("%s[failed][MFMT]%s %s", this.getPathOperationPrefix(path), mfmtReply, featReplyMessage));
            }
        }
        catch (ProviderException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public InputStream getInputStream(String path) throws ProviderException {
        this.validatePrerequisites("getInputStream", path, "path");
        try {
            InputStream is = this.client.retrieveFileStream(path);
            if (is == null) {
                throw new ProviderException(String.format("%s[failed to open InputStream]%s", this.getPathOperationPrefix(path), new FTPProtocolReply(this.client)));
            }
            return is;
        }
        catch (ProviderException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public void onInputStreamClosed(String path) throws ProviderException {
        this.validatePrerequisites("onInputStreamClosed", path, "path");
        try {
            if (!this.client.completePendingCommand()) {
                throw new IOException(new FTPProtocolReply(this.client).toString());
            }
        }
        catch (IOException e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public OutputStream getOutputStream(String path, boolean append) throws ProviderException {
        this.validatePrerequisites("getOutputStream", path, "path");
        try {
            return append ? this.client.appendFileStream(path) : this.client.storeFileStream(path);
        }
        catch (IOException e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public void onOutputStreamClosed(String path) throws ProviderException {
        this.validatePrerequisites("onOutputStreamClosed", path, "path");
        try {
            if (!this.client.completePendingCommand()) {
                throw new IOException(new FTPProtocolReply(this.client).toString());
            }
        }
        catch (IOException e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SOSCommandResult executeCommand(String command, SOSTimeout timeout, SOSEnv env) {
        SOSCommandResult result = new SOSCommandResult(command);
        if (this.client == null) {
            return result;
        }
        try {
            if (timeout != null) {
                this.client.setControlKeepAliveTimeout(timeout.toDuration());
            }
            this.client.sendCommand(command);
            FTPProtocolReply reply = new FTPProtocolReply(this.client);
            if (!reply.isPositiveReply()) {
                throw new Exception(reply.toString());
            }
            result.setStdOut(reply.getText());
        }
        catch (Throwable e) {
            result.setException(e);
        }
        finally {
            if (timeout != null) {
                this.client.setControlKeepAliveTimeout(this.getKeepAliveTimeout());
            }
        }
        return result;
    }

    @Override
    public SOSCommandResult cancelCommands() {
        return null;
    }

    @Override
    public void validatePrerequisites(String method) throws ProviderException {
        if (this.client == null) {
            throw new ProviderClientNotInitializedException(this.getLogPrefix() + method + "FTPClient");
        }
    }

    public void debugCommand(String command) {
        if (!this.getLogger().isDebugEnabled() || ((FTPProviderArguments)((Object)this.getArguments())).getProtocolCommandListener().isTrue()) {
            return;
        }
        this.getLogger().debug("%s[%s]%s", new Object[]{this.getLogPrefix(), command, new FTPProtocolReply(this.client)});
    }

    public ProviderFile createProviderFile(String path, FTPFile file) {
        if (file == null) {
            return null;
        }
        return this.createProviderFile(path, file.getSize(), file.getTimestamp() == null ? -1L : file.getTimestamp().getTimeInMillis());
    }

    public FTPClient getClient() {
        return this.client;
    }

    public boolean isReplyBasedOnFileNotFound(FTPProtocolReply reply, String path) throws ProviderException {
        if (reply.isFileUnavailableReply()) {
            return this.exists(path);
        }
        return false;
    }

    private FTPClient createClient() throws Exception {
        FTPClient client = this.isFTPS ? this.createFTPSClient() : this.createFTPClient();
        this.applyPreConnectSettings(client);
        return client;
    }

    private FTPClient createFTPClient() throws Exception {
        FTPClient client = null;
        if (this.getProxyConfig() == null) {
            client = new FTPClient();
        } else if (Proxy.Type.SOCKS.equals((Object)this.getProxyConfig().getProxy().type())) {
            client = new FTPClient();
            client.setSocketFactory((SocketFactory)new ProxySocketFactory(this.getProxyConfig()));
        } else {
            client = SOSString.isEmpty((String)this.getProxyConfig().getUser()) ? new FTPHTTPClient(this.getProxyConfig().getHost(), this.getProxyConfig().getPort()) : new FTPHTTPClient(this.getProxyConfig().getHost(), this.getProxyConfig().getPort(), this.getProxyConfig().getUser(), this.getProxyConfig().getPassword());
        }
        return client;
    }

    private FTPClient createFTPSClient() throws Exception {
        FTPSProviderArguments args = (FTPSProviderArguments)((Object)this.getArguments());
        FTPSClient client = null;
        if (args.getSsl().getTrustedSsl().isCustomStoresEnabled()) {
            client = new FTPSClient(args.isSecurityModeImplicit(), SslContextFactory.create((ISOSLogger)this.getLogger(), (SslArguments)args.getSsl()));
        } else {
            client = new FTPSClient(args.isSecurityModeImplicit());
            if (!args.getSsl().getUntrustedSslVerifyCertificateHostname().isTrue()) {
                client.setHostnameVerifier(null);
                this.logIfHostnameVerificationDisabled(args.getSsl());
            }
        }
        if (this.getProxyConfig() != null) {
            client.setProxy(this.getProxyConfig().getProxy());
        }
        return client;
    }

    private void applyPreConnectSettings(FTPClient client) {
        this.setProtocolCommandListener(client);
        client.setConnectTimeout(((FTPProviderArguments)((Object)this.getArguments())).getConnectTimeoutAsMillis());
        client.setAutodetectUTF8(this.autodetectUTF8Enabled);
    }

    private void postConnectOperations() throws Exception {
        this.client.setControlKeepAliveTimeout(this.getKeepAliveTimeout());
    }

    private void postLoginOperations() throws Exception {
        this.features();
        this.postLoginOperationsIfFTPS();
        if (((FTPProviderArguments)((Object)this.getArguments())).getPassiveMode().isTrue()) {
            this.client.pasv();
            FTPProtocolReply reply = new FTPProtocolReply(this.client);
            if (!reply.isPositiveReply()) {
                throw new ProviderException(String.format("%s[pasv]%s", this.getLogPrefix(), reply));
            }
            this.client.enterLocalPassiveMode();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("%s[%s=true]pasv executed successfully", new Object[]{this.getLogPrefix(), ((FTPProviderArguments)((Object)this.getArguments())).getPassiveMode().getName()});
            }
        }
        if (((FTPProviderArguments)((Object)this.getArguments())).isBinaryTransferMode() ? !this.client.setFileType(2) : !this.client.setFileType(0)) {
            throw new ProviderException(String.format("%s[%s]%s", this.getLogPrefix(), ((FTPProviderArguments)((Object)this.getArguments())).getTransferMode().getValue(), new FTPProtocolReply(this.client)));
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("%s[%s=%s]successfully set", new Object[]{this.getLogPrefix(), ((FTPProviderArguments)((Object)this.getArguments())).getTransferMode().getName(), ((FTPProviderArguments)((Object)this.getArguments())).getTransferModeValue()});
        }
        this.client.sendNoOp();
    }

    private void features() {
        block12: {
            if (this.autodetectUTF8Enabled) {
                if (this.getLogger().isDebugEnabled()) {
                    try {
                        if (this.client.features()) {
                            this.getLogger().debug("%s[FEAT][Server supports the following features]%s", new Object[]{this.getLogPrefix(), new FTPProtocolReply(this.client)});
                            break block12;
                        }
                        this.getLogger().debug("%s[FEAT]Server did not return any supported features in response to FEAT.", new Object[]{this.getLogPrefix()});
                    }
                    catch (IOException e) {
                        this.getLogger().debug("%s[FEAT][exception]%s", new Object[]{this.getLogPrefix(), e});
                    }
                }
            } else {
                try {
                    if (this.client.features()) {
                        this.getLogger().debug("%s[setControlEncoding][FEAT][Server supports the following features]%s", new Object[]{this.getLogPrefix(), new FTPProtocolReply(this.client)});
                        String charsetUTF8 = StandardCharsets.UTF_8.name();
                        if (this.client.hasFeature("UTF8") || this.client.hasFeature(charsetUTF8)) {
                            this.client.setControlEncoding(charsetUTF8);
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("%s[setControlEncoding]%s", new Object[]{this.getLogPrefix(), charsetUTF8});
                            }
                        }
                    } else {
                        this.getLogger().debug("%s[setControlEncoding][FEAT]Server did not return any supported features in response to FEAT.", new Object[]{this.getLogPrefix()});
                    }
                }
                catch (IOException e) {
                    this.getLogger().debug("%s[setControlEncoding][FEAT][exception]%s", new Object[]{this.getLogPrefix(), e});
                }
            }
        }
    }

    private void postLoginOperationsIfFTPS() throws Exception {
        if (this.isFTPS) {
            this.client.enterLocalPassiveMode();
            this.debugCommand("enterLocalPassiveMode");
            FTPSClient ftps = (FTPSClient)this.client;
            try {
                ftps.execPBSZ(0L);
                this.debugCommand("execPBSZ(0)");
            }
            catch (Throwable e) {
                this.getLogger().warn((Object)("[execPBSZ(0)]" + e));
            }
            try {
                ftps.execPROT("P");
                this.debugCommand("execPROT(P)");
            }
            catch (Throwable e) {
                this.getLogger().warn((Object)("[execPROT(P)]" + e));
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("%s[getEnabledProtocols]%s", new Object[]{this.getLogPrefix(), Arrays.asList(((FTPSClient)this.client).getEnabledProtocols())});
            }
        }
    }

    private String getConnectedInfos() {
        if (this.client == null) {
            return "";
        }
        ArrayList<CallSite> l = new ArrayList<CallSite>();
        if (this.client.getConnectTimeout() > 0) {
            l.add((CallSite)((Object)("ConnectTimeout=" + AProvider.millis2string(this.client.getConnectTimeout()))));
        }
        if (this.client.getControlKeepAliveTimeoutDuration() != null) {
            l.add((CallSite)((Object)("KeepAliveTimeout=" + SOSDate.getDuration((Duration)this.client.getControlKeepAliveTimeoutDuration()))));
        }
        if (!this.isFTPS) {
            l.add((CallSite)((Object)(((FTPProviderArguments)((Object)this.getArguments())).getPassiveMode().getName() + "=" + ((FTPProviderArguments)((Object)this.getArguments())).getPassiveMode().getValue())));
        }
        l.add((CallSite)((Object)(((FTPProviderArguments)((Object)this.getArguments())).getTransferMode().getName() + "=" + ((FTPProviderArguments)((Object)this.getArguments())).getTransferModeValue())));
        String serverInfo = this.getServerInfo();
        return SOSString.isEmpty((String)serverInfo) ? String.join((CharSequence)", ", l) : "[" + serverInfo + "]" + String.join((CharSequence)", ", l);
    }

    private String getServerInfo() {
        try {
            return "Server " + this.client.getSystemType();
        }
        catch (IOException e) {
            return "";
        }
    }

    private void validatePrerequisites(String method, String argValue, String msg) throws ProviderException {
        this.validatePrerequisites(method);
        this.validateArgument(method, argValue, msg);
    }

    private Duration getKeepAliveTimeout() {
        return Duration.ofSeconds(((FTPProviderArguments)((Object)this.getArguments())).getKeepAliveTimeoutAsSeconds());
    }

    private void setProtocolCommandListener(FTPClient client) {
        if (((FTPProviderArguments)((Object)this.getArguments())).getProtocolCommandListener().isTrue() || FTPProviderUtils.isCommandListenerEnvVarSet()) {
            client.addProtocolCommandListener((ProtocolCommandListener)new FTPProtocolCommandListener(this.getLogger()));
            this.getLogger().debug((Object)(this.getLogPrefix() + "ProtocolCommandListener added"));
        }
    }

    private void createDirectory(String path) throws Exception {
        if (!this.client.makeDirectory(path)) {
            throw new Exception(String.format("%s[failed to create directory][%s]%s", this.getLogPrefix(), path, new FTPProtocolReply(this.client)));
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("%s[createDirectory][%s]created", new Object[]{this.getLogPrefix(), path});
        }
    }
}

