/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.smb.smbj;

import com.hierynomus.msdtyp.AccessMask;
import com.hierynomus.msdtyp.FileTime;
import com.hierynomus.msfscc.FileAttributes;
import com.hierynomus.msfscc.fileinformation.FileAllInformation;
import com.hierynomus.msfscc.fileinformation.FileBasicInformation;
import com.hierynomus.msfscc.fileinformation.FileIdBothDirectoryInformation;
import com.hierynomus.msfscc.fileinformation.FileSettableInformation;
import com.hierynomus.mssmb2.SMB2CreateDisposition;
import com.hierynomus.mssmb2.SMB2CreateOptions;
import com.hierynomus.mssmb2.SMB2ShareAccess;
import com.hierynomus.mssmb2.SMBApiException;
import com.hierynomus.smbj.share.DiskShare;
import com.hierynomus.smbj.share.File;
import com.sos.commons.vfs.commons.file.ProviderFile;
import com.sos.commons.vfs.commons.file.selection.ProviderFileSelection;
import com.sos.commons.vfs.smb.smbj.SMBJProvider;
import java.util.HashSet;
import java.util.List;

public class SMBJProviderUtils {
    protected static boolean deleteIfExists(DiskShare share, String smbPath) {
        FileAllInformation info = null;
        try {
            info = share.getFileInformation(smbPath);
        }
        catch (SMBApiException e) {
            return false;
        }
        if (SMBJProviderUtils.isDirectory(info)) {
            share.rmdir(smbPath, true);
        } else {
            share.rm(smbPath);
        }
        return true;
    }

    protected static boolean deleteFileIfExists(DiskShare share, String smbPath) {
        if (!share.fileExists(smbPath)) {
            return false;
        }
        share.rm(smbPath);
        return true;
    }

    protected static boolean renameFileIfSourceExists(DiskShare share, String smbSourcePath, String smbTargetPath, boolean accessMaskMaximumAllowed) {
        if (share.fileExists(smbSourcePath)) {
            try (File sourceFile = SMBJProviderUtils.openExistingFileWithRenameAccess(accessMaskMaximumAllowed, share, smbSourcePath);){
                sourceFile.rename(smbTargetPath, true);
            }
            return true;
        }
        return false;
    }

    protected static void setFileLastModifiedFromMillis(DiskShare share, String smbPath, long milliseconds, boolean accessMaskMaximumAllowed) {
        try (File file = SMBJProviderUtils.openExistingFileWithChangeAttributeAccess(accessMaskMaximumAllowed, share, smbPath);){
            FileBasicInformation info = file.getFileInformation().getBasicInformation();
            FileTime lastModified = FileTime.ofEpochMillis((long)milliseconds);
            file.setFileInformation((FileSettableInformation)new FileBasicInformation(info.getCreationTime(), info.getLastAccessTime(), lastModified, lastModified, info.getFileAttributes()));
        }
    }

    protected static File openFileWithReadAccess(boolean accessMaskMaximumAllowed, DiskShare share, String smbPath) {
        return SMBJProviderUtils.openFile(accessMaskMaximumAllowed, share, smbPath, AccessMask.GENERIC_READ, SMB2CreateDisposition.FILE_OPEN);
    }

    protected static File openExistingFileWithChangeAttributeAccess(boolean accessMaskMaximumAllowed, DiskShare share, String smbPath) {
        return SMBJProviderUtils.openFile(accessMaskMaximumAllowed, share, smbPath, AccessMask.GENERIC_WRITE, SMB2CreateDisposition.FILE_OPEN);
    }

    protected static File openFileWithWriteAccess(boolean accessMaskMaximumAllowed, DiskShare share, String smbPath, boolean append) {
        SMB2CreateDisposition cd = append ? SMB2CreateDisposition.FILE_OPEN_IF : SMB2CreateDisposition.FILE_OVERWRITE_IF;
        return SMBJProviderUtils.openFile(accessMaskMaximumAllowed, share, smbPath, AccessMask.GENERIC_WRITE, cd);
    }

    protected static File openFile(boolean accessMaskMaximumAllowed, DiskShare share, String smbPath, AccessMask accessMask, SMB2CreateDisposition createDisposition) {
        HashSet<AccessMask> ams = new HashSet<AccessMask>();
        if (accessMaskMaximumAllowed) {
            ams.add(AccessMask.MAXIMUM_ALLOWED);
        } else {
            ams.add(accessMask);
        }
        HashSet sa = new HashSet();
        sa.addAll(SMB2ShareAccess.ALL);
        HashSet<SMB2CreateOptions> co = new HashSet<SMB2CreateOptions>();
        co.add(SMB2CreateOptions.FILE_WRITE_THROUGH);
        return share.openFile(smbPath, ams, null, sa, createDisposition, co);
    }

    protected static File openExistingFileWithRenameAccess(boolean accessMaskMaximumAllowed, DiskShare share, String smbPath) {
        HashSet<AccessMask> ams = new HashSet<AccessMask>();
        if (accessMaskMaximumAllowed) {
            ams.add(AccessMask.MAXIMUM_ALLOWED);
        } else {
            ams.add(AccessMask.GENERIC_WRITE);
            ams.add(AccessMask.DELETE);
        }
        HashSet<FileAttributes> fa = new HashSet<FileAttributes>();
        fa.add(FileAttributes.FILE_ATTRIBUTE_NORMAL);
        HashSet sa = new HashSet();
        sa.addAll(SMB2ShareAccess.ALL);
        HashSet<SMB2CreateOptions> co = new HashSet<SMB2CreateOptions>();
        co.add(SMB2CreateOptions.FILE_NON_DIRECTORY_FILE);
        return share.openFile(smbPath, ams, fa, sa, SMB2CreateDisposition.FILE_OPEN, co);
    }

    protected static int selectFiles(SMBJProvider provider, ProviderFileSelection selection, String directoryPath, List<ProviderFile> result, DiskShare share, int counterAdded) throws Exception {
        List infos = share.list(directoryPath);
        for (FileIdBothDirectoryInformation info : infos) {
            ProviderFile file;
            String fullPath;
            if (selection.maxFilesExceeded(counterAdded)) {
                return counterAdded;
            }
            String name = info.getFileName();
            if (name == null || ".".equals(name) || "..".equals(name)) continue;
            String string = fullPath = directoryPath.isEmpty() ? name : directoryPath + provider.getPathSeparator() + name;
            if (SMBJProviderUtils.isDirectory(info)) {
                if (!selection.getConfig().isRecursive() || !selection.checkDirectory(fullPath)) continue;
                counterAdded = SMBJProviderUtils.selectFiles(provider, selection, fullPath, result, share, counterAdded);
                continue;
            }
            if (!selection.checkFileName(name) || !selection.isValidFileType(info) || !selection.checkProviderFileMinMaxSize(file = provider.createProviderFile(fullPath, info))) continue;
            file.setIndex(++counterAdded);
            result.add(file);
            if (!provider.getLogger().isDebugEnabled()) continue;
            provider.getLogger().debug((Object)(provider.getPathOperationPrefix(file.getFullPath()) + "added"));
        }
        return counterAdded;
    }

    protected static boolean isDirectory(FileIdBothDirectoryInformation info) {
        return FileAttributes.FILE_ATTRIBUTE_DIRECTORY.getValue() == info.getFileAttributes();
    }

    protected static boolean isDirectory(FileAllInformation info) {
        return info.getStandardInformation().isDirectory();
    }
}

