/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.ssh.sshj;

import com.sos.commons.credentialstore.CredentialStoreArguments;
import com.sos.commons.credentialstore.keepass.SOSKeePassDatabase;
import com.sos.commons.exception.SOSRequiredArgumentMissingException;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.util.proxy.ProxyConfig;
import com.sos.commons.util.proxy.socket.ProxySocketFactory;
import com.sos.commons.vfs.exceptions.ProviderAuthenticationException;
import com.sos.commons.vfs.ssh.commons.SSHAuthMethod;
import com.sos.commons.vfs.ssh.commons.SSHProviderArguments;
import com.sos.commons.vfs.ssh.sshj.SSHJRequiredAuthenticationPartialResult;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.SocketFactory;
import net.schmizz.keepalive.KeepAliveProvider;
import net.schmizz.keepalive.KeepAliveRunner;
import net.schmizz.sshj.Config;
import net.schmizz.sshj.DefaultConfig;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.Service;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.method.AuthKeyboardInteractive;
import net.schmizz.sshj.userauth.method.AuthMethod;
import net.schmizz.sshj.userauth.method.AuthPassword;
import net.schmizz.sshj.userauth.method.AuthPublickey;
import net.schmizz.sshj.userauth.method.ChallengeResponseProvider;
import net.schmizz.sshj.userauth.method.PasswordResponseProvider;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.Resource;
import org.linguafranca.pwdb.Entry;

public class SSHJClientFactory {
    private static final String SSH_MSG_UNIMPLEMENTED = "SSH_MSG_UNIMPLEMENTED";

    protected static SSHClient createAuthenticatedClient(ISOSLogger logger, SSHProviderArguments args, ProxyConfig proxyConfig) throws Exception {
        SSHClient client = SSHJClientFactory.create(args, proxyConfig);
        client.connect((String)args.getHost().getValue(), ((Integer)args.getPort().getValue()).intValue());
        SSHJClientFactory.authenticate(logger, args, client);
        if (!args.getServerAliveInterval().isEmpty()) {
            client.getConnection().getKeepAlive().setKeepAliveInterval(args.getServerAliveIntervalAsSeconds());
            if (!args.getServerAliveCountMax().isEmpty()) {
                ((KeepAliveRunner)client.getConnection().getKeepAlive()).setMaxAliveCount(((Integer)args.getServerAliveCountMax().getValue()).intValue());
            }
        }
        return client;
    }

    private static SSHClient create(SSHProviderArguments args, ProxyConfig proxyConfig) throws Exception {
        DefaultConfig config = new DefaultConfig();
        if (!args.getServerAliveInterval().isEmpty()) {
            config.setKeepAliveProvider(KeepAliveProvider.KEEP_ALIVE);
        }
        SSHClient client = new SSHClient((Config)config);
        SSHJClientFactory.setHostKeyVerifier(args, client);
        SSHJClientFactory.setCompression(args, client);
        client.setRemoteCharset((Charset)args.getRemoteCharset().getValue());
        client.setTimeout(args.getSocketTimeoutAsMillis());
        client.setConnectTimeout(args.getConnectTimeoutAsMillis());
        if (proxyConfig != null) {
            client.setSocketFactory((SocketFactory)new ProxySocketFactory(proxyConfig));
        }
        return client;
    }

    private static void authenticate(ISOSLogger logger, SSHProviderArguments args, SSHClient client) throws ProviderAuthenticationException {
        try {
            if (!args.getPreferredAuthentications().isEmpty()) {
                SSHJClientFactory.usePreferredAuthentications(args, client);
            } else if (!args.getRequiredAuthentications().isEmpty()) {
                SSHJClientFactory.useRequiredAuthentications(logger, args, client);
            } else {
                SSHJClientFactory.useAuthMethodAuthentication(args, client);
            }
        }
        catch (ProviderAuthenticationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProviderAuthenticationException(e);
        }
    }

    private static void usePreferredAuthentications(SSHProviderArguments args, SSHClient client) throws Exception {
        LinkedList<Object> methods = new LinkedList<Object>();
        for (SSHAuthMethod am : (List)args.getPreferredAuthentications().getValue()) {
            switch (am) {
                case PUBLICKEY: {
                    methods.add(SSHJClientFactory.getAuthPublickey(args, client));
                    break;
                }
                case PASSWORD: {
                    methods.add(SSHJClientFactory.getAuthPassword(args));
                    break;
                }
                case KEYBOARD_INTERACTIVE: {
                    methods.add(SSHJClientFactory.getAuthKeyboardInteractive(args));
                }
            }
        }
        client.auth((String)args.getUser().getValue(), methods);
    }

    private static void useRequiredAuthentications(ISOSLogger logger, SSHProviderArguments args, SSHClient client) throws Exception {
        ArrayList<SSHAuthMethod> used = new ArrayList<SSHAuthMethod>();
        LinkedHashMap<SSHAuthMethod, SSHJRequiredAuthenticationPartialResult> result = new LinkedHashMap<SSHAuthMethod, SSHJRequiredAuthenticationPartialResult>();
        boolean hadPartialSuccess = false;
        String configured = SOSString.join((Collection)((Collection)args.getRequiredAuthentications().getValue()), (String)",", m -> m.toString()).toLowerCase();
        try {
            for (SSHAuthMethod method : (List)args.getRequiredAuthentications().getValue()) {
                switch (method) {
                    case PUBLICKEY: {
                        used.add(method);
                        result.put(method, SSHJClientFactory.partialRequiredAuthentication(args, client, (AuthMethod)SSHJClientFactory.getAuthPublickey(args, client)));
                        break;
                    }
                    case PASSWORD: {
                        used.add(method);
                        result.put(method, SSHJClientFactory.partialRequiredAuthentication(args, client, (AuthMethod)SSHJClientFactory.getAuthPassword(args)));
                        break;
                    }
                    case KEYBOARD_INTERACTIVE: {
                        used.add(method);
                        result.put(method, SSHJClientFactory.partialRequiredAuthentication(args, client, (AuthMethod)SSHJClientFactory.getAuthKeyboardInteractive(args)));
                    }
                }
            }
        }
        catch (Exception e2) {
            try {
                StringBuilder sb = new StringBuilder("Required authentication is configured (").append(configured).append("). ");
                if (((List)args.getRequiredAuthentications().getValue()).size() > 1 && used.size() != result.size() && !hadPartialSuccess) {
                    List failed = used.stream().filter(m -> !result.containsKey(m)).collect(Collectors.toList());
                    sb.append("Not accepted (").append(SOSString.join(failed, (String)",", m -> m.toString()).toLowerCase()).append("). ");
                    if (e2.getMessage() != null && e2.getMessage().contains(SSH_MSG_UNIMPLEMENTED)) {
                        sb.append("The server does not appear to support multiple authentications.");
                    }
                }
                throw new ProviderAuthenticationException(sb.toString(), e2);
            }
            catch (Throwable throwable) {
                hadPartialSuccess = client.getUserAuth().hadPartialSuccess();
                if (logger.isDebugEnabled()) {
                    logger.debug("[useRequiredAuthentications][used]%s", new Object[]{used});
                    logger.debug("[useRequiredAuthentications][result]%s", new Object[]{result});
                }
                throw throwable;
            }
        }
        hadPartialSuccess = client.getUserAuth().hadPartialSuccess();
        if (logger.isDebugEnabled()) {
            logger.debug("[useRequiredAuthentications][used]%s", new Object[]{used});
            logger.debug("[useRequiredAuthentications][result]%s", new Object[]{result});
        }
        if (client.isAuthenticated()) {
            if (((List)args.getRequiredAuthentications().getValue()).size() > 1 && !hadPartialSuccess) {
                sb = new StringBuilder("Required authentication is configured (").append(configured).append("). ");
                failed = result.entrySet().stream().filter(e -> !((SSHJRequiredAuthenticationPartialResult)e.getValue()).isAuthenticated()).map(e -> (SSHAuthMethod)((Object)((Object)e.getKey()))).collect(Collectors.toList());
                sb.append("Not accepted (").append(SOSString.join(failed, (String)",", m -> m.toString()).toLowerCase()).append("). ");
                sb.append("The server does not appear to support multiple authentications.");
                throw new ProviderAuthenticationException(sb.toString());
            }
        } else {
            sb = new StringBuilder("Required authentication is configured (").append(configured).append("). ");
            if (hadPartialSuccess) {
                String serverResponded = String.join((CharSequence)", ", client.getUserAuth().getAllowedMethods());
                if (!SOSString.isEmpty((String)serverResponded)) {
                    sb.append("Server responded: ").append(serverResponded).append(". ");
                }
                sb.append("Note: The client might have tried the methods in a different order than expected by the server.");
            } else {
                failed = result.entrySet().stream().filter(e -> !((SSHJRequiredAuthenticationPartialResult)e.getValue()).isAuthenticated()).map(e -> (SSHAuthMethod)((Object)((Object)e.getKey()))).collect(Collectors.toList());
                sb.append("Not accepted (").append(SOSString.join(failed, (String)",", m -> m.toString()).toLowerCase()).append("). ");
            }
            throw new ProviderAuthenticationException(sb.toString());
        }
    }

    private static SSHJRequiredAuthenticationPartialResult partialRequiredAuthentication(SSHProviderArguments args, SSHClient client, AuthMethod methodImpl) throws Exception {
        boolean authenticate = client.getUserAuth().authenticate((String)args.getUser().getValue(), (Service)client.getConnection(), methodImpl, client.getTransport().getTimeoutMs());
        return new SSHJRequiredAuthenticationPartialResult(authenticate, client.getUserAuth().hadPartialSuccess());
    }

    private static void useAuthMethodAuthentication(SSHProviderArguments args, SSHClient client) throws Exception {
        if (args.getAuthMethod().getValue() == null) {
            throw new SOSRequiredArgumentMissingException(args.getAuthMethod().getName());
        }
        AuthPassword method = null;
        switch ((SSHAuthMethod)((Object)args.getAuthMethod().getValue())) {
            case PUBLICKEY: {
                method = SSHJClientFactory.getAuthPublickey(args, client);
                break;
            }
            case PASSWORD: {
                method = SSHJClientFactory.getAuthPassword(args);
                break;
            }
            case KEYBOARD_INTERACTIVE: {
                method = SSHJClientFactory.getAuthKeyboardInteractive(args);
            }
        }
        client.auth((String)args.getUser().getValue(), new AuthMethod[]{method});
    }

    private static AuthPassword getAuthPassword(SSHProviderArguments args) throws Exception {
        if (args.getPassword().isEmpty()) {
            throw new SOSRequiredArgumentMissingException(args.getPassword().getName());
        }
        return new AuthPassword(SSHJClientFactory.getPasswordFinder((String)args.getPassword().getValue()));
    }

    private static AuthKeyboardInteractive getAuthKeyboardInteractive(SSHProviderArguments args) throws Exception {
        if (args.getPassword().isEmpty()) {
            throw new SOSRequiredArgumentMissingException(args.getPassword().getName());
        }
        return new AuthKeyboardInteractive((ChallengeResponseProvider)new PasswordResponseProvider(SSHJClientFactory.getPasswordFinder((String)args.getPassword().getValue())));
    }

    private static AuthPublickey getAuthPublickey(SSHProviderArguments args, SSHClient client) throws Exception {
        KeyProvider keyProvider = null;
        if (SSHJClientFactory.useKeyProviderFromKeepass(args)) {
            keyProvider = SSHJClientFactory.getKeyProviderFromKeepass(client, args.getCredentialStore(), (String)args.getPassphrase().getValue());
        } else {
            if (SOSString.isEmpty((String)((String)args.getAuthFile().getValue()))) {
                throw new SOSRequiredArgumentMissingException(args.getAuthFile().getName());
            }
            Path authFile = Paths.get((String)args.getAuthFile().getValue(), new String[0]);
            keyProvider = args.getPassphrase().isEmpty() ? client.loadKeys(authFile.toFile().getCanonicalPath()) : client.loadKeys(authFile.toFile().getCanonicalPath(), (String)args.getPassphrase().getValue());
        }
        return new AuthPublickey(keyProvider);
    }

    private static void setHostKeyVerifier(SSHProviderArguments args, SSHClient client) throws IOException {
        if (((Boolean)args.getStrictHostkeyChecking().getValue()).booleanValue()) {
            if (args.getHostkeyLocation().isEmpty()) {
                client.loadKnownHosts();
            } else {
                client.loadKnownHosts(((Path)args.getHostkeyLocation().getValue()).toFile());
            }
        } else {
            client.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
        }
    }

    private static void setCompression(SSHProviderArguments args, SSHClient client) throws Exception {
        if (((Boolean)args.getUseZlibCompression().getValue()).booleanValue()) {
            client.useCompression();
        }
    }

    private static PasswordFinder getPasswordFinder(final String password) {
        return new PasswordFinder(){

            public char[] reqPassword(Resource<?> resource) {
                return (char[])password.toCharArray().clone();
            }

            public boolean shouldRetry(Resource<?> resource) {
                return false;
            }
        };
    }

    private static boolean useKeyProviderFromKeepass(SSHProviderArguments args) {
        if (args.getCredentialStore() == null) {
            return false;
        }
        CredentialStoreArguments cs = args.getCredentialStore();
        return cs.getKeepassDatabase() != null && cs.getKeepassDatabaseEntry() != null && !SOSString.isEmpty((String)cs.getKeepassAttachmentPropertyName());
    }

    private static KeyProvider getKeyProviderFromKeepass(SSHClient sshClient, CredentialStoreArguments args, String passphrase) throws Exception {
        SOSKeePassDatabase kd = args.getKeepassDatabase();
        if (kd == null) {
            throw new Exception("[keepass]keepass_database property is null");
        }
        Entry ke = args.getKeepassDatabaseEntry();
        if (ke == null) {
            throw new Exception(String.format("[keepass][can't find database entry]attachment property name=%s", args.getKeepassAttachmentPropertyName()));
        }
        try {
            String pk = new String(kd.getAttachment(ke, args.getKeepassAttachmentPropertyName()), "UTF-8");
            return sshClient.loadKeys(pk, null, SOSString.isEmpty((String)passphrase) ? null : SSHJClientFactory.getPasswordFinder(passphrase));
        }
        catch (Exception e) {
            String keePassPath = ke.getPath() + "@" + args.getKeepassAttachmentPropertyName();
            throw new Exception(String.format("[keepass][%s]%s", keePassPath, e.toString()), e);
        }
    }
}

