/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.azure.commons;

import com.sos.commons.httpclient.azure.commons.auth.blob.AzureBlobStorageClientAuthMethod;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.util.arguments.base.SOSArgumentHelper;
import com.sos.commons.util.http.HttpUtils;
import com.sos.commons.util.ssl.SslArguments;
import com.sos.commons.vfs.commons.AProviderArguments;
import com.sos.commons.vfs.exceptions.ProviderInitializationException;
import com.sos.commons.vfs.http.commons.HTTPProviderUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class AzureBlobStorageProviderArguments
extends AProviderArguments {
    private SslArguments ssl;
    private SOSArgument<String> serviceEndpoint = new SOSArgument("service_endpoint", true);
    private SOSArgument<String> containerName = new SOSArgument("container_name", false);
    private SOSArgument<String> apiVersion = new SOSArgument("api_version", false, (Object)"2020-10-02");
    private SOSArgument<AzureBlobStorageClientAuthMethod> authMethod = new SOSArgument("auth_method", false, (Object)AzureBlobStorageClientAuthMethod.PUBLIC);
    private SOSArgument<String> accountKey = new SOSArgument("account_key", false, SOSArgument.DisplayMode.MASKED);
    private SOSArgument<String> sasToken = new SOSArgument("sas_token", false, SOSArgument.DisplayMode.MASKED);
    private SOSArgument<List<String>> httpHeaders = new SOSArgument("http_headers", false);

    public AzureBlobStorageProviderArguments() {
        this.getProtocol().setValue((Object)AProviderArguments.Protocol.AZURE_BLOB_STORAGE);
        this.getPort().setDefaultValue((Object)443);
        this.getConnectTimeout().setDefaultValue((Object)"30s");
    }

    @Override
    public String getAccessInfo() throws ProviderInitializationException {
        int indx;
        String host;
        URI baseURI = null;
        try {
            baseURI = HTTPProviderUtils.getBaseURI(this.getHost(), this.getPort());
        }
        catch (Exception e) {
            throw new ProviderInitializationException(e);
        }
        if (this.getUser().isEmpty() && (host = baseURI.getHost()) != null && (indx = host.indexOf(".")) > 0) {
            this.getUser().setValue((Object)host.substring(0, indx));
        }
        return HttpUtils.getAccessInfo((URI)baseURI, (String)((String)this.getUser().getValue()));
    }

    @Override
    public String getAdvancedAccessInfo() {
        return (this.getAuthMethodInfo() + " " + this.getSsl().getTrustedSslInfo()).trim();
    }

    public SslArguments getSsl() {
        if (this.ssl == null) {
            this.ssl = new SslArguments();
            this.ssl.applyDefaultIfNullQuietly();
        }
        return this.ssl;
    }

    public void setSsl(SslArguments val) {
        this.ssl = val;
    }

    public int getConnectTimeoutAsSeconds() {
        return (int)SOSArgumentHelper.asSeconds(this.getConnectTimeout(), (long)30L);
    }

    public SOSArgument<List<String>> getHttpHeaders() {
        return this.httpHeaders;
    }

    public SOSArgument<String> getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public SOSArgument<String> getContainerName() {
        return this.containerName;
    }

    public SOSArgument<String> getApiVersion() {
        return this.apiVersion;
    }

    public SOSArgument<AzureBlobStorageClientAuthMethod> getAuthMethod() {
        return this.authMethod;
    }

    public SOSArgument<String> getAccountKey() {
        return this.accountKey;
    }

    public SOSArgument<String> getSASToken() {
        return this.sasToken;
    }

    private String getAuthMethodInfo() {
        ArrayList<Object> l = new ArrayList<Object>();
        if (!this.authMethod.isEmpty()) {
            switch ((AzureBlobStorageClientAuthMethod)this.authMethod.getValue()) {
                case SAS_TOKEN: {
                    l.add("SAS Token");
                    break;
                }
                case SHARED_KEY: {
                    l.add("Shared Key");
                    break;
                }
                default: {
                    l.add("Public");
                }
            }
        }
        if (!this.containerName.isEmpty()) {
            l.add("ContainerName=" + (String)this.containerName.getValue());
        }
        if (!this.apiVersion.isEmpty()) {
            l.add("ApiVersion=" + (String)this.apiVersion.getValue());
        }
        return String.join((CharSequence)", ", l);
    }
}

