/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.commons;

import com.sos.commons.credentialstore.CredentialStoreArguments;
import com.sos.commons.util.arguments.base.ASOSArguments;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.util.arguments.base.SOSArgumentHelper;
import com.sos.commons.util.proxy.ProxyConfigArguments;
import com.sos.commons.vfs.exceptions.ProviderInitializationException;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.List;

public abstract class AProviderArguments
extends ASOSArguments {
    private CredentialStoreArguments credentialStore;
    private ProxyConfigArguments proxy;
    private SOSArgument<Protocol> protocol = new SOSArgument("protocol", true);
    private SOSArgument<String> host = new SOSArgument("host", false);
    private SOSArgument<Integer> port = new SOSArgument("port", false);
    private SOSArgument<String> user = new SOSArgument("user", false);
    private SOSArgument<String> password = new SOSArgument("password", false, SOSArgument.DisplayMode.MASKED);
    private SOSArgument<String> connectTimeout = new SOSArgument("connect_timeout", false, (Object)"0");
    private SOSArgument<List<Path>> configurationFiles = new SOSArgument("configuration_files", false);
    private SOSArgument<EnumSet<FileType>> validFileTypes = new SOSArgument("valid_file_types", false, EnumSet.of(FileType.REGULAR, FileType.SYMLINK));

    public abstract String getAccessInfo() throws ProviderInitializationException;

    public abstract String getAdvancedAccessInfo();

    public void setCredentialStore(CredentialStoreArguments val) {
        this.credentialStore = val;
    }

    public CredentialStoreArguments getCredentialStore() {
        return this.credentialStore;
    }

    public ProxyConfigArguments getProxy() {
        return this.proxy;
    }

    public void setProxy(ProxyConfigArguments val) {
        this.proxy = val;
    }

    public SOSArgument<Protocol> getProtocol() {
        return this.protocol;
    }

    public SOSArgument<String> getHost() {
        return this.host;
    }

    public SOSArgument<Integer> getPort() {
        return this.port;
    }

    public SOSArgument<String> getUser() {
        return this.user;
    }

    public SOSArgument<String> getPassword() {
        return this.password;
    }

    public SOSArgument<String> getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getConnectTimeoutAsMillis() {
        return (int)SOSArgumentHelper.asMillis(this.connectTimeout);
    }

    public SOSArgument<List<Path>> getConfigurationFiles() {
        return this.configurationFiles;
    }

    public SOSArgument<EnumSet<FileType>> getValidFileTypes() {
        return this.validFileTypes;
    }

    public void tryRedefineHostPort() {
        if (!this.host.isEmpty() && ((String)this.host.getValue()).contains(":")) {
            String[] arr = ((String)this.host.getValue()).split(":");
            this.host.setValue((Object)arr[0]);
            if (!this.port.isDirty()) {
                this.port.setValue((Object)Integer.parseInt(arr[1]));
            }
        }
    }

    public static enum FileType {
        REGULAR,
        SYMLINK;

    }

    public static enum Protocol {
        UNKNOWN(0),
        LOCAL(10),
        FTP(20),
        FTPS(21),
        SFTP(30),
        SSH(31),
        HTTP(40),
        HTTPS(41),
        WEBDAV(50),
        WEBDAVS(51),
        SMB(60),
        AZURE_BLOB_STORAGE(70);

        private final Integer value;

        private Protocol(Integer val) {
            this.value = val;
        }

        public Integer getValue() {
            return this.value;
        }
    }
}

