/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.commons;

import com.sos.commons.credentialstore.keepass.SOSKeePassDatabase;
import com.sos.commons.credentialstore.keepass.SOSKeePassPath;
import com.sos.commons.util.SOSPath;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.util.proxy.ProxyConfig;
import com.sos.commons.util.proxy.ProxyConfigArguments;
import com.sos.commons.vfs.commons.AProviderArguments;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.linguafranca.pwdb.Entry;

public class ProviderCredentialStoreResolver {
    public static boolean resolve(AProviderArguments args, ProxyConfigArguments proxyArgs, SOSArgument<?> ... additional2resolve) throws Exception {
        if (args == null || args.getCredentialStore() == null) {
            return false;
        }
        if (args.getCredentialStore().getFile().getValue() != null && args.getCredentialStore().getKeepassDatabase() == null) {
            ProviderCredentialStoreResolver.setDatabase(args);
            ProviderCredentialStoreResolver.keepass2Arguments(args, proxyArgs, additional2resolve);
            return true;
        }
        return false;
    }

    public static boolean resolveAttachment(AProviderArguments args, SOSArgument<?> arg) throws Exception {
        Entry<?, ?, ?, ?> entry;
        SOSKeePassPath keePassPath;
        if (arg.isEmpty()) {
            return false;
        }
        if (args.getCredentialStore() == null) {
            return false;
        }
        if (args.getCredentialStore().getKeepassDatabase() == null) {
            if (args.getCredentialStore().getFile().getValue() == null) {
                return false;
            }
            ProviderCredentialStoreResolver.setDatabase(args);
        }
        if ((keePassPath = new SOSKeePassPath(args.getCredentialStore().getKeepassDatabase().getHandler().isKdbx(), arg.getValue().toString(), (String)args.getCredentialStore().getEntryPath().getValue())).isValid() && (entry = ProviderCredentialStoreResolver.getEntry(args, keePassPath.getEntryPath())) != null) {
            args.getCredentialStore().setKeepassDatabaseEntry(entry);
            args.getCredentialStore().setKeepassAttachmentPropertyName(keePassPath.getPropertyName());
            return true;
        }
        return false;
    }

    private static void setDatabase(AProviderArguments args) throws Exception {
        SOSKeePassDatabase kpd = new SOSKeePassDatabase(SOSPath.toAbsolutePath((String)((String)args.getCredentialStore().getFile().getValue())), SOSKeePassDatabase.getModule((String)((String)args.getCredentialStore().getKeePassModule().getValue())));
        Path keyFile = null;
        if (args.getCredentialStore().getKeyFile().getValue() != null) {
            Path cskf = SOSPath.toAbsolutePath((String)((String)args.getCredentialStore().getKeyFile().getValue()));
            if (Files.notExists(cskf, new LinkOption[0])) {
                throw new Exception(String.format("[%s]key file not found", SOSKeePassDatabase.getFilePath((Path)cskf)));
            }
            keyFile = cskf;
        } else {
            keyFile = SOSKeePassDatabase.getDefaultKeyFile((Path)SOSPath.toAbsolutePath((String)((String)args.getCredentialStore().getFile().getValue())));
            if (keyFile == null && SOSString.isEmpty((String)((String)args.getCredentialStore().getPassword().getValue()))) {
                throw new Exception(String.format("default key file not found. password is empty", new Object[0]));
            }
        }
        if (keyFile == null) {
            kpd.load((String)args.getCredentialStore().getPassword().getValue());
        } else {
            kpd.load((String)args.getCredentialStore().getPassword().getValue(), keyFile);
        }
        args.getCredentialStore().setKeepassDatabase(kpd);
    }

    private static Entry<?, ?, ?, ?> keepass2Arguments(AProviderArguments args, ProxyConfigArguments proxyArgs, SOSArgument<?> ... additional2resolve) throws Exception {
        Entry<?, ?, ?, ?> entry = ProviderCredentialStoreResolver.keepass2Argument(null, args, args.getHost(), args.getPort(), ":");
        entry = ProviderCredentialStoreResolver.keepass2Argument(entry, args, args.getUser());
        entry = ProviderCredentialStoreResolver.keepass2Argument(entry, args, args.getPassword());
        ProxyConfig proxyConfig = ProxyConfig.createInstance((ProxyConfigArguments)proxyArgs);
        if (proxyConfig != null) {
            entry = ProviderCredentialStoreResolver.keepass2Argument(entry, args, proxyArgs.getHost(), proxyArgs.getPort(), ":");
            entry = ProviderCredentialStoreResolver.keepass2Argument(entry, args, proxyArgs.getUser());
            entry = ProviderCredentialStoreResolver.keepass2Argument(entry, args, proxyArgs.getPassword());
        }
        if (additional2resolve != null) {
            for (SOSArgument<?> arg : additional2resolve) {
                ProviderCredentialStoreResolver.keepass2Argument(entry, args, arg);
            }
        }
        return entry;
    }

    private static Entry<?, ?, ?, ?> keepass2Argument(Entry<?, ?, ?, ?> lastEntry, AProviderArguments args, SOSArgument<?> arg) throws Exception {
        return ProviderCredentialStoreResolver.keepass2Argument(lastEntry, args, arg, null, null);
    }

    private static Entry<?, ?, ?, ?> keepass2Argument(Entry<?, ?, ?, ?> lastEntry, AProviderArguments args, SOSArgument<?> mainArg, SOSArgument<?> secondArg, String mainSecondSplitter) throws Exception {
        if (mainArg.getName() == null || mainArg.isEmpty()) {
            return lastEntry;
        }
        SOSKeePassPath keePassPath = new SOSKeePassPath(args.getCredentialStore().getKeepassDatabase().getHandler().isKdbx(), mainArg.getValue().toString(), (String)args.getCredentialStore().getEntryPath().getValue());
        Entry<?, ?, ?, ?> entry = null;
        String fileName = ((String)args.getCredentialStore().getFile().getValue()).toString();
        String argName = mainArg.getName();
        if (keePassPath.isValid()) {
            entry = lastEntry == null || !keePassPath.getEntryPath().equals(lastEntry.getPath()) ? ProviderCredentialStoreResolver.getEntry(args, keePassPath.getEntry()) : lastEntry;
            String value = entry.getProperty(keePassPath.getPropertyName());
            if (value == null) {
                throw new Exception(String.format("[%s][%s][%s]value is null", fileName, argName, keePassPath.toString()));
            }
            if (secondArg == null) {
                mainArg.applyValue((Object)value);
            } else {
                String[] arr = value.split(mainSecondSplitter);
                switch (arr.length) {
                    case 1: {
                        mainArg.applyValue((Object)value);
                        break;
                    }
                    default: {
                        mainArg.applyValue((Object)arr[0]);
                        secondArg.applyValue((Object)arr[1]);
                    }
                }
            }
        }
        return entry == null ? lastEntry : entry;
    }

    private static Entry<?, ?, ?, ?> getEntry(AProviderArguments args, String entryPath) throws Exception {
        Entry entry = args.getCredentialStore().getKeepassDatabase().getEntryByPath(entryPath);
        if (entry == null) {
            throw new Exception(String.format("[%s][%s]entry not found", args.getCredentialStore().getFile().getValue(), entryPath));
        }
        if (entry.getExpires()) {
            throw new Exception(String.format("[%s][%s]entry is expired (%s)", args.getCredentialStore().getFile().getValue(), entryPath, entry.getExpiryTime()));
        }
        return entry;
    }
}

