/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.http.commons;

import com.sos.commons.util.SOSPathUtils;
import com.sos.commons.util.arguments.base.SOSArgument;
import java.net.URI;
import java.net.URL;

public class HTTPProviderUtils {
    public static URI getBaseURI(SOSArgument<String> hostArg, SOSArgument<Integer> portArg) throws Exception {
        String hostOrUrl = SOSPathUtils.toUnixStyle((String)((String)hostArg.getValue()));
        if (SOSPathUtils.isAbsoluteURIPath((String)hostOrUrl)) {
            return HTTPProviderUtils.toBaseURI(hostOrUrl);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("http://").append(hostOrUrl);
        if (portArg.isDirty()) {
            sb.append(":").append(portArg.getValue());
        }
        sb.append("/");
        return HTTPProviderUtils.toBaseURI(sb.toString());
    }

    private static URI toBaseURI(String spec) throws Exception {
        Object baseURI = spec;
        if (!((String)baseURI).endsWith("/")) {
            if (((String)baseURI).contains("?")) {
                baseURI = SOSPathUtils.getParentPath((String)baseURI);
            }
            baseURI = (String)baseURI + "/";
        }
        return new URL((String)baseURI).toURI();
    }
}

