/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.smb;

import com.sos.commons.util.SOSPathUtils;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.vfs.commons.AProvider;
import com.sos.commons.vfs.exceptions.ProviderInitializationException;
import com.sos.commons.vfs.smb.commons.SMBProviderArguments;
import com.sos.commons.vfs.smb.smbj.SMBJProvider;
import java.nio.file.Path;

public abstract class SMBProvider
extends AProvider<SMBProviderArguments> {
    private String shareName;

    public static SMBProvider createInstance(ISOSLogger logger, SMBProviderArguments args) throws ProviderInitializationException {
        return new SMBJProvider(logger, args);
    }

    protected SMBProvider(ISOSLogger logger, SMBProviderArguments args) throws ProviderInitializationException {
        super(logger, args, new SOSArgument[0]);
        this.setAccessInfo(((SMBProviderArguments)((Object)this.getArguments())).getAccessInfo());
    }

    @Override
    public String getPathSeparator() {
        return "\\";
    }

    @Override
    public boolean isAbsolutePath(String path) {
        if (SOSString.isEmpty((String)this.getShareName(path))) {
            return true;
        }
        if (SOSPathUtils.isAbsoluteWindowsUNCPath((String)path)) {
            return true;
        }
        String p = SOSString.trimStart((String)this.toPathStyle(path), (String[])new String[]{this.getPathSeparator()});
        return p.startsWith(this.getShareName(path));
    }

    @Override
    public String normalizePath(String path) {
        if (SOSString.isEmpty((String)path)) {
            return this.getPathSeparator();
        }
        String p = this.toPathStyle(Path.of(path, new String[0]).normalize().toString());
        if (p == null) {
            return this.getPathSeparator();
        }
        return p.startsWith(this.getPathSeparator()) ? p : this.getPathSeparator() + p;
    }

    public String getShareName(String path) {
        if (this.shareName == null) {
            if (!((SMBProviderArguments)((Object)this.getArguments())).getShareName().isEmpty()) {
                this.shareName = (String)((SMBProviderArguments)((Object)this.getArguments())).getShareName().getValue();
            } else if (SOSString.isEmpty((String)path)) {
                this.shareName = "";
            } else {
                String[] pathParts = path.replaceAll("^[/\\\\]+", "").split("[/\\\\]", 2);
                this.shareName = pathParts[0];
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("%s[shareName]%s", new Object[]{this.getLogPrefix(), this.shareName});
            }
        }
        return this.shareName;
    }
}

