/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.smb.commons;

import com.sos.commons.util.SOSString;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.vfs.commons.AProviderArguments;
import com.sos.commons.vfs.exceptions.ProviderInitializationException;
import com.sos.commons.vfs.smb.commons.SMBAuthMethod;

public class SMBProviderArguments
extends AProviderArguments {
    private static final int DEFAULT_PORT = 445;
    private SOSArgument<SMBAuthMethod> authMethod = new SOSArgument("auth_method", false, (Object)SMBAuthMethod.NTLM);
    private SOSArgument<String> domain = new SOSArgument("domain", false);
    private SOSArgument<String> shareName = new SOSArgument("share_name", false);
    private SOSArgument<String> loginContextName = new SOSArgument("login_context_name", false);

    public SMBProviderArguments() {
        this.getProtocol().setDefaultValue((Object)AProviderArguments.Protocol.SMB);
        this.getPort().setDefaultValue((Object)445);
    }

    @Override
    public String getAccessInfo() throws ProviderInitializationException {
        String user = (String)this.getUser().getValue();
        switch ((SMBAuthMethod)((Object)this.getAuthMethod().getValue())) {
            default: 
        }
        if (SOSString.isEmpty((String)user)) {
            user = "[SSO]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(((SMBAuthMethod)((Object)this.getAuthMethod().getValue())).name());
        if (!this.getLoginContextName().isEmpty()) {
            sb.append("(").append((String)this.getLoginContextName().getValue()).append(")");
        }
        sb.append("]");
        sb.append(user).append("@").append((String)this.getHost().getValue()).append(":").append(this.getPort().getValue());
        if (!this.domain.isEmpty()) {
            sb.append("(").append((String)this.domain.getValue()).append(")");
        }
        if (!this.shareName.isEmpty()) {
            sb.append("\\").append((String)this.shareName.getValue());
        }
        return sb.toString();
    }

    @Override
    public String getAdvancedAccessInfo() {
        return null;
    }

    public SOSArgument<SMBAuthMethod> getAuthMethod() {
        return this.authMethod;
    }

    public SOSArgument<String> getDomain() {
        return this.domain;
    }

    public SOSArgument<String> getShareName() {
        return this.shareName;
    }

    public SOSArgument<String> getLoginContextName() {
        return this.loginContextName;
    }
}

