/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.smb.smbj;

import com.hierynomus.smbj.auth.AuthenticationContext;
import com.hierynomus.smbj.auth.GSSAuthenticationContext;
import com.sos.commons.util.SOSString;
import com.sos.commons.vfs.smb.commons.SMBAuthMethod;
import com.sos.commons.vfs.smb.commons.SMBProviderArguments;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class SMBAuthenticationContextFactory {
    public static AuthenticationContext create(SMBProviderArguments args) throws Exception {
        switch ((SMBAuthMethod)((Object)args.getAuthMethod().getValue())) {
            case ANONYMOUS: {
                return AuthenticationContext.anonymous();
            }
            case GUEST: {
                return AuthenticationContext.guest();
            }
            case NTLM: {
                char[] pass = args.getPassword().getValue() == null ? new char[]{} : ((String)args.getPassword().getValue()).toCharArray();
                return new AuthenticationContext((String)args.getUser().getValue(), pass, (String)args.getDomain().getValue());
            }
        }
        return SMBAuthenticationContextFactory.createGSSAPIContext(args);
    }

    private static GSSAuthenticationContext createGSSAPIContext(SMBProviderArguments args) throws Exception {
        SMBAuthMethod authMethod = (SMBAuthMethod)((Object)args.getAuthMethod().getValue());
        final String username = (String)args.getUser().getValue();
        final String password = (String)args.getPassword().getValue();
        String loginContextName = args.getLoginContextName().isEmpty() ? authMethod.getLoginContextName() : (String)args.getLoginContextName().getValue();
        LoginContext loginContext = password == null ? new LoginContext(loginContextName) : new LoginContext(loginContextName, new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) {
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        ((NameCallback)callback).setName(username);
                        continue;
                    }
                    if (!(callback instanceof PasswordCallback)) continue;
                    ((PasswordCallback)callback).setPassword(password.toCharArray());
                }
            }
        });
        loginContext.login();
        String domain = args.getDomain().getValue() == null ? "" : (String)args.getDomain().getValue();
        GSSCredential credentials = SMBAuthenticationContextFactory.getGSSCredential(username, domain, new Oid(authMethod.getOid()));
        return new GSSAuthenticationContext(username, domain, loginContext.getSubject(), credentials);
    }

    private static GSSCredential getGSSCredential(String username, String domain, Oid oid) throws GSSException {
        GSSManager manager = GSSManager.getInstance();
        GSSName gssName = null;
        if (!SOSString.isEmpty((String)username)) {
            gssName = manager.createName((String)(SOSString.isEmpty((String)domain) ? username : username + "@" + domain), GSSName.NT_USER_NAME);
        }
        return manager.createCredential(gssName, Integer.MAX_VALUE, oid, 1);
    }
}

