/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.smb.smbj;

import com.hierynomus.msfscc.fileinformation.FileAllInformation;
import com.hierynomus.msfscc.fileinformation.FileIdBothDirectoryInformation;
import com.hierynomus.mssmb2.SMB2Dialect;
import com.hierynomus.mssmb2.SMBApiException;
import com.hierynomus.smbj.SMBClient;
import com.hierynomus.smbj.SmbConfig;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.DiskShare;
import com.hierynomus.smbj.utils.SmbFiles;
import com.sos.commons.exception.SOSRequiredArgumentMissingException;
import com.sos.commons.util.SOSClassUtil;
import com.sos.commons.util.SOSDate;
import com.sos.commons.util.SOSPathUtils;
import com.sos.commons.util.SOSShell;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.beans.SOSCommandResult;
import com.sos.commons.util.beans.SOSEnv;
import com.sos.commons.util.beans.SOSTimeout;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.vfs.commons.AProviderArguments;
import com.sos.commons.vfs.commons.file.ProviderFile;
import com.sos.commons.vfs.commons.file.selection.ProviderFileSelection;
import com.sos.commons.vfs.exceptions.ProviderAuthenticationException;
import com.sos.commons.vfs.exceptions.ProviderClientNotInitializedException;
import com.sos.commons.vfs.exceptions.ProviderConnectException;
import com.sos.commons.vfs.exceptions.ProviderException;
import com.sos.commons.vfs.exceptions.ProviderInitializationException;
import com.sos.commons.vfs.smb.SMBProvider;
import com.sos.commons.vfs.smb.commons.SMBProviderArguments;
import com.sos.commons.vfs.smb.smbj.SMBAuthenticationContextFactory;
import com.sos.commons.vfs.smb.smbj.SMBJInputStream;
import com.sos.commons.vfs.smb.smbj.SMBJOutputStream;
import com.sos.commons.vfs.smb.smbj.SMBJProviderReusableResource;
import com.sos.commons.vfs.smb.smbj.SMBJProviderUtils;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class SMBJProvider
extends SMBProvider {
    private SMBClient client = null;
    private Session session = null;
    private boolean accessMaskMaximumAllowed = false;
    private boolean reusableResourceEnabled;

    public SMBJProvider(ISOSLogger logger, SMBProviderArguments args) throws ProviderInitializationException {
        super(logger, args);
        ((SMBProviderArguments)((Object)this.getArguments())).tryRedefineHostPort();
    }

    @Override
    public void connect() throws ProviderConnectException {
        if (SOSString.isEmpty((String)((String)((SMBProviderArguments)((Object)this.getArguments())).getHost().getValue()))) {
            throw new ProviderConnectException((Throwable)new SOSRequiredArgumentMissingException("host"));
        }
        boolean connected = false;
        try {
            this.client = this.createClient();
            this.getLogger().info((Object)this.getConnectMsg());
            Connection connection = this.client.connect((String)((SMBProviderArguments)((Object)this.getArguments())).getHost().getValue(), ((Integer)((SMBProviderArguments)((Object)this.getArguments())).getPort().getValue()).intValue());
            connected = true;
            try {
                this.session = connection.authenticate(SMBAuthenticationContextFactory.create((SMBProviderArguments)((Object)this.getArguments())));
            }
            catch (Exception e) {
                throw new ProviderAuthenticationException(e);
            }
            this.enableReusableResource();
            this.getLogger().info((Object)this.getConnectedMsg());
        }
        catch (Throwable e) {
            if (connected) {
                this.disconnect();
            }
            throw new ProviderConnectException(String.format("[%s]", this.getAccessInfo()), e);
        }
    }

    @Override
    public boolean isConnected() {
        return this.session != null;
    }

    @Override
    public void disconnect() {
        if (this.session == null && this.client == null) {
            return;
        }
        this.disableReusableResource();
        if (this.session != null) {
            SOSClassUtil.closeQuietly((AutoCloseable)this.session);
            SOSClassUtil.closeQuietly((Closeable)this.session.getConnection());
        }
        SOSClassUtil.closeQuietly((Closeable)this.client);
        this.session = null;
        this.client = null;
        this.getLogger().info((Object)this.getDisconnectedMsg());
    }

    @Override
    public List<ProviderFile> selectFiles(ProviderFileSelection selection) throws ProviderException {
        ArrayList<ProviderFile> arrayList;
        block8: {
            this.validatePrerequisites("selectFiles");
            selection = ProviderFileSelection.createIfNull(selection);
            selection.setFileTypeChecker(fileRepresentator -> {
                if (fileRepresentator == null) {
                    return false;
                }
                FileIdBothDirectoryInformation r = (FileIdBothDirectoryInformation)fileRepresentator;
                return !SMBJProviderUtils.isDirectory(r) && ((EnumSet)((SMBProviderArguments)((Object)((Object)this.getArguments()))).getValidFileTypes().getValue()).contains((Object)AProviderArguments.FileType.REGULAR);
            });
            String directory = selection.getConfig().getDirectory() == null ? "" : selection.getConfig().getDirectory();
            DiskShare share = this.connectShare(directory);
            try {
                ArrayList<ProviderFile> result = new ArrayList<ProviderFile>();
                SMBJProviderUtils.selectFiles(this, selection, this.getSMBPath(directory), result, share, 0);
                arrayList = result;
                if (share == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (share != null) {
                        try {
                            share.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ProviderException(this.getPathOperationPrefix(directory), e);
                }
            }
            share.close();
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean exists(String path) throws ProviderException {
        this.validatePrerequisites("exists", path, "path");
        try {
            SMBJProviderReusableResource reusable = this.getReusableResource();
            if (reusable == null) {
                try (DiskShare share = this.connectShare(path);){
                    boolean bl = share.fileExists(this.getSMBPath(path)) || share.folderExists(this.getSMBPath(path));
                    return bl;
                }
            }
            DiskShare share = reusable.getDiskShare(path);
            if (share.fileExists(this.getSMBPath(path))) return true;
            if (share.folderExists(this.getSMBPath(path))) return true;
            return false;
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean createDirectoriesIfNotExists(String path) throws ProviderException {
        this.validatePrerequisites("createDirectoriesIfNotExists", path, "path");
        try {
            SMBJProviderReusableResource reusable = this.getReusableResource();
            String smbPath = this.getSMBPath(path);
            if (reusable != null) {
                new SmbFiles().mkdirs(reusable.getDiskShare(path), smbPath);
                if (!this.getLogger().isDebugEnabled()) return true;
                this.getLogger().debug("%s[createDirectoriesIfNotExists][%s]created", new Object[]{this.getLogPrefix(), path});
                return true;
            }
            try (DiskShare share = this.connectShare(path);){
                new SmbFiles().mkdirs(share, smbPath);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("%s[createDirectoriesIfNotExists][%s]created", new Object[]{this.getLogPrefix(), path});
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean deleteIfExists(String path) throws ProviderException {
        boolean bl;
        this.validatePrerequisites("deleteIfExists", path, "path");
        SMBJProviderReusableResource reusable = this.getReusableResource();
        String smbPath = this.getSMBPath(path);
        if (reusable != null) return SMBJProviderUtils.deleteIfExists(reusable.getDiskShare(path), smbPath);
        DiskShare share = this.connectShare(path);
        try {
            bl = SMBJProviderUtils.deleteIfExists(share, smbPath);
            if (share == null) return bl;
        }
        catch (Throwable throwable) {
            try {
                if (share == null) throw throwable;
                try {
                    share.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new ProviderException(this.getPathOperationPrefix(path), e.getCause() == null ? e : e.getCause());
            }
        }
        share.close();
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean deleteFileIfExists(String path) throws ProviderException {
        boolean bl;
        this.validatePrerequisites("deleteFileIfExists", path, "path");
        SMBJProviderReusableResource reusable = this.getReusableResource();
        String smbPath = this.getSMBPath(path);
        if (reusable != null) return SMBJProviderUtils.deleteFileIfExists(reusable.getDiskShare(path), smbPath);
        DiskShare share = this.connectShare(path);
        try {
            bl = SMBJProviderUtils.deleteFileIfExists(share, smbPath);
            if (share == null) return bl;
        }
        catch (Throwable throwable) {
            try {
                if (share == null) throw throwable;
                try {
                    share.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new ProviderException(this.getPathOperationPrefix(path), e.getCause() == null ? e : e.getCause());
            }
        }
        share.close();
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean renameFileIfSourceExists(String source, String target) throws ProviderException {
        boolean bl;
        this.validatePrerequisites("renameFileIfSourceExists", source, "source");
        this.validateArgument("renameFileIfSourceExists", target, "target");
        SMBJProviderReusableResource reusable = this.getReusableResource();
        String smbSourcePath = this.getSMBPath(source);
        String smbTargetPath = this.getSMBPath(target);
        if (reusable != null) return SMBJProviderUtils.renameFileIfSourceExists(reusable.getDiskShare(source), smbSourcePath, smbTargetPath, this.accessMaskMaximumAllowed);
        DiskShare share = this.connectShare(source);
        try {
            bl = SMBJProviderUtils.renameFileIfSourceExists(share, smbSourcePath, smbTargetPath, this.accessMaskMaximumAllowed);
            if (share == null) return bl;
        }
        catch (Throwable throwable) {
            try {
                if (share == null) throw throwable;
                try {
                    share.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new ProviderException(this.getPathOperationPrefix(source + "->" + target), e);
            }
        }
        share.close();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ProviderFile getFileIfExists(String path) throws ProviderException {
        this.validatePrerequisites("getFileIfExists", path, "path");
        try {
            SMBJProviderReusableResource reusable = this.getReusableResource();
            String smbPath = this.getSMBPath(path);
            if (reusable == null) {
                try (DiskShare share = this.connectShare(path);){
                    ProviderFile providerFile = this.createProviderFile(smbPath, share.getFileInformation(smbPath));
                    return providerFile;
                }
            }
            try {
                return this.createProviderFile(smbPath, reusable.getDiskShare(path).getFileInformation(smbPath));
            }
            catch (SMBApiException e) {
                return null;
            }
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getFileContentIfExists(String path) throws ProviderException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void writeFile(String path, String content) throws ProviderException {
        this.validatePrerequisites("writeFile", path, "path");
        SMBJProviderReusableResource reusable = this.getReusableResource();
        DiskShare share = reusable == null ? this.connectShare(path) : reusable.getDiskShare(path);
        try (SMBJOutputStream os = new SMBJOutputStream(this.accessMaskMaximumAllowed, share, reusable == null, this.getSMBPath(path), false);){
            os.write(content.getBytes(StandardCharsets.UTF_8));
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public void setFileLastModifiedFromMillis(String path, long milliseconds) throws ProviderException {
        block9: {
            this.validatePrerequisites("setFileLastModifiedFromMillis", path, path);
            this.validateModificationTime(path, milliseconds);
            try {
                SMBJProviderReusableResource reusable = this.getReusableResource();
                String smbPath = this.getSMBPath(path);
                if (reusable == null) {
                    try (DiskShare share = this.connectShare(path);){
                        SMBJProviderUtils.setFileLastModifiedFromMillis(share, smbPath, milliseconds, this.accessMaskMaximumAllowed);
                        break block9;
                    }
                }
                SMBJProviderUtils.setFileLastModifiedFromMillis(reusable.getDiskShare(path), smbPath, milliseconds, this.accessMaskMaximumAllowed);
            }
            catch (Throwable e) {
                throw new ProviderException(this.getPathOperationPrefix(path), e);
            }
        }
    }

    @Override
    public InputStream getInputStream(String path) throws ProviderException {
        this.validatePrerequisites("getInputStream", path, "path");
        try {
            SMBJProviderReusableResource reusable = this.getReusableResource();
            DiskShare share = reusable == null ? this.connectShare(path) : reusable.getDiskShare(path);
            return new SMBJInputStream(this.accessMaskMaximumAllowed, share, reusable == null, this.getSMBPath(path));
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public OutputStream getOutputStream(String path, boolean append) throws ProviderException {
        this.validatePrerequisites("getOutputStream", path, "path");
        try {
            SMBJProviderReusableResource reusable = this.getReusableResource();
            DiskShare share = reusable == null ? this.connectShare(path) : reusable.getDiskShare(path);
            return new SMBJOutputStream(this.accessMaskMaximumAllowed, share, reusable == null, this.getSMBPath(path), append);
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public void validatePrerequisites(String method) throws ProviderException {
        if (this.client == null || this.session == null) {
            throw new ProviderClientNotInitializedException(this.getLogPrefix() + method + "SMBClient/SMBSession");
        }
    }

    @Override
    public void enableReusableResource() {
        if (this.reusableResourceEnabled) {
            return;
        }
        try {
            super.enableReusableResource(new SMBJProviderReusableResource(this));
            this.reusableResourceEnabled = true;
        }
        catch (Exception e) {
            this.getLogger().warn((Object)(this.getLogPrefix() + "[enableReusableResource]" + e));
        }
    }

    public SMBJProviderReusableResource getReusableResource() {
        if (!this.reusableResourceEnabled) {
            return null;
        }
        return (SMBJProviderReusableResource)super.getReusableResource();
    }

    @Override
    public void disableReusableResource() {
        super.disableReusableResource();
        this.reusableResourceEnabled = false;
    }

    @Override
    public SOSCommandResult executeCommand(String command, SOSTimeout timeout, SOSEnv env) {
        return SOSShell.executeCommand((String)command, (SOSTimeout)timeout, (SOSEnv)env);
    }

    protected ProviderFile createProviderFile(String fullPath, FileIdBothDirectoryInformation info) {
        if (!((String)fullPath).startsWith(this.getPathSeparator())) {
            fullPath = this.getPathSeparator() + (String)fullPath;
        }
        return this.createProviderFile((String)fullPath, info.getEndOfFile(), info.getLastWriteTime().toEpochMillis());
    }

    protected DiskShare connectShare(String path) {
        return (DiskShare)this.session.connectShare(this.getShareName(path));
    }

    private SMBClient createClient() {
        SmbConfig.Builder builder = SmbConfig.builder();
        this.applyConfiguratedProperties(this.getConfigurationPropertiesFromFiles(), builder);
        SmbConfig config = builder.build();
        if (this.getLogger().isDebugEnabled()) {
            List<String> excluded = Arrays.asList("authenticators;socketFactory;random;securityProvider;transportLayerFactory;clientGSSContextConfig;ntlmConfig".split(";"));
            this.getLogger().debug((Object)String.format("%s[createClient][config]%s", this.getLogPrefix(), SOSString.toString((Object)config, excluded)));
        }
        return new SMBClient(config);
    }

    private void applyConfiguratedProperties(Properties configuration, SmbConfig.Builder builder) {
        if (configuration == null) {
            return;
        }
        configuration.entrySet().forEach(e -> {
            String key = e.getKey().toString().trim();
            String val = e.getValue().toString().trim();
            try {
                switch (key) {
                    case "workStationName": {
                        builder.withNtlmConfig().withWorkstationName(val);
                        break;
                    }
                    case "soTimeout": {
                        long t = SOSDate.resolveAge((String)"ms", (String)val);
                        builder.withSoTimeout(t, TimeUnit.MILLISECONDS);
                        break;
                    }
                    case "timeout": {
                        long t = SOSDate.resolveAge((String)"ms", (String)val);
                        builder.withTimeout(t, TimeUnit.MILLISECONDS);
                        break;
                    }
                    case "readTimeout": {
                        long t = SOSDate.resolveAge((String)"ms", (String)val);
                        builder.withReadTimeout(t, TimeUnit.MILLISECONDS);
                        break;
                    }
                    case "transactTimeout": {
                        long t = SOSDate.resolveAge((String)"ms", (String)val);
                        builder.withTransactTimeout(t, TimeUnit.MILLISECONDS);
                        break;
                    }
                    case "writeTimeout": {
                        long t = SOSDate.resolveAge((String)"ms", (String)val);
                        builder.withWriteTimeout(t, TimeUnit.MILLISECONDS);
                        break;
                    }
                    case "bufferSize": {
                        builder.withBufferSize(Integer.parseInt(val));
                        break;
                    }
                    case "readBufferSize": {
                        builder.withReadBufferSize(Integer.parseInt(val));
                        break;
                    }
                    case "transactBufferSize": {
                        builder.withTransactBufferSize(Integer.parseInt(val));
                        break;
                    }
                    case "writeBufferSize": {
                        builder.withWriteBufferSize(Integer.parseInt(val));
                        break;
                    }
                    case "dialects": {
                        List l = Arrays.stream(val.split(";")).map(d -> SMB2Dialect.valueOf((String)d.trim())).collect(Collectors.toList());
                        builder.withDialects(l);
                        break;
                    }
                    case "signingRequired": {
                        builder.withSigningRequired(Boolean.parseBoolean(val));
                        break;
                    }
                    case "dfsEnabled": {
                        builder.withDfsEnabled(Boolean.parseBoolean(val));
                        break;
                    }
                    case "multiProtocolNegotiate": {
                        builder.withMultiProtocolNegotiate(Boolean.parseBoolean(val));
                        break;
                    }
                    case "encryptData": {
                        builder.withEncryptData(Boolean.parseBoolean(val));
                        break;
                    }
                    case "sossmbj.accessMaskMaximumAllowed": {
                        this.accessMaskMaximumAllowed = Boolean.parseBoolean(val);
                        break;
                    }
                    case "sossmbj.pathSeparator": {
                        this.getLogger().info((Object)String.format("%s[applyConfiguratedProperties][%s=%s]The setting is no longer supported. The path separator %s is used.", this.getLogPrefix(), key, val, this.getPathSeparator()));
                    }
                }
            }
            catch (Throwable te) {
                this.getLogger().warn(String.format("%s[applyConfiguratedProperties][%s=%s]%s", this.getLogPrefix(), key, val, te.toString()), te);
            }
        });
    }

    private String getSMBPath(String path) {
        String smbPath = this.normalizePath(path);
        if (SOSString.isEmpty((String)smbPath)) {
            return "";
        }
        String shareName = this.getShareName(path);
        smbPath = SOSString.trimStart((String)smbPath, (String[])new String[]{this.getPathSeparator()});
        if (!SOSString.isEmpty((String)shareName)) {
            if (shareName.equalsIgnoreCase(smbPath)) {
                return "";
            }
            int shareIndex = smbPath.indexOf(shareName + this.getPathSeparator());
            if (shareIndex != -1) {
                smbPath = smbPath.substring(shareIndex + shareName.length() + 1);
            }
        }
        return smbPath;
    }

    private ProviderFile createProviderFile(String fullPath, FileAllInformation info) {
        return this.createProviderFile(fullPath, info.getStandardInformation().getEndOfFile(), info.getBasicInformation().getLastWriteTime().toEpochMillis());
    }

    private void validatePrerequisites(String method, String paramValue, String msg) throws ProviderException {
        this.validatePrerequisites(method);
        this.validateArgument(method, paramValue, msg);
    }

    private static String sanitizeSMBPathFilename(String input) {
        String illegalChars;
        Path path = Paths.get(input, new String[0]);
        String fileName = path.getFileName().toString();
        if (!fileName.matches(".*" + (illegalChars = "[<>:\"/\\\\|?*\\p{Cntrl}]") + ".*")) {
            return input;
        }
        String sanitized = fileName.replaceAll(illegalChars, "_");
        sanitized = Normalizer.normalize(sanitized, Normalizer.Form.NFC);
        Path parent = path.getParent();
        String finalPath = parent != null ? parent.resolve(sanitized).toString() : sanitized;
        return SOSPathUtils.toWindowsStyle((String)finalPath);
    }
}

