/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.ssh;

import com.google.common.base.Joiner;
import com.sos.commons.util.SOSCollection;
import com.sos.commons.util.SOSPathUtils;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.vfs.commons.AProvider;
import com.sos.commons.vfs.commons.ProviderCredentialStoreResolver;
import com.sos.commons.vfs.exceptions.ProviderException;
import com.sos.commons.vfs.exceptions.ProviderInitializationException;
import com.sos.commons.vfs.ssh.commons.SSHProviderArguments;
import com.sos.commons.vfs.ssh.commons.SSHServerInfo;
import com.sos.commons.vfs.ssh.sshj.SSHJProvider;
import java.nio.file.Path;
import java.util.List;

public abstract class SSHProvider
extends AProvider<SSHProviderArguments> {
    private SSHServerInfo serverInfo;
    private String serverVersion;

    public static SSHProvider createInstance(ISOSLogger logger, SSHProviderArguments args) throws ProviderInitializationException {
        return new SSHJProvider(logger, args);
    }

    protected SSHProvider(ISOSLogger logger, SSHProviderArguments args) throws ProviderInitializationException {
        super(logger, args, args == null ? null : args.getPassphrase());
        this.setAccessInfo(this.getArguments() == null ? null : ((SSHProviderArguments)((Object)this.getArguments())).getAccessInfo());
    }

    public abstract void put(String var1, String var2, int var3) throws ProviderException;

    public abstract void put(String var1, String var2) throws ProviderException;

    public abstract void get(String var1, String var2) throws ProviderException;

    public abstract boolean deleteDirectory(String var1) throws ProviderException;

    public abstract boolean deleteWindowsDirectory(String var1) throws ProviderException;

    public abstract boolean deleteUnixDirectory(String var1) throws ProviderException;

    @Override
    public void onCredentialStoreResolved() throws Exception {
        ProviderCredentialStoreResolver.resolveAttachment(this.getArguments(), ((SSHProviderArguments)((Object)this.getArguments())).getAuthFile());
    }

    @Override
    public String getPathSeparator() {
        return "/";
    }

    @Override
    public boolean isAbsolutePath(String path) {
        return SOSPathUtils.isAbsoluteFileSystemPath((String)path);
    }

    @Override
    public String normalizePath(String path) {
        if (SOSPathUtils.isAbsoluteWindowsOpenSSHPath((String)path)) {
            String n = this.getPathSeparator() + Path.of(path.substring(1), new String[0]).normalize().toString();
            return this.toPathStyle(n);
        }
        return this.toPathStyle(Path.of(path, new String[0]).normalize().toString());
    }

    public SSHServerInfo getServerInfo() {
        if (this.serverInfo == null) {
            this.serverInfo = new SSHServerInfo(this, this.serverVersion);
        }
        return this.serverInfo;
    }

    public void setServerVersion(String val) {
        this.serverVersion = val;
    }

    public String getConnectedMsg(List<String> additionalInfos) {
        Object msg = "";
        if (SOSCollection.isEmpty(additionalInfos)) {
            if (this.serverInfo != null) {
                msg = (String)msg + this.serverInfo.toString();
            }
        } else {
            if (this.serverInfo != null) {
                msg = (String)msg + "[" + this.serverInfo.toString() + "]";
            }
            msg = (String)msg + Joiner.on((String)", ").join(additionalInfos);
        }
        return this.getConnectedMsg((String)msg);
    }
}

