/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.ssh.commons;

import com.sos.commons.util.SOSString;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SSHAuthMethod {
    PASSWORD,
    PUBLICKEY,
    KEYBOARD_INTERACTIVE;


    public static List<SSHAuthMethod> fromString(String methods) {
        if (SOSString.isEmpty((String)methods)) {
            return null;
        }
        return Stream.of(methods.split(",")).map(String::trim).map(String::toUpperCase).map(SSHAuthMethod::valueOf).collect(Collectors.toList());
    }

    public static String toString(List<SSHAuthMethod> methods) {
        if (methods == null) {
            return null;
        }
        return SOSString.join(methods, (String)",", n -> n.name().toLowerCase());
    }
}

