/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.ssh.commons;

import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.util.arguments.base.SOSArgumentHelper;
import com.sos.commons.vfs.commons.AProviderArguments;
import com.sos.commons.vfs.exceptions.ProviderInitializationException;
import com.sos.commons.vfs.ssh.commons.SSHAuthMethod;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;

public class SSHProviderArguments
extends AProviderArguments {
    public static final String CLASS_KEY = "SSH_PROVIDER";
    private static final int DEFAULT_PORT = 22;
    private static String ARG_NAME_PREFERRED_AUTHENTICATIONS_DISPLAY_NAME = "PreferredAuthentications";
    private static String ARG_NAME_REQUIRED_AUTHENTICATIONS_DISPLAY_NAME = "RequiredAuthentications";
    private static String ARG_NAME_AUTH_METHOD_PASSWORD_DISPLAY_NAME = "AuthenticationMethodPassword";
    private static String ARG_NAME_AUTH_METHOD_PUBLICKEY_DISPLAY_NAME = "AuthenticationMethodPublickey";
    private static String ARG_NAME_AUTH_METHOD_KEYBOARD_INTERACTIVE_DISPLAY_NAME = "AuthenticationMethodKeyboardInteractive";
    private SOSArgument<String> passphrase = new SOSArgument("passphrase", false, SOSArgument.DisplayMode.MASKED);
    private SOSArgument<String> authFile = new SOSArgument("auth_file", false);
    private SOSArgument<SSHAuthMethod> authMethod = new SOSArgument("auth_method", false);
    private SOSArgument<List<SSHAuthMethod>> preferredAuthentications = new SOSArgument("preferred_authentications", false);
    private SOSArgument<List<SSHAuthMethod>> requiredAuthentications = new SOSArgument("required_authentications", false);
    private SOSArgument<String> socketTimeout = new SOSArgument("socket_timeout", false, (Object)"0");
    private SOSArgument<String> serverAliveInterval = new SOSArgument("server_alive_interval", false);
    private SOSArgument<Integer> serverAliveCountMax = new SOSArgument("server_alive_count_max", false);
    private SOSArgument<Boolean> strictHostkeyChecking = new SOSArgument("strict_hostkey_checking", false, (Object)false);
    private SOSArgument<Path> hostkeyLocation = new SOSArgument("hostkey_location", false);
    private SOSArgument<Boolean> useZlibCompression = new SOSArgument("use_zlib_compression", false, (Object)false);
    private SOSArgument<Boolean> simulateShell = new SOSArgument("simulate_shell", false, (Object)false);
    private SOSArgument<Charset> remoteCharset = new SOSArgument("remote_charset", false, (Object)Charset.forName("UTF-8"));
    private SOSArgument<SSHProviderType> sshProviderType = new SOSArgument("ssh_provider", false, (Object)SSHProviderType.SSHJ);

    public SSHProviderArguments() {
        this.getProtocol().setDefaultValue((Object)AProviderArguments.Protocol.SFTP);
        this.getPort().setDefaultValue((Object)22);
        this.getUser().setRequired(true);
    }

    @Override
    public String getAccessInfo() throws ProviderInitializationException {
        return String.format("%s@%s:%s", this.getUser().getDisplayValue(), this.getHost().getDisplayValue(), this.getPort().getDisplayValue());
    }

    @Override
    public String getAdvancedAccessInfo() {
        if (!this.getRequiredAuthentications().isEmpty()) {
            return ARG_NAME_REQUIRED_AUTHENTICATIONS_DISPLAY_NAME + "=" + this.getRequiredAuthenticationsAsString();
        }
        if (!this.getPreferredAuthentications().isEmpty()) {
            return ARG_NAME_PREFERRED_AUTHENTICATIONS_DISPLAY_NAME + "=" + this.getPreferredAuthenticationsAsString();
        }
        if (!this.getAuthMethod().isEmpty()) {
            switch ((SSHAuthMethod)((Object)this.getAuthMethod().getValue())) {
                case PASSWORD: {
                    return ARG_NAME_AUTH_METHOD_PASSWORD_DISPLAY_NAME;
                }
                case PUBLICKEY: {
                    return ARG_NAME_AUTH_METHOD_PUBLICKEY_DISPLAY_NAME;
                }
                case KEYBOARD_INTERACTIVE: {
                    return ARG_NAME_AUTH_METHOD_KEYBOARD_INTERACTIVE_DISPLAY_NAME;
                }
            }
        }
        return null;
    }

    public SOSArgument<SSHAuthMethod> getAuthMethod() {
        return this.authMethod;
    }

    public SOSArgument<String> getPassphrase() {
        return this.passphrase;
    }

    public SOSArgument<String> getAuthFile() {
        return this.authFile;
    }

    public SOSArgument<List<SSHAuthMethod>> getPreferredAuthentications() {
        return this.preferredAuthentications;
    }

    public String getPreferredAuthenticationsAsString() {
        return SSHAuthMethod.toString((List)this.preferredAuthentications.getValue());
    }

    public SOSArgument<List<SSHAuthMethod>> getRequiredAuthentications() {
        return this.requiredAuthentications;
    }

    public String getRequiredAuthenticationsAsString() {
        return SSHAuthMethod.toString((List)this.requiredAuthentications.getValue());
    }

    public SOSArgument<String> getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getSocketTimeoutAsMillis() {
        return (int)SOSArgumentHelper.asMillis(this.socketTimeout);
    }

    public SOSArgument<String> getServerAliveInterval() {
        return this.serverAliveInterval;
    }

    public int getServerAliveIntervalAsSeconds() {
        return (int)SOSArgumentHelper.asSeconds(this.serverAliveInterval, (long)0L);
    }

    public SOSArgument<Integer> getServerAliveCountMax() {
        return this.serverAliveCountMax;
    }

    public SOSArgument<Boolean> getStrictHostkeyChecking() {
        return this.strictHostkeyChecking;
    }

    public SOSArgument<Path> getHostkeyLocation() {
        return this.hostkeyLocation;
    }

    public SOSArgument<Boolean> getUseZlibCompression() {
        return this.useZlibCompression;
    }

    public SOSArgument<Boolean> getSimulateShell() {
        return this.simulateShell;
    }

    public SOSArgument<Charset> getRemoteCharset() {
        return this.remoteCharset;
    }

    public SOSArgument<SSHProviderType> getSSHProviderType() {
        return this.sshProviderType;
    }

    public static enum SSHProviderType {
        SSHJ;

    }
}

