/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.ssh.sshj;

import com.sos.commons.exception.SOSNoSuchFileException;
import com.sos.commons.exception.SOSRequiredArgumentMissingException;
import com.sos.commons.util.SOSClassUtil;
import com.sos.commons.util.SOSPathUtils;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.beans.SOSCommandResult;
import com.sos.commons.util.beans.SOSEnv;
import com.sos.commons.util.beans.SOSTimeout;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.vfs.commons.AProviderArguments;
import com.sos.commons.vfs.commons.file.ProviderFile;
import com.sos.commons.vfs.commons.file.selection.ProviderFileSelection;
import com.sos.commons.vfs.exceptions.ProviderClientNotInitializedException;
import com.sos.commons.vfs.exceptions.ProviderConnectException;
import com.sos.commons.vfs.exceptions.ProviderException;
import com.sos.commons.vfs.exceptions.ProviderInitializationException;
import com.sos.commons.vfs.ssh.SSHProvider;
import com.sos.commons.vfs.ssh.commons.SSHProviderArguments;
import com.sos.commons.vfs.ssh.exceptions.SOSSSHCommandExitViolentlyException;
import com.sos.commons.vfs.ssh.sshj.SSHJClientFactory;
import com.sos.commons.vfs.ssh.sshj.SSHJProviderReusableResource;
import com.sos.commons.vfs.ssh.sshj.SSHJProviderUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.connection.channel.direct.Signal;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.FileMode;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.xfer.FileSystemFile;
import net.schmizz.sshj.xfer.LocalDestFile;

public class SSHJProvider
extends SSHProvider {
    private SSHClient sshClient;
    private Map<String, Session.Command> commands = new ConcurrentHashMap<String, Session.Command>();
    private boolean reusableResourceEnabled;

    public SSHJProvider(ISOSLogger logger, SSHProviderArguments args) throws ProviderInitializationException {
        super(logger, args);
    }

    @Override
    public void connect() throws ProviderConnectException {
        if (SOSString.isEmpty((String)((String)((SSHProviderArguments)((Object)this.getArguments())).getHost().getValue()))) {
            throw new ProviderConnectException((Throwable)new SOSRequiredArgumentMissingException("host"));
        }
        try {
            this.getLogger().info((Object)this.getConnectMsg());
            this.sshClient = SSHJClientFactory.createAuthenticatedClient(this.getLogger(), (SSHProviderArguments)((Object)this.getArguments()), this.getProxyConfig());
            this.setServerVersion(this.sshClient.getTransport().getServerVersion());
            this.getServerInfo();
            this.getLogger().info((Object)this.getConnectedMsg(SSHJProviderUtils.getConnectedInfos(this.sshClient)));
            this.enableReusableResource();
        }
        catch (Throwable e) {
            if (this.isConnected()) {
                this.disconnect();
            }
            throw new ProviderConnectException(String.format("%s[%s]", this.getLogPrefix(), this.getAccessInfo()), e);
        }
    }

    @Override
    public boolean isConnected() {
        return this.sshClient == null ? false : this.sshClient.isConnected();
    }

    @Override
    public void disconnect() {
        if (this.sshClient == null) {
            this.commands.clear();
            return;
        }
        this.commands.clear();
        this.disableReusableResource();
        SOSClassUtil.closeQuietly((Closeable)this.sshClient);
        this.sshClient = null;
        this.getLogger().info((Object)this.getDisconnectedMsg());
    }

    @Override
    public List<ProviderFile> selectFiles(ProviderFileSelection selection) throws ProviderException {
        this.validatePrerequisites("selectFiles");
        selection = ProviderFileSelection.createIfNull(selection);
        selection.setFileTypeChecker(fileRepresentator -> {
            if (fileRepresentator == null) {
                return false;
            }
            FileAttributes r = (FileAttributes)fileRepresentator;
            return FileMode.Type.REGULAR.equals((Object)r.getType()) && ((EnumSet)((SSHProviderArguments)((Object)((Object)this.getArguments()))).getValidFileTypes().getValue()).contains((Object)AProviderArguments.FileType.REGULAR) || FileMode.Type.SYMLINK.equals((Object)r.getType()) && ((EnumSet)((SSHProviderArguments)((Object)((Object)this.getArguments()))).getValidFileTypes().getValue()).contains((Object)AProviderArguments.FileType.SYMLINK);
        });
        String directory = selection.getConfig().getDirectory() == null ? "." : selection.getConfig().getDirectory();
        try {
            ArrayList<ProviderFile> result = new ArrayList<ProviderFile>();
            SSHJProviderUtils.selectFiles(this, selection, directory, result);
            return result;
        }
        catch (Exception e) {
            throw new ProviderException(this.getPathOperationPrefix(directory), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean exists(String path) throws ProviderException {
        boolean bl;
        this.validatePrerequisites("exists", path, "path");
        SSHJProviderReusableResource reusable = this.getReusableResource();
        if (reusable != null) return SSHJProviderUtils.exists(reusable.getSFTPClient(), path);
        SFTPClient sftp = this.sshClient.newSFTPClient();
        try {
            bl = SSHJProviderUtils.exists(sftp, path);
            if (sftp == null) return bl;
        }
        catch (Throwable throwable) {
            try {
                if (sftp == null) throw throwable;
                try {
                    sftp.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new ProviderException(this.getPathOperationPrefix(path), e);
            }
        }
        sftp.close();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean createDirectoriesIfNotExists(String path) throws ProviderException {
        this.validatePrerequisites("createDirectoriesIfNotExists", path, "path");
        try {
            SSHJProviderReusableResource reusable = this.getReusableResource();
            if (reusable == null) {
                try (SFTPClient sftp = this.sshClient.newSFTPClient();){
                    if (SSHJProviderUtils.exists(sftp, path)) {
                        boolean bl = false;
                        return bl;
                    }
                    sftp.mkdirs(path);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("%s[createDirectoriesIfNotExists][%s]created", new Object[]{this.getLogPrefix(), path});
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            if (SSHJProviderUtils.exists(reusable.getSFTPClient(), path)) {
                return false;
            }
            reusable.getSFTPClient().mkdirs(path);
            if (!this.getLogger().isDebugEnabled()) return true;
            this.getLogger().debug("%s[createDirectoriesIfNotExists][%s]created", new Object[]{this.getLogPrefix(), path});
            return true;
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean deleteIfExists(String path) throws ProviderException {
        this.validatePrerequisites("deleteIfExists", path, "path");
        try {
            SSHJProviderReusableResource reusable = this.getReusableResource();
            if (reusable != null) {
                SSHJProviderUtils.delete(reusable.getSFTPClient(), path);
                return true;
            }
            try (SFTPClient sftp = this.sshClient.newSFTPClient();){
                SSHJProviderUtils.delete(sftp, path);
                boolean bl = true;
                return bl;
            }
        }
        catch (SOSNoSuchFileException e) {
            return false;
        }
        catch (Throwable e) {
            Throwable throwable;
            String string = this.getPathOperationPrefix(path);
            if (e.getCause() == null) {
                throwable = e;
                throw new ProviderException(string, throwable);
            }
            throwable = e.getCause();
            throw new ProviderException(string, throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean deleteFileIfExists(String path) throws ProviderException {
        this.validatePrerequisites("deleteIfExists", path, "path");
        try {
            SSHJProviderReusableResource reusable = this.getReusableResource();
            if (reusable != null) {
                SSHJProviderUtils.deleteFile(reusable.getSFTPClient(), path);
                return true;
            }
            try (SFTPClient sftp = this.sshClient.newSFTPClient();){
                SSHJProviderUtils.deleteFile(sftp, path);
                boolean bl = true;
                return bl;
            }
        }
        catch (SOSNoSuchFileException e) {
            return false;
        }
        catch (Throwable e) {
            Throwable throwable;
            String string = this.getPathOperationPrefix(path);
            if (e.getCause() == null) {
                throwable = e;
                throw new ProviderException(string, throwable);
            }
            throwable = e.getCause();
            throw new ProviderException(string, throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean renameFileIfSourceExists(String source, String target) throws ProviderException {
        this.validatePrerequisites("renameFileIfSourceExists", source, "source");
        this.validateArgument("renameFileIfSourceExists", target, "target");
        try {
            SSHJProviderReusableResource reusable = this.getReusableResource();
            if (reusable != null) {
                SFTPClient sftp = reusable.getSFTPClient();
                if (!SSHJProviderUtils.exists(sftp, source)) return false;
                SSHJProviderUtils.rename(sftp, source, target);
                return true;
            }
            try (SFTPClient sftp = this.sshClient.newSFTPClient();){
                if (SSHJProviderUtils.exists(sftp, source)) {
                    SSHJProviderUtils.rename(sftp, source, target);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(source + "->" + target), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ProviderFile getFileIfExists(String path) throws ProviderException {
        ProviderFile providerFile;
        this.validatePrerequisites("getFileIfExists", path, "path");
        SSHJProviderReusableResource reusable = this.getReusableResource();
        if (reusable != null) return this.createProviderFile(path, reusable.getSFTPClient().statExistence(path));
        SFTPClient sftp = this.sshClient.newSFTPClient();
        try {
            providerFile = this.createProviderFile(path, sftp.statExistence(path));
            if (sftp == null) return providerFile;
        }
        catch (Throwable throwable) {
            try {
                if (sftp == null) throw throwable;
                try {
                    sftp.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (NoSuchFileException e) {
                return null;
            }
            catch (IOException e) {
                throw new ProviderException(this.getPathOperationPrefix(path), e);
            }
        }
        sftp.close();
        return providerFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getFileContentIfExists(String path) throws ProviderException {
        String string;
        this.validatePrerequisites("getFileContentIfExists", path, "path");
        SSHJProviderReusableResource reusable = this.getReusableResource();
        if (reusable != null) return SSHJProviderUtils.getFileContentIfExists(reusable.getSFTPClient(), path);
        SFTPClient sftp = this.sshClient.newSFTPClient();
        try {
            string = SSHJProviderUtils.getFileContentIfExists(sftp, path);
            if (sftp == null) return string;
        }
        catch (Throwable throwable) {
            try {
                if (sftp == null) throw throwable;
                try {
                    sftp.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ProviderException(this.getPathOperationPrefix(path), e);
            }
        }
        sftp.close();
        return string;
    }

    @Override
    public void writeFile(String path, String content) throws ProviderException {
        block9: {
            this.validatePrerequisites("writeFile", path, "path");
            try {
                SSHJProviderReusableResource reusable = this.getReusableResource();
                if (reusable == null) {
                    try (SFTPClient sftp = this.sshClient.newSFTPClient();){
                        SSHJProviderUtils.uploadContent(sftp, path, content);
                        break block9;
                    }
                }
                SSHJProviderUtils.uploadContent(reusable.getSFTPClient(), path, content);
            }
            catch (Throwable e) {
                throw new ProviderException(this.getPathOperationPrefix(path), e);
            }
        }
    }

    @Override
    public void setFileLastModifiedFromMillis(String path, long milliseconds) throws ProviderException {
        block9: {
            this.validatePrerequisites("setFileLastModifiedFromMillis", path, path);
            this.validateModificationTime(path, milliseconds);
            try {
                SSHJProviderReusableResource reusable = this.getReusableResource();
                if (reusable == null) {
                    try (SFTPClient sftp = this.sshClient.newSFTPClient();){
                        SSHJProviderUtils.setFileLastModifiedFromMillis(sftp, path, milliseconds);
                        break block9;
                    }
                }
                SSHJProviderUtils.setFileLastModifiedFromMillis(reusable.getSFTPClient(), path, milliseconds);
            }
            catch (Throwable e) {
                throw new ProviderException(this.getPathOperationPrefix(path), e);
            }
        }
    }

    @Override
    public InputStream getInputStream(String path) throws ProviderException {
        this.validatePrerequisites("getInputStream", path, "path");
        final AtomicReference<SFTPClient> sftpRef = new AtomicReference<SFTPClient>();
        SSHJProviderReusableResource reusable = this.getReusableResource();
        final boolean closeSFTPClient = reusable == null;
        try {
            RemoteFile remoteFile;
            SFTPClient sftpClient = reusable == null ? this.sshClient.newSFTPClient() : reusable.getSFTPClient();
            sftpRef.set(sftpClient);
            RemoteFile remoteFile2 = remoteFile = ((SFTPClient)sftpRef.get()).open(path);
            Objects.requireNonNull(remoteFile2);
            return new RemoteFile.ReadAheadRemoteFileInputStream(remoteFile2, 16){
                private final AtomicBoolean close;
                {
                    RemoteFile remoteFile2 = x0;
                    Objects.requireNonNull(remoteFile2);
                    super(remoteFile2, arg0);
                    this.close = new AtomicBoolean();
                }

                public void close() throws IOException {
                    if (this.close.get()) {
                        return;
                    }
                    try {
                        super.close();
                    }
                    finally {
                        SOSClassUtil.closeQuietly((Closeable)remoteFile);
                        if (closeSFTPClient) {
                            SOSClassUtil.closeQuietly((Closeable)((Closeable)sftpRef.get()));
                        }
                        this.close.set(true);
                    }
                }
            };
        }
        catch (Throwable e) {
            if (closeSFTPClient) {
                SOSClassUtil.closeQuietly((Closeable)((Closeable)sftpRef.get()));
            }
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public OutputStream getOutputStream(String path, boolean append) throws ProviderException {
        this.validatePrerequisites("getOutputStream", path, "path");
        final AtomicReference<SFTPClient> sftpRef = new AtomicReference<SFTPClient>();
        SSHJProviderReusableResource reusable = this.getReusableResource();
        final boolean closeSFTPClient = reusable == null;
        try {
            RemoteFile remoteFile;
            SFTPClient sftpClient = reusable == null ? this.sshClient.newSFTPClient() : reusable.getSFTPClient();
            sftpRef.set(sftpClient);
            EnumSet<OpenMode> mode = EnumSet.of(OpenMode.WRITE, OpenMode.CREAT);
            if (append) {
                mode.add(OpenMode.APPEND);
            } else {
                mode.add(OpenMode.TRUNC);
            }
            RemoteFile remoteFile2 = remoteFile = ((SFTPClient)sftpRef.get()).open(path, mode);
            Objects.requireNonNull(remoteFile2);
            return new RemoteFile.RemoteFileOutputStream(remoteFile2, 0L, 16){
                private final AtomicBoolean close;
                {
                    RemoteFile remoteFile2 = x0;
                    Objects.requireNonNull(remoteFile2);
                    super(remoteFile2, arg0, arg1);
                    this.close = new AtomicBoolean();
                }

                public void close() throws IOException {
                    if (this.close.get()) {
                        return;
                    }
                    try {
                        super.close();
                    }
                    finally {
                        SOSClassUtil.closeQuietly((Closeable)remoteFile);
                        if (closeSFTPClient) {
                            SOSClassUtil.closeQuietly((Closeable)((Closeable)sftpRef.get()));
                        }
                        this.close.set(true);
                    }
                }
            };
        }
        catch (Throwable e) {
            if (closeSFTPClient) {
                SOSClassUtil.closeQuietly((Closeable)((Closeable)sftpRef.get()));
            }
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public SOSCommandResult executeCommand(String command, SOSTimeout timeout, SOSEnv env) {
        SOSCommandResult result = new SOSCommandResult(command);
        if (this.sshClient == null) {
            return result;
        }
        String uuid = this.createCommandIdentifier();
        try (Session session = this.sshClient.startSession();){
            if (((Boolean)((SSHProviderArguments)((Object)this.getArguments())).getSimulateShell().getValue()).booleanValue()) {
                session.allocateDefaultPTY();
            }
            result.setCommand(this.handleCommandEnvs(command, session, env));
            try (Session.Command cmd = session.exec(result.getCommand());){
                this.commands.put(uuid, cmd);
                result.setStdOut(IOUtils.readFully((InputStream)cmd.getInputStream()).toString());
                result.setStdErr(IOUtils.readFully((InputStream)cmd.getErrorStream()).toString());
                if (timeout == null) {
                    cmd.join();
                } else {
                    cmd.join(timeout.getInterval(), timeout.getTimeUnit());
                }
                result.setExitCode(cmd.getExitStatus());
                if (result.getExitCode() == null && cmd.getExitSignal() != null) {
                    throw new SOSSSHCommandExitViolentlyException(cmd.getExitSignal(), cmd.getExitErrorMessage());
                }
            }
        }
        catch (Throwable e) {
            result.setException(e);
        }
        this.resetCommand(uuid);
        return result;
    }

    @Override
    public SOSCommandResult cancelCommands() {
        SOSCommandResult r = null;
        if (this.commands != null && this.commands.size() > 0) {
            r = new SOSCommandResult("Signal.KILL");
            Iterator<Map.Entry<String, Session.Command>> iterator = this.commands.entrySet().iterator();
            while (iterator.hasNext()) {
                try {
                    Session.Command command = iterator.next().getValue();
                    command.signal(Signal.KILL);
                    r.setExitCode(command.getExitStatus());
                }
                catch (SSHException e) {
                    r.setException((Throwable)e);
                }
                iterator.remove();
            }
        }
        return r;
    }

    @Override
    public void validatePrerequisites(String method) throws ProviderException {
        if (this.sshClient == null) {
            throw new ProviderClientNotInitializedException(this.getLogPrefix() + method + "SSHClient");
        }
    }

    @Override
    public void enableReusableResource() {
        if (this.reusableResourceEnabled) {
            return;
        }
        if (AProviderArguments.Protocol.SSH.equals(((SSHProviderArguments)((Object)this.getArguments())).getProtocol().getValue())) {
            this.reusableResourceEnabled = false;
            return;
        }
        try {
            super.enableReusableResource(new SSHJProviderReusableResource(this));
            this.reusableResourceEnabled = true;
        }
        catch (Exception e) {
            this.getLogger().warn((Object)(this.getLogPrefix() + "[enableReusableResource]" + e));
        }
    }

    public SSHJProviderReusableResource getReusableResource() {
        if (!this.reusableResourceEnabled) {
            return null;
        }
        return (SSHJProviderReusableResource)super.getReusableResource();
    }

    @Override
    public void disableReusableResource() {
        super.disableReusableResource();
        this.reusableResourceEnabled = false;
    }

    @Override
    public void put(String source, String target, int perm) throws ProviderException {
        block9: {
            try {
                SSHJProviderReusableResource reusable = this.getReusableResource();
                if (reusable == null) {
                    try (SFTPClient sftp = this.sshClient.newSFTPClient();){
                        SSHJProviderUtils.put(sftp, source, target);
                        sftp.chmod(target, perm);
                        break block9;
                    }
                }
                SSHJProviderUtils.put(reusable.getSFTPClient(), source, target);
                reusable.getSFTPClient().chmod(target, perm);
            }
            catch (Throwable e) {
                throw new ProviderException(this.getPathOperationPrefix(source) + "[" + target + "][perm=" + perm + "]", e);
            }
        }
    }

    @Override
    public void put(String source, String target) throws ProviderException {
        block9: {
            try {
                SSHJProviderReusableResource reusable = this.getReusableResource();
                if (reusable == null) {
                    try (SFTPClient sftp = this.sshClient.newSFTPClient();){
                        SSHJProviderUtils.put(sftp, source, target);
                        break block9;
                    }
                }
                SSHJProviderUtils.put(reusable.getSFTPClient(), source, target);
            }
            catch (Throwable e) {
                throw new ProviderException(this.getPathOperationPrefix(source) + "[" + target + "]", e);
            }
        }
    }

    @Override
    public void get(String source, String target) throws ProviderException {
        block9: {
            try {
                SSHJProviderReusableResource reusable = this.getReusableResource();
                if (reusable == null) {
                    try (SFTPClient sftp = this.sshClient.newSFTPClient();){
                        sftp.get(sftp.canonicalize(source), (LocalDestFile)new FileSystemFile(target));
                        break block9;
                    }
                }
                reusable.getSFTPClient().get(reusable.getSFTPClient().canonicalize(source), (LocalDestFile)new FileSystemFile(target));
            }
            catch (Throwable e) {
                throw new ProviderException(this.getPathOperationPrefix(source) + "[" + target + "]", e);
            }
        }
    }

    @Override
    public boolean deleteDirectory(String directory) throws ProviderException {
        if (this.getServerInfo().isWindowsShell()) {
            return this.deleteWindowsDirectory(directory);
        }
        return this.deleteUnixDirectory(directory);
    }

    @Override
    public boolean deleteUnixDirectory(String directory) throws ProviderException {
        if (SOSString.isEmpty((String)directory)) {
            return false;
        }
        String dir = this.toPathStyle(directory);
        SOSCommandResult r = this.executeCommand("rm -f -R \"" + dir + "\"");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this.getPathOperationPrefix(dir) + "[deleteUnixDirectory]" + r));
        }
        if (r.hasError()) {
            return this.deleteIfExists(dir);
        }
        return true;
    }

    @Override
    public boolean deleteWindowsDirectory(String directory) throws ProviderException {
        if (SOSString.isEmpty((String)directory)) {
            return false;
        }
        String dir = SOSPathUtils.toWindowsStyle((String)directory);
        if (dir.startsWith("\\")) {
            dir = dir.substring(1);
        }
        SOSCommandResult r = this.executeCommand("rmdir /s /q \"" + dir + "\"");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this.getPathOperationPrefix(dir) + "[deleteWindowsDirectory]" + r));
        }
        if (r.hasError()) {
            return this.deleteIfExists(dir);
        }
        return true;
    }

    public SSHClient getSSHClient() {
        return this.sshClient;
    }

    protected ProviderFile createProviderFile(String path, FileAttributes attr) {
        if (attr == null) {
            return null;
        }
        return this.createProviderFile(path, attr.getSize(), SSHJProviderUtils.getFileLastModifiedMillis(attr));
    }

    private synchronized String createCommandIdentifier() {
        return UUID.randomUUID().toString();
    }

    private void resetCommand(String uuid) {
        this.commands.remove(uuid);
    }

    private String handleCommandEnvs(String command, Session session, SOSEnv env) throws Exception {
        if (env == null) {
            return command;
        }
        if (env.getGlobalEnvs() != null && env.getGlobalEnvs().size() > 0) {
            for (Map.Entry entry : env.getGlobalEnvs().entrySet()) {
                try {
                    session.setEnvVar((String)entry.getKey(), (String)entry.getValue());
                }
                catch (Throwable e) {
                    throw new Exception(String.format("[can't set ssh session environment variable][%s=%s]%s", entry.getKey(), entry.getValue(), e.toString()), e);
                }
            }
        }
        if (env.getLocalEnvs() != null && env.getLocalEnvs().size() > 0) {
            this.getServerInfo();
            StringBuilder envs = new StringBuilder();
            for (Map.Entry entry : env.getLocalEnvs().entrySet()) {
                if (this.getServerInfo().isWindowsShell()) {
                    envs.append(String.format("set %s=%s&", entry.getKey(), entry.getValue()));
                    continue;
                }
                envs.append(String.format("export \"%s=%s\";", entry.getKey(), entry.getValue()));
            }
            command = envs.toString() + (String)command;
        }
        return command;
    }

    private void validatePrerequisites(String method, String argValue, String msg) throws ProviderException {
        this.validatePrerequisites(method);
        this.validateArgument(method, argValue, msg);
    }
}

