/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.ssh.sshj;

import com.sos.commons.exception.SOSNoSuchFileException;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.vfs.commons.AProvider;
import com.sos.commons.vfs.commons.file.ProviderFile;
import com.sos.commons.vfs.commons.file.selection.ProviderFileSelection;
import com.sos.commons.vfs.ssh.sshj.SSHJProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Deque;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.schmizz.keepalive.KeepAlive;
import net.schmizz.keepalive.KeepAliveRunner;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.FileMode;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.RenameFlags;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.xfer.FileSystemFile;
import net.schmizz.sshj.xfer.LocalSourceFile;

public class SSHJProviderUtils {
    protected static boolean is(ISOSLogger logger, String logPrefix, SFTPClient sftp, String path, FileMode.Type type) {
        block3: {
            try {
                FileAttributes attr = sftp.stat(path);
                if (attr != null) {
                    return type.equals((Object)attr.getType());
                }
            }
            catch (Throwable e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("%s[is][%s][type=%s]%s", new Object[]{logPrefix, path, type, e.toString()});
            }
        }
        return false;
    }

    protected static void throwException(SFTPException e, String msg) throws Exception {
        Response.StatusCode sc = e.getStatusCode();
        if (sc != null && (sc.equals((Object)Response.StatusCode.NO_SUCH_FILE) || sc.equals((Object)Response.StatusCode.NO_SUCH_PATH))) {
            throw new SOSNoSuchFileException(msg, (Throwable)e);
        }
        throw e;
    }

    protected static void dirInfo(SFTPClient sftp, String path, Deque<RemoteResourceInfo> result, boolean recursive) throws Exception {
        List infos = sftp.ls(path);
        for (RemoteResourceInfo resource : infos) {
            result.push(resource);
            if (!recursive || !resource.isDirectory()) continue;
            SSHJProviderUtils.dirInfo(sftp, resource.getPath(), result, recursive);
        }
    }

    protected static List<String> getConnectedInfos(SSHClient ssh) {
        KeepAlive ka;
        ArrayList<String> msg = new ArrayList<String>();
        if (ssh.getTimeout() > 0 || ssh.getConnectTimeout() > 0) {
            msg.add("ConnectTimeout=" + AProvider.millis2string(ssh.getConnectTimeout()) + ", SocketTimeout=" + AProvider.millis2string(ssh.getTimeout()));
        }
        if (ssh.getConnection() != null && (ka = ssh.getConnection().getKeepAlive()).getKeepAliveInterval() > 0) {
            if (ka instanceof KeepAliveRunner) {
                msg.add("KeepAliveInterval=" + ka.getKeepAliveInterval() + "s, MaxAliveCount=" + ((KeepAliveRunner)ka).getMaxAliveCount());
            } else {
                msg.add("KeepAliveInterval=" + ka.getKeepAliveInterval() + "s");
            }
        }
        return msg;
    }

    protected static long getFileLastModifiedMillis(FileAttributes attr) {
        return attr.getMtime() * 1000L;
    }

    protected static void delete(SFTPClient sftp, String path) throws Exception {
        try {
            path = sftp.canonicalize(path);
        }
        catch (SFTPException e) {
            SSHJProviderUtils.throwException(e, path);
        }
        FileAttributes attr = sftp.stat(path);
        switch (attr.getType()) {
            case DIRECTORY: {
                SSHJProviderUtils.deleteDirectories(sftp, path);
                break;
            }
            case REGULAR: {
                sftp.rm(path);
                break;
            }
        }
    }

    protected static void deleteFile(SFTPClient sftp, String path) throws Exception {
        try {
            path = sftp.canonicalize(path);
        }
        catch (SFTPException e) {
            SSHJProviderUtils.throwException(e, path);
        }
        try {
            sftp.rm(path);
        }
        catch (SFTPException e) {
            SSHJProviderUtils.throwException(e, path);
        }
    }

    protected static boolean exists(SFTPClient sftp, String path) throws IOException {
        return sftp.statExistence(path) != null;
    }

    protected static List<ProviderFile> selectFiles(SSHJProvider provider, ProviderFileSelection selection, String directoryPath, List<ProviderFile> result) throws Exception {
        int counterAdded = 0;
        try (SFTPClient sftp = provider.getSSHClient().newSFTPClient();){
            SSHJProviderUtils.list(provider, sftp, selection, directoryPath, result, counterAdded);
        }
        return result;
    }

    protected static void put(SFTPClient sftp, String source, String target) throws IOException {
        sftp.put((LocalSourceFile)new FileSystemFile(source), target);
    }

    protected static void rename(SFTPClient sftp, String sourcePath, String targetPath) throws Exception {
        try {
            sourcePath = sftp.canonicalize(sourcePath);
        }
        catch (SFTPException e) {
            SSHJProviderUtils.throwException(e, sourcePath);
        }
        sftp.rename(sourcePath, targetPath, Set.of(RenameFlags.OVERWRITE));
    }

    protected static void setFileLastModifiedFromMillis(SFTPClient sftp, String path, long milliseconds) throws IOException {
        FileAttributes attr = sftp.stat(path);
        long seconds = milliseconds / 1000L;
        FileAttributes newAttr = new FileAttributes.Builder().withAtimeMtime(attr.getAtime(), seconds).build();
        sftp.setattr(path, newAttr);
    }

    protected static String getFileContentIfExists(SFTPClient sftp, String path) throws IOException {
        if (!SSHJProviderUtils.exists(sftp, path)) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (RemoteFile file = sftp.open(path);){
            RemoteFile remoteFile = file;
            Objects.requireNonNull(remoteFile);
            try (RemoteFile.RemoteFileInputStream is = new RemoteFile.RemoteFileInputStream(remoteFile, 0L);){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = is.read(buffer)) != -1) {
                    baos.write(buffer, 0, bytesRead);
                }
            }
        }
        return baos.toString(StandardCharsets.UTF_8);
    }

    protected static void uploadContent(SFTPClient sftp, String path, String content) throws IOException {
        EnumSet<OpenMode> mode = EnumSet.of(OpenMode.WRITE, OpenMode.CREAT, OpenMode.TRUNC);
        byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
        try (RemoteFile remoteFile = sftp.open(path, mode);){
            remoteFile.write(0L, bytes, 0, bytes.length);
        }
    }

    protected static String toString(FileAttributes attr) {
        if (attr == null) {
            return null;
        }
        return "type=" + attr.getType() + "," + attr.toString();
    }

    private static void deleteDirectories(SFTPClient sftp, String path) throws Exception {
        LinkedList<RemoteResourceInfo> toRemove = new LinkedList<RemoteResourceInfo>();
        SSHJProviderUtils.dirInfo(sftp, path, toRemove, true);
        while (!toRemove.isEmpty()) {
            RemoteResourceInfo resource = (RemoteResourceInfo)toRemove.pop();
            if (resource.isDirectory()) {
                sftp.rmdir(resource.getPath());
                continue;
            }
            if (!resource.isRegularFile()) continue;
            sftp.rm(resource.getPath());
        }
        sftp.rmdir(path);
    }

    private static int list(SSHJProvider provider, SFTPClient sftp, ProviderFileSelection selection, String directoryPath, List<ProviderFile> result, int counterAdded) throws Exception {
        List subDirInfos = sftp.ls(directoryPath);
        for (RemoteResourceInfo subResource : subDirInfos) {
            if (selection.maxFilesExceeded(counterAdded)) {
                return counterAdded;
            }
            counterAdded = SSHJProviderUtils.processListEntry(provider, sftp, selection, subResource, result, counterAdded);
        }
        return counterAdded;
    }

    private static int processListEntry(SSHJProvider provider, SFTPClient sftp, ProviderFileSelection selection, RemoteResourceInfo resource, List<ProviderFile> result, int counterAdded) throws Exception {
        if (resource.isDirectory()) {
            if (selection.getConfig().isRecursive() && selection.checkDirectory(resource.getPath())) {
                counterAdded = SSHJProviderUtils.list(provider, sftp, selection, resource.getPath(), result, counterAdded);
            }
        } else if (selection.checkFileName(resource.getName()) && selection.isValidFileType(resource.getAttributes())) {
            ProviderFile file = provider.createProviderFile(resource.getPath(), resource.getAttributes());
            if (file == null) {
                if (provider.getLogger().isDebugEnabled()) {
                    provider.getLogger().debug((Object)(provider.getPathOperationPrefix(resource.getPath()) + "[skip]" + SSHJProviderUtils.toString(resource.getAttributes())));
                }
            } else if (selection.checkProviderFileMinMaxSize(file)) {
                file.setIndex(++counterAdded);
                result.add(file);
                if (provider.getLogger().isDebugEnabled()) {
                    provider.getLogger().debug((Object)(provider.getPathOperationPrefix(file.getFullPath()) + "added"));
                }
            }
        }
        return counterAdded;
    }
}

