/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.webdav;

import com.sos.commons.httpclient.BaseHttpClient;
import com.sos.commons.httpclient.commons.HttpExecutionResult;
import com.sos.commons.util.http.HttpUtils;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.vfs.commons.file.ProviderFile;
import com.sos.commons.vfs.commons.file.selection.ProviderFileSelection;
import com.sos.commons.vfs.exceptions.ProviderException;
import com.sos.commons.vfs.exceptions.ProviderInitializationException;
import com.sos.commons.vfs.http.HTTPProvider;
import com.sos.commons.vfs.webdav.commons.WebDAVProviderArguments;
import com.sos.commons.vfs.webdav.commons.WebDAVProviderUtils;
import com.sos.commons.vfs.webdav.commons.WebDAVResource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpRequest;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

public class WebDAVProvider
extends HTTPProvider {
    public WebDAVProvider(ISOSLogger logger, WebDAVProviderArguments args) throws ProviderInitializationException {
        super(logger, args);
    }

    @Override
    public List<ProviderFile> selectFiles(ProviderFileSelection selection) throws ProviderException {
        this.validatePrerequisites("selectFiles");
        selection = ProviderFileSelection.createIfNull(selection);
        String directory = selection.getConfig().getDirectory() == null ? "" : selection.getConfig().getDirectory();
        try {
            ArrayList<ProviderFile> result = new ArrayList<ProviderFile>();
            WebDAVProviderUtils.selectFiles(this, selection, directory, result);
            return result;
        }
        catch (Exception e) {
            throw new ProviderException(this.getPathOperationPrefix(directory), e);
        }
    }

    @Override
    public boolean exists(String path) throws ProviderException {
        this.validatePrerequisites("exists", path, "path");
        try {
            return WebDAVProviderUtils.exists(this.getClient(), new URI(this.normalizePath(path)));
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public boolean createDirectoriesIfNotExists(String path) throws ProviderException {
        this.validatePrerequisites("createDirectoriesIfNotExists", path, "path");
        try {
            URI uri = new URI(this.normalizePath(path));
            if (WebDAVProviderUtils.directoryExists(this, uri)) {
                return false;
            }
            ArrayDeque<URI> parentsToCreate = new ArrayDeque<URI>();
            URI parent = HttpUtils.getParentURI((URI)uri);
            while (parent != null && !parent.equals(uri) && !WebDAVProviderUtils.directoryExists(this, parent)) {
                parentsToCreate.push(parent);
                parent = HttpUtils.getParentURI((URI)parent);
            }
            while (!parentsToCreate.isEmpty()) {
                WebDAVProviderUtils.createDirectory(this, (URI)parentsToCreate.pop());
            }
            WebDAVProviderUtils.createDirectory(this, uri);
            return true;
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public boolean renameFileIfSourceExists(String source, String target) throws ProviderException {
        this.validatePrerequisites("renameFileIfSourceExists", source, "source");
        this.validateArgument("renameFileIfSourceExists", target, "target");
        try {
            URI sourceURI = new URI(this.normalizePath(source));
            URI targetURI = new URI(this.normalizePath(target));
            HttpRequest.Builder builder = this.getClient().createRequestBuilder(sourceURI);
            builder.header("Destination", targetURI.toString());
            HttpExecutionResult result = this.getClient().executeNoResponseBody(builder.method("MOVE", HttpRequest.BodyPublishers.noBody()).build());
            int code = result.response().statusCode();
            if (!HttpUtils.isSuccessful((int)code)) {
                if (HttpUtils.isNotFound((int)code)) {
                    return false;
                }
                throw new IOException(BaseHttpClient.formatExecutionResult((HttpExecutionResult)result));
            }
            return true;
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(source + "->" + target), e);
        }
    }

    @Override
    public ProviderFile getFileIfExists(String path) throws ProviderException {
        this.validatePrerequisites("getFileIfExists", path, "path");
        try {
            return this.createProviderFile(WebDAVProviderUtils.getResource(this, new URI(this.normalizePath(path))));
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public void writeFile(String path, String content) throws ProviderException {
        this.uploadContent(path, content, true);
    }

    @Override
    public long upload(String path, InputStream source, long sourceSize) throws ProviderException {
        return this.upload(path, source, sourceSize, true);
    }

    public ProviderFile createProviderFile(WebDAVResource resource) {
        if (resource == null) {
            return null;
        }
        if (resource.getSize() < 0L) {
            return null;
        }
        return this.createProviderFile(resource.getURI(), resource.getSize(), resource.getLastModifiedInMillis());
    }
}

