/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.httpclient.azure.commons;

import com.sos.commons.httpclient.azure.AzureBlobStorageClient;
import com.sos.commons.httpclient.commons.HttpExecutionResult;
import com.sos.commons.util.SOSClassUtil;
import com.sos.commons.util.http.HttpUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;

public class AzureBlobStorageOutputStream
extends OutputStream {
    private final AzureBlobStorageClient client;
    private final String containerName;
    private final String blobPath;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    public AzureBlobStorageOutputStream(AzureBlobStorageClient client, String containerName, String blobPath) throws IOException {
        this.client = client;
        this.containerName = containerName;
        this.blobPath = blobPath;
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.buffer.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.buffer.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            HttpExecutionResult<String> result = this.client.executePUTBlob(this.containerName, this.blobPath, this.buffer.toByteArray(), "application/octet-stream");
            int code = result.response().statusCode();
            if (!HttpUtils.isSuccessful((int)code)) {
                throw new Exception(AzureBlobStorageClient.formatExecutionResult(result));
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            SOSClassUtil.closeQuietly((Closeable)this.buffer);
            super.close();
        }
    }
}

