/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.httpclient.azure.commons.auth;

import com.sos.commons.httpclient.azure.commons.auth.blob.AzureBlobStorageClientAuthMethod;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.loggers.base.ISOSLogger;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public abstract class AAzureStorageAuthProvider {
    public static final String NEW_LINE = "\n";
    private static final String DEFAULT_API_VERSION = "2020-10-02";
    private final ISOSLogger logger;
    private final AzureBlobStorageClientAuthMethod method;
    private final String accountName;
    private final byte[] accountKeyBytes;
    private String apiVersion;

    public AAzureStorageAuthProvider(ISOSLogger logger, AzureBlobStorageClientAuthMethod method, String accountName, String base64AccountKey, String apiVersion) {
        this.logger = logger;
        this.method = method;
        this.accountName = accountName;
        this.accountKeyBytes = this.decodeAccountKey(base64AccountKey);
        this.apiVersion = SOSString.isEmpty((String)apiVersion) ? DEFAULT_API_VERSION : apiVersion;
    }

    public abstract Map<String, String> createAuthHeaders(String var1, String var2, String var3, Map<String, String> var4, long var5) throws Exception;

    public abstract String appendToUrl(String var1);

    public byte[] decodeAccountKey(String base64AccountKey) {
        return base64AccountKey == null ? null : Base64.getDecoder().decode(base64AccountKey);
    }

    public String signString(String stringToSign) throws Exception {
        if (stringToSign == null || this.accountKeyBytes == null) {
            return null;
        }
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(this.accountKeyBytes, "HmacSHA256"));
        byte[] rawHmac = mac.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(rawHmac);
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public ISOSLogger getLogger() {
        return this.logger;
    }

    public AzureBlobStorageClientAuthMethod getMethod() {
        return this.method;
    }

    public boolean hasAccountKey() {
        return this.accountKeyBytes != null;
    }

    public boolean isSharedKey() {
        return AzureBlobStorageClientAuthMethod.SHARED_KEY.equals((Object)this.method);
    }

    public boolean isSASToken() {
        return AzureBlobStorageClientAuthMethod.SAS_TOKEN.equals((Object)this.method);
    }

    public boolean isPublic() {
        return AzureBlobStorageClientAuthMethod.PUBLIC.equals((Object)this.method);
    }
}

