/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.httpclient.azure.commons.auth.blob;

import com.sos.commons.exception.SOSRequiredArgumentMissingException;
import com.sos.commons.httpclient.azure.commons.auth.blob.AzureBlobSASAuthProvider;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AzureBlobSASAuthTokenResolver {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'").withZone(ZoneOffset.UTC);

    public static String resolveToken(AzureBlobSASAuthProvider authProvider, String sasToken) throws Exception {
        if (sasToken == null || !sasToken.contains("[")) {
            return sasToken;
        }
        HashMap<String, String> contextVars = new HashMap<String, String>();
        contextVars.put("api_version", authProvider.getApiVersion());
        contextVars.put("now", FORMATTER.format(Instant.now()));
        sasToken = AzureBlobSASAuthTokenResolver.replaceTimeVariables(sasToken);
        String tokenResolvedExceptSign = AzureBlobSASAuthTokenResolver.replaceStaticVariables(sasToken, contextVars);
        if (authProvider.getLogger().isDebugEnabled()) {
            authProvider.getLogger().debug("[resolveToken][tokenResolvedExceptSign]%s", new Object[]{tokenResolvedExceptSign});
        }
        if (tokenResolvedExceptSign.contains("[sign]")) {
            if (authProvider.hasAccountKey()) {
                String toSign = AzureBlobSASAuthTokenResolver.extractStringToSign(tokenResolvedExceptSign, authProvider.getAccountName());
                if (authProvider.getLogger().isDebugEnabled()) {
                    authProvider.getLogger().debug("[resolveToken][toSign]%s", new Object[]{toSign});
                }
                String signature = AzureBlobSASAuthTokenResolver.encode(authProvider.signString(toSign));
                contextVars.put("sign", signature);
            } else {
                throw new SOSRequiredArgumentMissingException("[SASToken->Token]The [sign] variable is used, but the signature cannot be generated because the AccountKey is missing");
            }
        }
        return AzureBlobSASAuthTokenResolver.replaceStaticVariables(tokenResolvedExceptSign, contextVars);
    }

    private static String encode(String s) {
        if (s == null) {
            return null;
        }
        return URLEncoder.encode(s, StandardCharsets.UTF_8);
    }

    private static String replaceStaticVariables(String input, Map<String, String> values) {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            input = input.replace("[" + entry.getKey() + "]", entry.getValue());
        }
        return input;
    }

    private static String replaceTimeVariables(String input) {
        Pattern pattern = Pattern.compile("\\[now([+-])(\\d+)([mhd])]");
        Matcher matcher = pattern.matcher(input);
        Instant now = Instant.now();
        while (matcher.find()) {
            String unit;
            String sign = matcher.group(1);
            int amount = Integer.parseInt(matcher.group(2));
            Duration delta = switch (unit = matcher.group(3)) {
                case "m" -> Duration.ofMinutes(amount);
                case "h" -> Duration.ofHours(amount);
                case "d" -> Duration.ofDays(amount);
                default -> Duration.ZERO;
            };
            Instant adjusted = sign.equals("+") ? now.plus(delta) : now.minus(delta);
            String replacement = FORMATTER.format(adjusted);
            input = input.replace(matcher.group(0), replacement);
        }
        return input;
    }

    private static String extractStringToSign(String token, String accountName) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        for (String part : token.split("&")) {
            String[] kv = part.split("=", 2);
            if (kv.length != 2 || kv[0].startsWith("[")) continue;
            params.put(kv[0], kv[1]);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(accountName).append("\n");
        sb.append(params.getOrDefault("sp", "")).append("\n");
        sb.append(params.getOrDefault("ss", "")).append("\n");
        sb.append(params.getOrDefault("srt", "")).append("\n");
        sb.append(params.getOrDefault("st", "")).append("\n");
        sb.append(params.getOrDefault("se", "")).append("\n");
        sb.append("").append("\n");
        sb.append(params.getOrDefault("spr", "")).append("\n");
        sb.append(params.getOrDefault("sv", "")).append("\n");
        return sb.toString();
    }
}

