/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.httpclient.commons.auth;

import com.sos.commons.httpclient.commons.auth.IHttpClientAuthStrategy;
import com.sos.commons.util.SOSShell;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.loggers.base.ISOSLogger;
import java.net.Authenticator;
import java.net.UnknownHostException;
import java.util.LinkedHashMap;
import java.util.Map;

public class HttpClientNtlmAuthStrategy
implements IHttpClientAuthStrategy {
    private final String password;
    private final String workstation;
    private final boolean hasAuthenticator;
    private String username;
    private String domain;
    private String token;
    private Map<String, String> authHeaders;

    public HttpClientNtlmAuthStrategy(ISOSLogger logger, String username, String password, String workstation, String domain) {
        this.username = username;
        this.password = password;
        this.workstation = this.getWorkstation(logger, workstation);
        this.hasAuthenticator = false;
        if (SOSString.isEmpty((String)domain) && username.contains("\\")) {
            String[] parts = username.split("\\\\");
            if (parts.length > 1) {
                this.domain = parts[0];
                this.username = parts[1];
            } else {
                this.domain = "";
            }
        } else {
            this.domain = domain;
        }
        this.token = null;
    }

    @Override
    public boolean hasAuthenticator() {
        return this.hasAuthenticator;
    }

    @Override
    public Authenticator toAuthenticator() {
        return null;
    }

    @Override
    public Map<String, String> getAuthHeaders() {
        return this.authHeaders;
    }

    public void setAuthHeaders(Map<String, String> headers) {
        this.authHeaders = headers;
    }

    private void setNtlmHeader() {
        if (this.authHeaders == null) {
            this.authHeaders = new LinkedHashMap<String, String>();
        }
        if (!this.authHeaders.containsKey("authorization")) {
            this.authHeaders.put("authorization", "NTLM " + this.token);
        }
    }

    private String getWorkstation(ISOSLogger logger, String workstation) {
        if (SOSString.isEmpty((String)workstation)) {
            try {
                return SOSShell.getLocalHostName();
            }
            catch (UnknownHostException e) {
                logger.warn((Object)("[HttpClientNtlmAuthStrategy][workstation][getLocalHostName]" + e.toString()));
            }
        }
        return workstation;
    }
}

