/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.commons;

import com.sos.commons.vfs.commons.file.ProviderFile;
import com.sos.yade.commons.Yade;
import com.sos.yade.engine.commons.YADEDirectoryMapper;
import com.sos.yade.engine.commons.delegators.AYADEProviderDelegator;
import com.sos.yade.engine.handlers.operations.copymove.file.commons.YADETargetProviderFile;

public class YADEProviderFile
extends ProviderFile {
    private Steady steady = null;
    private YADETargetProviderFile target;
    private Yade.TransferEntryState state = null;
    private Yade.TransferEntryState subState;
    private String parentFullPath;
    private String finalFullPath;
    private String integrityHash;

    public YADEProviderFile(AYADEProviderDelegator delegator, String fullPath, long size, long lastModifiedMillis, YADEDirectoryMapper directoryMapper, boolean checkSteady) {
        super(delegator.getProvider(), fullPath, size, lastModifiedMillis);
        this.parentFullPath = delegator.getParentPath(this.getFullPath());
        if (directoryMapper != null) {
            directoryMapper.addSourceFileDirectory(this.parentFullPath);
        }
        if (checkSteady) {
            this.steady = new Steady(this.getSize());
        }
    }

    public String getParentFullPath() {
        return this.parentFullPath;
    }

    public Steady getSteady() {
        return this.steady;
    }

    public Yade.TransferEntryState getState() {
        return this.state;
    }

    public void setState(Yade.TransferEntryState val) {
        this.state = val;
    }

    public boolean isTransferred() {
        return Yade.TransferEntryState.TRANSFERRED.equals((Object)this.state);
    }

    public boolean isTransferredOrTransferring() {
        return Yade.TransferEntryState.TRANSFERRED.equals((Object)this.state) || Yade.TransferEntryState.TRANSFERRING.equals((Object)this.state);
    }

    public boolean isSkipped() {
        return Yade.TransferEntryState.SKIPPED.equals((Object)this.state) || Yade.TransferEntryState.NOT_OVERWRITTEN.equals((Object)this.state);
    }

    public void resetSteady() {
        this.steady = null;
    }

    public void resetTarget() {
        this.target = null;
    }

    public boolean needsRename() {
        return this.finalFullPath != null && !this.finalFullPath.equalsIgnoreCase(this.getFullPath()) && !this.isSkipped();
    }

    public void setFinalFullPath(AYADEProviderDelegator delegator, String newName) {
        this.finalFullPath = delegator.appendPath(this.parentFullPath, newName);
    }

    public void setFinalFullPath(String path) {
        this.finalFullPath = path;
    }

    public String getFinalFullPath() {
        return this.finalFullPath == null ? this.getFullPath() : this.finalFullPath;
    }

    public String getFinalFullPathParent(AYADEProviderDelegator delegator) {
        return this.finalFullPath == null ? this.parentFullPath : delegator.getParentPath(this.finalFullPath);
    }

    public YADETargetProviderFile getTarget() {
        return this.target;
    }

    public void setTarget(YADETargetProviderFile val) {
        this.target = val;
    }

    public void setSubState(Yade.TransferEntryState val) {
        this.subState = val;
    }

    public Yade.TransferEntryState getSubState() {
        return this.subState;
    }

    public void setIntegrityHash(String val) {
        this.integrityHash = val;
    }

    public String getIntegrityHash() {
        return this.integrityHash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.state != null) {
            sb.append("state=").append(this.state.name().toLowerCase());
            sb.append(",");
        }
        if (this.subState != null) {
            sb.append("subState=").append(this.subState.name().toLowerCase());
            sb.append(",");
        }
        if (this.integrityHash != null) {
            sb.append("integrityHash=").append(this.integrityHash);
            sb.append(",");
        }
        sb.append(this.getFinalFullPath());
        if (this.target != null) {
            sb.append(", Target state=").append(this.target.getState().name().toLowerCase());
            if (this.target.getSubState() != null) {
                sb.append(",subState=").append(this.target.getSubState().name().toLowerCase());
            }
            if (this.target.getIntegrityHash() != null) {
                sb.append("integrityHash=").append(this.target.getIntegrityHash());
                sb.append(",");
            }
            sb.append(",").append(this.target.getFinalFullPath());
        }
        return sb.toString();
    }

    public class Steady {
        private long lastCheckedSize;
        private boolean steady;

        private Steady(long size) {
            this.lastCheckedSize = size;
        }

        public void checkIfSteady() {
            if (this.steady) {
                return;
            }
            if (this.lastCheckedSize == YADEProviderFile.this.getSize()) {
                this.steady = true;
            } else {
                this.lastCheckedSize = YADEProviderFile.this.getSize();
            }
        }

        public boolean isSteady() {
            return this.steady;
        }
    }
}

