/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.commons.arguments;

import com.sos.commons.util.arguments.base.ASOSArguments;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.util.arguments.base.SOSArgumentHelper;
import java.util.Properties;

public class YADENotificationMailServerArguments
extends ASOSArguments {
    private final Properties mailSettings;
    private SOSArgument<String> hostname = new SOSArgument("Hostname", false);
    private SOSArgument<Integer> port = new SOSArgument("Port", false, (Object)25);
    private SOSArgument<String> account = new SOSArgument("Account", false);
    private SOSArgument<String> password = new SOSArgument("Password", false, SOSArgument.DisplayMode.MASKED);
    private SOSArgument<String> queueDirectory = new SOSArgument("QueueDirectory", false);
    private SOSArgument<String> connectTimeout = new SOSArgument("ConnectTimeout", false, (Object)"30s");

    public YADENotificationMailServerArguments() {
        this.mailSettings = new Properties();
        this.applyPort(String.valueOf(this.port.getDefaultValue()));
        this.applyConnectTimeout((String)this.connectTimeout.getDefaultValue());
    }

    public boolean isEnabled() {
        return !this.hostname.isEmpty();
    }

    public Properties getMailSettings() {
        return this.mailSettings;
    }

    public void addMailSetting(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        this.mailSettings.put(name, value);
    }

    public void applyHostname(String val) {
        if (val == null) {
            return;
        }
        this.hostname.setValue((Object)val);
        this.mailSettings.put("mail.smtp.host", val);
    }

    public void applyPort(String val) {
        if (val == null) {
            return;
        }
        this.port.setValue((Object)Integer.parseInt(val));
        this.mailSettings.put("mail.smtp.port", val);
    }

    public void applyAccount(String val) {
        if (val == null) {
            return;
        }
        this.account.setValue((Object)val);
        this.mailSettings.put("mail.smtp.user", val);
    }

    public void applyPassword(String val) {
        if (val == null) {
            return;
        }
        this.password.setValue((Object)val);
        this.mailSettings.put("mail.smtp.password", val);
    }

    public void applyConnectTimeout(String val) {
        if (val == null) {
            return;
        }
        this.connectTimeout.setValue((Object)val);
        this.mailSettings.put("mail.smtp.connectiontimeout", String.valueOf(SOSArgumentHelper.asMillis(this.connectTimeout)));
    }

    public SOSArgument<String> getQueueDirectory() {
        return this.queueDirectory;
    }
}

