/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.commons.arguments;

import com.sos.commons.util.SOSString;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.util.arguments.base.SOSArgumentHelper;
import com.sos.yade.engine.commons.arguments.YADESourcePollingArguments;
import com.sos.yade.engine.commons.arguments.YADESourceTargetArguments;
import java.nio.file.Path;
import java.util.List;

public class YADESourceArguments
extends YADESourceTargetArguments {
    public static final String LABEL = "Source";
    private YADESourcePollingArguments polling;
    private SOSArgument<Boolean> errorOnNoFilesFound = new SOSArgument("ErrorOnNoFilesFound", false, (Object)true);
    private SOSArgument<String> excludedDirectories = new SOSArgument("ExcludedDirectories", false);
    private SOSArgument<Boolean> recursive = new SOSArgument("Recursive", false, (Object)false);
    private SOSArgument<List<String>> filePath = new SOSArgument("FilePath", false);
    private SOSArgument<Path> fileList = new SOSArgument("FileList", false);
    private SOSArgument<String> fileSpec = new SOSArgument("FileSpec", false, (Object)"^.*$");
    private SOSArgument<Integer> maxFiles = new SOSArgument("MaxFiles", false);
    private SOSArgument<Long> maxFileSize = new SOSArgument("MaxFileSize", false);
    private SOSArgument<Long> minFileSize = new SOSArgument("MinFileSize", false);
    private SOSArgument<String> checkSteadyStateInterval = new SOSArgument("CheckSteadyStateInterval", false);
    private SOSArgument<Integer> checkSteadyCount = new SOSArgument("CheckSteadyStateCount", false, (Object)10);
    private SOSArgument<ZeroByteTransfer> zeroByteTransfer = new SOSArgument("TransferZeroByteFiles", false, (Object)ZeroByteTransfer.TRUE);
    private SOSArgument<Boolean> checkIntegrityHash = new SOSArgument("CheckIntegrityHash", false, (Object)false);

    public YADESourceArguments() {
        this.getLabel().setValue((Object)LABEL);
    }

    public void applyFilePath(String val) {
        if (val != null) {
            this.resetSelection();
            this.setFilePath(val);
        }
    }

    public void applyFileList(Path val) {
        if (val != null) {
            this.resetSelection();
            this.fileList.setValue((Object)val);
        }
    }

    public void applyFileSpec(String val) {
        if (val != null) {
            this.resetSelection();
            this.fileSpec.setValue((Object)val);
        }
    }

    public boolean isSingleFilesSelection() {
        return this.isFilePathEnabled() || this.isFileListEnabled();
    }

    public boolean isFilePathEnabled() {
        return !this.filePath.isEmpty();
    }

    public boolean isFileListEnabled() {
        return this.fileList.getValue() != null;
    }

    public boolean isCheckSteadyStateEnabled() {
        return !this.checkSteadyStateInterval.isEmpty();
    }

    public boolean isPollingEnabled() {
        return this.polling != null && this.polling.getPollTimeout().getValue() != null;
    }

    public boolean isDirectivesEnabled() {
        return this.errorOnNoFilesFound.isDirty() || this.zeroByteTransfer.isDirty();
    }

    public YADESourcePollingArguments getPolling() {
        return this.polling;
    }

    public void setPolling(YADESourcePollingArguments val) {
        this.polling = val;
    }

    public SOSArgument<Boolean> getErrorOnNoFilesFound() {
        return this.errorOnNoFilesFound;
    }

    public SOSArgument<String> getExcludedDirectories() {
        return this.excludedDirectories;
    }

    public SOSArgument<List<String>> getFilePath() {
        return this.filePath;
    }

    public String getFilePathAsString() {
        return SOSArgumentHelper.getListStringArgumentValueAsString(this.filePath);
    }

    public void setFilePath(String val) {
        SOSArgumentHelper.setListStringArgumentValue(this.filePath, (String)val);
    }

    public SOSArgument<Path> getFileList() {
        return this.fileList;
    }

    public SOSArgument<String> getFileSpec() {
        return this.fileSpec;
    }

    public SOSArgument<String> getCheckSteadyStateInterval() {
        return this.checkSteadyStateInterval;
    }

    public SOSArgument<Integer> getCheckSteadyCount() {
        return this.checkSteadyCount;
    }

    public SOSArgument<ZeroByteTransfer> getZeroByteTransfer() {
        return this.zeroByteTransfer;
    }

    public void setZeroByteTransfer(String val) {
        if (SOSString.isEmpty((String)val)) {
            return;
        }
        this.zeroByteTransfer.setValue((Object)ZeroByteTransfer.valueOf(val.trim().toUpperCase()));
    }

    public SOSArgument<Integer> getMaxFiles() {
        return this.maxFiles;
    }

    public SOSArgument<Long> getMaxFileSize() {
        return this.maxFileSize;
    }

    public SOSArgument<Long> getMinFileSize() {
        return this.minFileSize;
    }

    public SOSArgument<Boolean> getRecursive() {
        return this.recursive;
    }

    public SOSArgument<Boolean> getCheckIntegrityHash() {
        return this.checkIntegrityHash;
    }

    private void resetSelection() {
        this.filePath.setValue(null);
        this.fileList.setValue(null);
        this.fileSpec.setValue(null);
    }

    public static enum ZeroByteTransfer {
        TRUE,
        FALSE,
        STRICT,
        RELAXED;

    }
}

