/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.commons.arguments.loaders.xml;

import com.sos.commons.exception.SOSMissingDataException;
import com.sos.commons.util.SOSComparisonOperator;
import com.sos.commons.util.SOSString;
import com.sos.commons.vfs.azure.commons.AzureBlobStorageProviderArguments;
import com.sos.commons.vfs.commons.AProviderArguments;
import com.sos.commons.vfs.ftp.commons.FTPProviderArguments;
import com.sos.commons.vfs.ftp.commons.FTPSProviderArguments;
import com.sos.commons.vfs.http.commons.HTTPProviderArguments;
import com.sos.commons.vfs.http.commons.HTTPSProviderArguments;
import com.sos.commons.vfs.local.commons.LocalProviderArguments;
import com.sos.commons.vfs.smb.commons.SMBProviderArguments;
import com.sos.commons.vfs.ssh.commons.SSHProviderArguments;
import com.sos.commons.vfs.webdav.commons.WebDAVProviderArguments;
import com.sos.commons.xml.SOSXML;
import com.sos.yade.commons.Yade;
import com.sos.yade.engine.commons.arguments.YADENotificationMailArguments;
import com.sos.yade.engine.commons.arguments.YADEProviderCommandArguments;
import com.sos.yade.engine.commons.arguments.YADESourcePollingArguments;
import com.sos.yade.engine.commons.arguments.YADESourceTargetArguments;
import com.sos.yade.engine.commons.arguments.loaders.xml.YADEXMLArgumentsLoader;
import com.sos.yade.engine.commons.arguments.loaders.xml.YADEXMLFragmentsCredentialStoreFragmentHelper;
import com.sos.yade.engine.commons.arguments.loaders.xml.YADEXMLFragmentsProtocolFragmentHelper;
import com.sos.yade.engine.commons.arguments.loaders.xml.YADEXMLGeneralHelper;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class YADEXMLProfileHelper {
    public static final String ELEMENT_NAME_NOTIFICATION_TRIGGERS = "NotificationTriggers";

    protected static void parse(YADEXMLArgumentsLoader argsLoader, Node profile) throws Exception {
        NodeList nl = profile.getChildNodes();
        block14: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "Operation": {
                    YADEXMLProfileHelper.parseOperation(argsLoader, n);
                    continue block14;
                }
                case "SystemPropertyFiles": {
                    YADEXMLGeneralHelper.parseSystemPropertyFiles(argsLoader, n);
                    continue block14;
                }
                case "NotificationTriggers": {
                    YADEXMLProfileHelper.parseNotificationTriggers(argsLoader, n, "Profile=" + (String)argsLoader.getArgs().getProfile().getValue());
                    continue block14;
                }
                case "Notifications": {
                    YADEXMLGeneralHelper.parseNotifications(argsLoader, n, "Profile=" + (String)argsLoader.getArgs().getProfile().getValue());
                    continue block14;
                }
            }
        }
    }

    private static void parseOperation(YADEXMLArgumentsLoader argsLoader, Node operation) throws Exception {
        String operationIdentifier;
        Node node = argsLoader.getXPath().selectNode(operation, "*[1]");
        if (node == null) {
            throw new SOSMissingDataException("Profiles/Profile profile_id=" + (String)argsLoader.getArgs().getProfile().getValue() + "/Operation/<Child Node>");
        }
        switch (operationIdentifier = node.getNodeName()) {
            case "Copy": {
                argsLoader.getArgs().getOperation().setValue((Object)Yade.TransferOperation.COPY);
                YADEXMLProfileHelper.parseOperationOnSourceTarget(argsLoader, node, operationIdentifier);
                break;
            }
            case "Move": {
                argsLoader.getArgs().getOperation().setValue((Object)Yade.TransferOperation.MOVE);
                YADEXMLProfileHelper.parseOperationOnSourceTarget(argsLoader, node, operationIdentifier);
                break;
            }
            case "Remove": {
                argsLoader.getArgs().getOperation().setValue((Object)Yade.TransferOperation.REMOVE);
                argsLoader.nullifyTargetArgs();
                YADEXMLProfileHelper.parseOperationOnSource(argsLoader, node, operationIdentifier);
                break;
            }
            case "GetList": {
                argsLoader.getArgs().getOperation().setValue((Object)Yade.TransferOperation.GETLIST);
                argsLoader.nullifyTargetArgs();
                YADEXMLProfileHelper.parseOperationOnSource(argsLoader, node, operationIdentifier);
                break;
            }
            default: {
                throw new Exception("[" + node.getNodeName() + "]Unknown Operation");
            }
        }
    }

    private static void parseNotificationTriggers(YADEXMLArgumentsLoader argsLoader, Node notificationTriggers, String parentInfo) throws Exception {
        argsLoader.initializeNotificationArgsIfNull();
        NodeList nl = notificationTriggers.getChildNodes();
        block10: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "OnSuccess": {
                    YADENotificationMailArguments trigger = new YADENotificationMailArguments();
                    trigger.applyDefaultIfNullQuietly();
                    YADEXMLProfileHelper.parseNotificationTrigger(argsLoader, n, parentInfo, trigger);
                    argsLoader.getNotificationArgs().setMailOnSuccess(trigger);
                    continue block10;
                }
                case "OnError": {
                    YADENotificationMailArguments trigger = new YADENotificationMailArguments();
                    trigger.applyDefaultIfNullQuietly();
                    YADEXMLProfileHelper.parseNotificationTrigger(argsLoader, n, parentInfo, trigger);
                    argsLoader.getNotificationArgs().setMailOnError(trigger);
                    continue block10;
                }
                case "OnEmptyFiles": {
                    YADENotificationMailArguments trigger = new YADENotificationMailArguments();
                    trigger.applyDefaultIfNullQuietly();
                    YADEXMLProfileHelper.parseNotificationTrigger(argsLoader, n, parentInfo, trigger);
                    argsLoader.getNotificationArgs().setMailOnEmptyFiles(trigger);
                }
            }
        }
    }

    private static void parseNotificationTrigger(YADEXMLArgumentsLoader argsLoader, Node notificationTrigger, String parentInfo, YADENotificationMailArguments mail) throws Exception {
        Node ref = SOSXML.getChildNode((Node)notificationTrigger, (String)"MailFragmentRef");
        if (ref == null) {
            return;
        }
        String exp = "Fragments/NotificationFragments/MailFragment[@name='" + SOSXML.getAttributeValue((Node)ref, (String)"ref") + "']";
        Node fragment = argsLoader.getXPath().selectNode(argsLoader.getRoot(), exp);
        if (fragment == null) {
            throw new SOSMissingDataException("[" + parentInfo + "][" + exp + "]referenced MailFragment not found");
        }
        NodeList nl = fragment.getChildNodes();
        int len = nl.getLength();
        if (len > 0) {
            block14: for (int i = 0; i < len; ++i) {
                Node n = nl.item(i);
                if (n.getNodeType() != 1) continue;
                switch (n.getNodeName()) {
                    case "Header": {
                        YADEXMLProfileHelper.parseMailFragmentHeader(argsLoader, n, mail);
                        continue block14;
                    }
                    case "Attachment": {
                        argsLoader.setListPathArgumentValue(mail.getAttachment(), n);
                        continue block14;
                    }
                    case "Body": {
                        argsLoader.setStringArgumentValue(mail.getBody(), n);
                        continue block14;
                    }
                    case "ContentType": {
                        argsLoader.setStringArgumentValue(mail.getContentType(), n);
                        continue block14;
                    }
                    case "Encoding": {
                        argsLoader.setStringArgumentValue(mail.getEncoding(), n);
                    }
                }
            }
        }
    }

    private static void parseMailFragmentHeader(YADEXMLArgumentsLoader argsLoader, Node header, YADENotificationMailArguments mail) {
        NodeList nl = header.getChildNodes();
        int len = nl.getLength();
        if (len > 0) {
            block14: for (int i = 0; i < len; ++i) {
                Node n = nl.item(i);
                if (n.getNodeType() != 1) continue;
                switch (n.getNodeName()) {
                    case "From": {
                        argsLoader.setStringArgumentValue(mail.getHeaderFrom(), n);
                        continue block14;
                    }
                    case "To": {
                        argsLoader.setListStringArgumentValue(mail.getHeaderTo(), n);
                        continue block14;
                    }
                    case "CC": {
                        argsLoader.setListStringArgumentValue(mail.getHeaderCC(), n);
                        continue block14;
                    }
                    case "BCC": {
                        argsLoader.setListStringArgumentValue(mail.getHeaderBCC(), n);
                        continue block14;
                    }
                    case "Subject": {
                        argsLoader.setStringArgumentValue(mail.getHeaderSubject(), n);
                    }
                }
            }
        }
    }

    private static void parseOperationOnSourceTarget(YADEXMLArgumentsLoader argsLoader, Node operation, String operationIdentifier) throws Exception {
        argsLoader.initializeTargetArgsIfNull();
        NodeList nl = operation.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            String nodeName = n.getNodeName();
            if (nodeName.equals(operationIdentifier + "Source")) {
                YADEXMLProfileHelper.parseSource(argsLoader, n, operationIdentifier);
                continue;
            }
            if (nodeName.equals(operationIdentifier + "Target")) {
                YADEXMLProfileHelper.parseTarget(argsLoader, n, operationIdentifier);
                continue;
            }
            if (!nodeName.equals("TransferOptions")) continue;
            YADEXMLProfileHelper.parseTransferOptions(argsLoader, n);
        }
    }

    private static void parseOperationOnSource(YADEXMLArgumentsLoader argsLoader, Node operation, String operationIdentifier) throws Exception {
        NodeList nl = operation.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || !n.getNodeName().equals(operationIdentifier + "Source")) continue;
            YADEXMLProfileHelper.parseSource(argsLoader, n, operationIdentifier);
        }
    }

    private static void parseSource(YADEXMLArgumentsLoader argsLoader, Node sourceOperation, String operationIdentifier) throws Exception {
        NodeList nl = sourceOperation.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            String nodeName = n.getNodeName();
            if (nodeName.equals(operationIdentifier + "SourceFragmentRef")) {
                YADEXMLProfileHelper.parseFragmentRef(argsLoader, n, true);
                continue;
            }
            if (!nodeName.equals("SourceFileOptions")) continue;
            YADEXMLProfileHelper.parseSourceOptions(argsLoader, n);
        }
    }

    private static void parseTarget(YADEXMLArgumentsLoader argsLoader, Node targetOperation, String operationIdentifier) throws Exception {
        NodeList nl = targetOperation.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            String nodeName = n.getNodeName();
            if (nodeName.equals(operationIdentifier + "TargetFragmentRef")) {
                YADEXMLProfileHelper.parseFragmentRef(argsLoader, n, false);
                continue;
            }
            if (nodeName.equals("Directory")) {
                argsLoader.setStringArgumentValue(argsLoader.getTargetArgs().getDirectory(), n);
                continue;
            }
            if (!nodeName.equals("TargetFileOptions")) continue;
            YADEXMLProfileHelper.parseTargetOptions(argsLoader, n);
        }
    }

    private static void parseTransferOptions(YADEXMLArgumentsLoader argsLoader, Node transferOptions) throws Exception {
        NodeList nl = transferOptions.getChildNodes();
        block10: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "BufferSize": {
                    argsLoader.setIntegerArgumentValue(argsLoader.getArgs().getBufferSize(), n);
                    continue block10;
                }
                case "Transactional": {
                    argsLoader.setBooleanArgumentValue(argsLoader.getArgs().getTransactional(), n);
                    continue block10;
                }
                case "RetryOnConnectionError": {
                    YADEXMLGeneralHelper.parseRetryOnConnectionError(argsLoader, n);
                }
            }
        }
    }

    private static void parseFragmentRef(YADEXMLArgumentsLoader argsLoader, Node ref, boolean isSource) throws Exception {
        YADESourceTargetArguments sourceTargetArgs = isSource ? argsLoader.getSourceArgs() : argsLoader.getTargetArgs();
        LocalProviderArguments providerArgs = null;
        Node refRef = argsLoader.getXPath().selectNode(ref, "*[1]");
        if (refRef == null) {
            throw new SOSMissingDataException("Profiles/Profile profile_id=" + (String)argsLoader.getArgs().getProfile().getValue() + "/../" + ref.getNodeName() + "/<Child Node>");
        }
        switch (refRef.getNodeName()) {
            case "LocalSource": {
                providerArgs = YADEXMLProfileHelper.parseFragmentRefLocal(argsLoader, refRef, isSource, sourceTargetArgs);
                break;
            }
            case "LocalTarget": {
                providerArgs = YADEXMLProfileHelper.parseFragmentRefLocal(argsLoader, refRef, isSource, sourceTargetArgs);
                break;
            }
            case "AzureBlobStorageFragmentRef": {
                providerArgs = YADEXMLProfileHelper.parseFragmentRefAzureBlobStorage(argsLoader, refRef, isSource, sourceTargetArgs);
                break;
            }
            case "SFTPFragmentRef": {
                providerArgs = YADEXMLProfileHelper.parseFragmentRefSFTP(argsLoader, refRef, isSource, sourceTargetArgs);
                break;
            }
            case "FTPFragmentRef": {
                providerArgs = YADEXMLProfileHelper.parseFragmentRefFTP(argsLoader, refRef, isSource, sourceTargetArgs);
                break;
            }
            case "FTPSFragmentRef": {
                providerArgs = YADEXMLProfileHelper.parseFragmentRefFTPS(argsLoader, refRef, isSource, sourceTargetArgs);
                break;
            }
            case "HTTPFragmentRef": {
                providerArgs = YADEXMLProfileHelper.parseFragmentRefHTTP(argsLoader, refRef, isSource, sourceTargetArgs);
                break;
            }
            case "HTTPSFragmentRef": {
                providerArgs = YADEXMLProfileHelper.parseFragmentRefHTTPS(argsLoader, refRef, isSource, sourceTargetArgs);
                break;
            }
            case "SMBFragmentRef": {
                providerArgs = YADEXMLProfileHelper.parseFragmentRefSMB(argsLoader, refRef, isSource, sourceTargetArgs);
                break;
            }
            case "WebDAVFragmentRef": {
                providerArgs = YADEXMLProfileHelper.parseFragmentRefWebDAV(argsLoader, refRef, isSource, sourceTargetArgs);
            }
        }
        if (isSource) {
            argsLoader.getSourceArgs().setProvider((AProviderArguments)providerArgs);
        } else {
            argsLoader.getTargetArgs().setProvider((AProviderArguments)providerArgs);
        }
    }

    private static LocalProviderArguments parseFragmentRefLocal(YADEXMLArgumentsLoader argsLoader, Node ref, boolean isSource, YADESourceTargetArguments sourceTargetArgs) throws Exception {
        LocalProviderArguments args = new LocalProviderArguments();
        args.applyDefaultIfNullQuietly();
        String label = SOSXML.getAttributeValue((Node)ref, (String)"label");
        if (!SOSString.isEmpty((String)label)) {
            if (isSource) {
                argsLoader.getSourceArgs().getLabel().setValue((Object)label);
            } else {
                argsLoader.getTargetArgs().getLabel().setValue((Object)label);
            }
        }
        NodeList nl = ref.getChildNodes();
        block14: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "LocalPreProcessing": {
                    YADEXMLProfileHelper.parsePreProcessing(argsLoader, sourceTargetArgs.getCommands(), n);
                    continue block14;
                }
                case "LocalPostProcessing": {
                    YADEXMLProfileHelper.parsePostProcessing(argsLoader, sourceTargetArgs.getCommands(), n);
                    continue block14;
                }
                case "ProcessingCommandDelimiter": {
                    argsLoader.setStringArgumentValue(sourceTargetArgs.getCommands().getCommandDelimiter(), n);
                    continue block14;
                }
                case "Rename": {
                    YADEXMLProfileHelper.parseFragmentRefRename(argsLoader, n, sourceTargetArgs);
                    continue block14;
                }
                case "CredentialStoreFragmentRef": {
                    YADEXMLFragmentsCredentialStoreFragmentHelper.parse(argsLoader, n, isSource, (AProviderArguments)args);
                }
            }
        }
        return args;
    }

    private static AzureBlobStorageProviderArguments parseFragmentRefAzureBlobStorage(YADEXMLArgumentsLoader argsLoader, Node ref, boolean isSource, YADESourceTargetArguments sourceTargetArgs) throws Exception {
        AzureBlobStorageProviderArguments args = YADEXMLFragmentsProtocolFragmentHelper.parseAzureBlobStorage(argsLoader, ref, isSource);
        NodeList nl = ref.getChildNodes();
        block8: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "Rename": {
                    YADEXMLProfileHelper.parseFragmentRefRename(argsLoader, n, sourceTargetArgs);
                    continue block8;
                }
                case "HTTPHeaders": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseHTTPHeaders(argsLoader, args, n);
                }
            }
        }
        return args;
    }

    private static FTPProviderArguments parseFragmentRefFTP(YADEXMLArgumentsLoader argsLoader, Node ref, boolean isSource, YADESourceTargetArguments sourceTargetArgs) throws Exception {
        FTPProviderArguments args = YADEXMLFragmentsProtocolFragmentHelper.parseFTP(argsLoader, ref, isSource);
        NodeList nl = ref.getChildNodes();
        block12: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "FTPPreProcessing": {
                    YADEXMLProfileHelper.parsePreProcessing(argsLoader, sourceTargetArgs.getCommands(), n);
                    continue block12;
                }
                case "FTPPostProcessing": {
                    YADEXMLProfileHelper.parsePostProcessing(argsLoader, sourceTargetArgs.getCommands(), n);
                    continue block12;
                }
                case "ProcessingCommandDelimiter": {
                    argsLoader.setStringArgumentValue(sourceTargetArgs.getCommands().getCommandDelimiter(), n);
                    continue block12;
                }
                case "Rename": {
                    YADEXMLProfileHelper.parseFragmentRefRename(argsLoader, n, sourceTargetArgs);
                }
            }
        }
        return args;
    }

    private static FTPSProviderArguments parseFragmentRefFTPS(YADEXMLArgumentsLoader argsLoader, Node ref, boolean isSource, YADESourceTargetArguments sourceTargetArgs) throws Exception {
        FTPSProviderArguments args = YADEXMLFragmentsProtocolFragmentHelper.parseFTPS(argsLoader, ref, isSource);
        NodeList nl = ref.getChildNodes();
        block12: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "FTPPreProcessing": {
                    YADEXMLProfileHelper.parsePreProcessing(argsLoader, sourceTargetArgs.getCommands(), n);
                    continue block12;
                }
                case "FTPPostProcessing": {
                    YADEXMLProfileHelper.parsePostProcessing(argsLoader, sourceTargetArgs.getCommands(), n);
                    continue block12;
                }
                case "ProcessingCommandDelimiter": {
                    argsLoader.setStringArgumentValue(sourceTargetArgs.getCommands().getCommandDelimiter(), n);
                    continue block12;
                }
                case "Rename": {
                    YADEXMLProfileHelper.parseFragmentRefRename(argsLoader, n, sourceTargetArgs);
                }
            }
        }
        return args;
    }

    private static HTTPProviderArguments parseFragmentRefHTTP(YADEXMLArgumentsLoader argsLoader, Node ref, boolean isSource, YADESourceTargetArguments sourceTargetArgs) throws Exception {
        HTTPProviderArguments args = YADEXMLFragmentsProtocolFragmentHelper.parseHTTP(argsLoader, ref, isSource);
        NodeList nl = ref.getChildNodes();
        block8: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "Rename": {
                    YADEXMLProfileHelper.parseFragmentRefRename(argsLoader, n, sourceTargetArgs);
                    continue block8;
                }
                case "HTTPHeaders": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseHTTPHeaders(argsLoader, args, n);
                }
            }
        }
        return args;
    }

    private static HTTPSProviderArguments parseFragmentRefHTTPS(YADEXMLArgumentsLoader argsLoader, Node ref, boolean isSource, YADESourceTargetArguments sourceTargetArgs) throws Exception {
        HTTPSProviderArguments args = YADEXMLFragmentsProtocolFragmentHelper.parseHTTPS(argsLoader, ref, isSource);
        NodeList nl = ref.getChildNodes();
        block8: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "Rename": {
                    YADEXMLProfileHelper.parseFragmentRefRename(argsLoader, n, sourceTargetArgs);
                    continue block8;
                }
                case "HTTPHeaders": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseHTTPHeaders(argsLoader, (HTTPProviderArguments)args, n);
                }
            }
        }
        return args;
    }

    private static SSHProviderArguments parseFragmentRefSFTP(YADEXMLArgumentsLoader argsLoader, Node ref, boolean isSource, YADESourceTargetArguments sourceTargetArgs) throws Exception {
        SSHProviderArguments args = YADEXMLFragmentsProtocolFragmentHelper.parseSFTP(argsLoader, ref, isSource);
        NodeList nl = ref.getChildNodes();
        block14: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "SFTPPreProcessing": {
                    YADEXMLProfileHelper.parsePreProcessing(argsLoader, sourceTargetArgs.getCommands(), n);
                    continue block14;
                }
                case "SFTPPostProcessing": {
                    YADEXMLProfileHelper.parsePostProcessing(argsLoader, sourceTargetArgs.getCommands(), n);
                    continue block14;
                }
                case "ProcessingCommandDelimiter": {
                    argsLoader.setStringArgumentValue(sourceTargetArgs.getCommands().getCommandDelimiter(), n);
                    continue block14;
                }
                case "Rename": {
                    YADEXMLProfileHelper.parseFragmentRefRename(argsLoader, n, sourceTargetArgs);
                    continue block14;
                }
                case "ZlibCompression": {
                    args.getUseZlibCompression().setValue((Object)true);
                }
            }
        }
        return args;
    }

    private static SMBProviderArguments parseFragmentRefSMB(YADEXMLArgumentsLoader argsLoader, Node ref, boolean isSource, YADESourceTargetArguments sourceTargetArgs) throws Exception {
        SMBProviderArguments args = YADEXMLFragmentsProtocolFragmentHelper.parseSMB(argsLoader, ref, isSource);
        NodeList nl = ref.getChildNodes();
        block12: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "SMBPreProcessing": {
                    YADEXMLProfileHelper.parsePreProcessing(argsLoader, sourceTargetArgs.getCommands(), n);
                    continue block12;
                }
                case "SMBPostProcessing": {
                    YADEXMLProfileHelper.parsePostProcessing(argsLoader, sourceTargetArgs.getCommands(), n);
                    continue block12;
                }
                case "ProcessingCommandDelimiter": {
                    argsLoader.setStringArgumentValue(sourceTargetArgs.getCommands().getCommandDelimiter(), n);
                    continue block12;
                }
                case "Rename": {
                    YADEXMLProfileHelper.parseFragmentRefRename(argsLoader, n, sourceTargetArgs);
                }
            }
        }
        return args;
    }

    private static WebDAVProviderArguments parseFragmentRefWebDAV(YADEXMLArgumentsLoader argsLoader, Node ref, boolean isSource, YADESourceTargetArguments sourceTargetArgs) throws Exception {
        WebDAVProviderArguments args = YADEXMLFragmentsProtocolFragmentHelper.parseWebDAV(argsLoader, ref, isSource);
        NodeList nl = ref.getChildNodes();
        block10: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "Rename": {
                    YADEXMLProfileHelper.parseFragmentRefRename(argsLoader, n, sourceTargetArgs);
                    continue block10;
                }
                case "HTTPHeaders": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseHTTPHeaders(argsLoader, (HTTPProviderArguments)args, n);
                }
                case "WebDAVPostProcessing": {
                    YADEXMLProfileHelper.parsePostProcessing(argsLoader, sourceTargetArgs.getCommands(), n);
                }
            }
        }
        return args;
    }

    private static void parseSourceOptions(YADEXMLArgumentsLoader argsLoader, Node sourceFileOptions) throws Exception {
        NodeList nl = sourceFileOptions.getChildNodes();
        block18: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "Selection": {
                    YADEXMLProfileHelper.parseSourceOptionSelection(argsLoader, n);
                    continue block18;
                }
                case "CheckSteadyState": {
                    YADEXMLProfileHelper.parseSourceOptionCheckSteadyState(argsLoader, n);
                    continue block18;
                }
                case "Directives": {
                    YADEXMLProfileHelper.parseSourceOptionDirectives(argsLoader, n);
                    continue block18;
                }
                case "Polling": {
                    YADEXMLProfileHelper.parseSourceOptionPolling(argsLoader, n);
                    continue block18;
                }
                case "ResultSet": {
                    YADEXMLProfileHelper.parseSourceOptionResultSet(argsLoader, n);
                    continue block18;
                }
                case "MaxFiles": {
                    argsLoader.setIntegerArgumentValue(argsLoader.getSourceArgs().getMaxFiles(), n);
                    continue block18;
                }
                case "CheckIntegrityHash": {
                    YADEXMLProfileHelper.parseSourceOptionCheckIntegrityHash(argsLoader, n);
                }
            }
        }
    }

    private static void parseSourceOptionSelection(YADEXMLArgumentsLoader argsLoader, Node selection) throws Exception {
        NodeList nl = selection.getChildNodes();
        block10: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "FilePathSelection": {
                    YADEXMLProfileHelper.parseSourceOptionSelectionFilePath(argsLoader, n);
                    continue block10;
                }
                case "FileSpecSelection": {
                    YADEXMLProfileHelper.parseSourceOptionSelectionFileSpec(argsLoader, n);
                    continue block10;
                }
                case "FileListSelection": {
                    YADEXMLProfileHelper.parseSourceOptionSelectionFileList(argsLoader, n);
                }
            }
        }
    }

    private static void parseSourceOptionSelectionFilePath(YADEXMLArgumentsLoader argsLoader, Node selection) throws Exception {
        NodeList nl = selection.getChildNodes();
        block10: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "FilePath": {
                    argsLoader.getSourceArgs().setFilePath(argsLoader.getValue(n));
                    continue block10;
                }
                case "Directory": {
                    argsLoader.setStringArgumentValue(argsLoader.getSourceArgs().getDirectory(), n);
                    continue block10;
                }
                case "Recursive": {
                    argsLoader.setBooleanArgumentValue(argsLoader.getSourceArgs().getRecursive(), n);
                }
            }
        }
    }

    private static void parseSourceOptionSelectionFileSpec(YADEXMLArgumentsLoader argsLoader, Node selection) throws Exception {
        NodeList nl = selection.getChildNodes();
        block12: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "FileSpec": {
                    argsLoader.setStringArgumentValue(argsLoader.getSourceArgs().getFileSpec(), n);
                    continue block12;
                }
                case "Directory": {
                    argsLoader.setStringArgumentValue(argsLoader.getSourceArgs().getDirectory(), n);
                    continue block12;
                }
                case "ExcludedDirectories": {
                    argsLoader.setStringArgumentValue(argsLoader.getSourceArgs().getExcludedDirectories(), n);
                    continue block12;
                }
                case "Recursive": {
                    argsLoader.setBooleanArgumentValue(argsLoader.getSourceArgs().getRecursive(), n);
                }
            }
        }
    }

    private static void parseSourceOptionSelectionFileList(YADEXMLArgumentsLoader argsLoader, Node selection) throws Exception {
        NodeList nl = selection.getChildNodes();
        block10: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "FileList": {
                    argsLoader.setPathArgumentValue(argsLoader.getSourceArgs().getFileList(), n);
                    continue block10;
                }
                case "Directory": {
                    argsLoader.setStringArgumentValue(argsLoader.getSourceArgs().getDirectory(), n);
                    continue block10;
                }
                case "Recursive": {
                    argsLoader.setBooleanArgumentValue(argsLoader.getSourceArgs().getRecursive(), n);
                }
            }
        }
    }

    private static void parseSourceOptionCheckSteadyState(YADEXMLArgumentsLoader argsLoader, Node steadyState) throws Exception {
        NodeList nl = steadyState.getChildNodes();
        block9: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "CheckSteadyStateInterval": {
                    argsLoader.setStringArgumentValue(argsLoader.getSourceArgs().getCheckSteadyStateInterval(), n);
                    continue block9;
                }
                case "CheckSteadyStateCount": {
                    argsLoader.setIntegerArgumentValue(argsLoader.getSourceArgs().getCheckSteadyCount(), n);
                    continue block9;
                }
            }
        }
    }

    private static void parseSourceOptionDirectives(YADEXMLArgumentsLoader argsLoader, Node directives) throws Exception {
        NodeList nl = directives.getChildNodes();
        block8: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "DisableErrorOnNoFilesFound": {
                    argsLoader.setOppositeBooleanArgumentValue(argsLoader.getSourceArgs().getErrorOnNoFilesFound(), n);
                    continue block8;
                }
                case "TransferZeroByteFiles": {
                    argsLoader.getSourceArgs().setZeroByteTransfer(argsLoader.getValue(n));
                }
            }
        }
    }

    private static void parseSourceOptionPolling(YADEXMLArgumentsLoader argsLoader, Node polling) throws Exception {
        NodeList nl = polling.getChildNodes();
        int len = nl.getLength();
        if (len > 0) {
            YADESourcePollingArguments pollingArgs = new YADESourcePollingArguments();
            pollingArgs.applyDefaultIfNullQuietly();
            block20: for (int i = 0; i < len; ++i) {
                Node n = nl.item(i);
                if (n.getNodeType() != 1) continue;
                switch (n.getNodeName()) {
                    case "PollInterval": {
                        argsLoader.setStringArgumentValue(pollingArgs.getPollInterval(), n);
                        continue block20;
                    }
                    case "PollTimeout": {
                        argsLoader.setIntegerArgumentValue(pollingArgs.getPollTimeout(), n);
                        continue block20;
                    }
                    case "MinFiles": {
                        argsLoader.setIntegerArgumentValue(pollingArgs.getPollMinFiles(), n);
                        continue block20;
                    }
                    case "WaitForSourceFolder": {
                        argsLoader.setBooleanArgumentValue(pollingArgs.getWaitingForLateComers(), n);
                        continue block20;
                    }
                    case "PollErrorState": {
                        continue block20;
                    }
                    case "PollingServer": {
                        argsLoader.setBooleanArgumentValue(pollingArgs.getPollingServer(), n);
                        continue block20;
                    }
                    case "PollingServerDuration": {
                        argsLoader.setStringArgumentValue(pollingArgs.getPollingServerDuration(), n);
                        continue block20;
                    }
                    case "PollForever": {
                        argsLoader.setBooleanArgumentValue(pollingArgs.getPollingServerPollForever(), n);
                    }
                }
            }
            argsLoader.getSourceArgs().setPolling(pollingArgs);
        }
    }

    private static void parseSourceOptionResultSet(YADEXMLArgumentsLoader argsLoader, Node resultSet) throws Exception {
        NodeList nl = resultSet.getChildNodes();
        int len = nl.getLength();
        if (len > 0) {
            block9: for (int i = 0; i < len; ++i) {
                Node n = nl.item(i);
                if (n.getNodeType() != 1) continue;
                switch (n.getNodeName()) {
                    case "ResultSetFile": {
                        argsLoader.setPathArgumentValue(argsLoader.getClientArgs().getResultSetFile(), n);
                        continue block9;
                    }
                    case "CheckResultSetCount": {
                        YADEXMLProfileHelper.parseSourceOptionResultSetCheckCount(argsLoader, n);
                        continue block9;
                    }
                }
            }
        }
    }

    private static void parseSourceOptionResultSetCheckCount(YADEXMLArgumentsLoader argsLoader, Node resultSetCheckCount) throws Exception {
        NodeList nl = resultSetCheckCount.getChildNodes();
        int len = nl.getLength();
        if (len > 0) {
            block8: for (int i = 0; i < len; ++i) {
                Node n = nl.item(i);
                if (n.getNodeType() != 1) continue;
                switch (n.getNodeName()) {
                    case "ExpectedResultSetCount": {
                        argsLoader.setIntegerArgumentValue(argsLoader.getClientArgs().getExpectedResultSetCount(), n);
                        continue block8;
                    }
                    case "RaiseErrorIfResultSetIs": {
                        SOSComparisonOperator comparisonOperator = SOSComparisonOperator.fromString((String)argsLoader.getValue(n));
                        if (comparisonOperator == null) continue block8;
                        argsLoader.getClientArgs().getRaiseErrorIfResultSetIs().setValue((Object)comparisonOperator);
                    }
                }
            }
        }
    }

    private static void parseSourceOptionCheckIntegrityHash(YADEXMLArgumentsLoader argsLoader, Node checkIntegrityHash) throws Exception {
        argsLoader.getSourceArgs().getCheckIntegrityHash().setValue((Object)true);
        NodeList nl = checkIntegrityHash.getChildNodes();
        int len = nl.getLength();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                Node n = nl.item(i);
                if (n.getNodeType() != 1) continue;
                switch (n.getNodeName()) {
                    case "HashAlgorithm": {
                        argsLoader.setStringArgumentValue(argsLoader.getSourceArgs().getIntegrityHashAlgorithm(), n);
                    }
                }
            }
        }
    }

    private static void parseTargetOptions(YADEXMLArgumentsLoader argsLoader, Node targetFileOptions) throws Exception {
        NodeList nl = targetFileOptions.getChildNodes();
        block22: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "AppendFiles": {
                    argsLoader.setBooleanArgumentValue(argsLoader.getTargetArgs().getAppendFiles(), n);
                    continue block22;
                }
                case "Atomicity": {
                    YADEXMLProfileHelper.parseTargetOptionAtomicity(argsLoader, n);
                    continue block22;
                }
                case "CheckSize": {
                    argsLoader.setBooleanArgumentValue(argsLoader.getTargetArgs().getCheckSize(), n);
                    continue block22;
                }
                case "CumulateFiles": {
                    YADEXMLProfileHelper.parseTargetOptionCumulateFiles(argsLoader, n);
                    continue block22;
                }
                case "CompressFiles": {
                    YADEXMLProfileHelper.parseTargetOptionCompressFiles(argsLoader, n);
                    continue block22;
                }
                case "CreateIntegrityHashFile": {
                    YADEXMLProfileHelper.parseTargetOptionCreateIntegrityHashFile(argsLoader, n);
                    continue block22;
                }
                case "KeepModificationDate": {
                    argsLoader.setBooleanArgumentValue(argsLoader.getTargetArgs().getKeepModificationDate(), n);
                    continue block22;
                }
                case "DisableMakeDirectories": {
                    argsLoader.setOppositeBooleanArgumentValue(argsLoader.getTargetArgs().getCreateDirectories(), n);
                    continue block22;
                }
                case "DisableOverwriteFiles": {
                    argsLoader.setOppositeBooleanArgumentValue(argsLoader.getTargetArgs().getOverwriteFiles(), n);
                }
            }
        }
    }

    private static void parseTargetOptionAtomicity(YADEXMLArgumentsLoader argsLoader, Node atomicity) throws Exception {
        NodeList nl = atomicity.getChildNodes();
        block8: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "AtomicPrefix": {
                    argsLoader.setStringArgumentValue(argsLoader.getTargetArgs().getAtomicPrefix(), n);
                    continue block8;
                }
                case "AtomicSuffix": {
                    argsLoader.setStringArgumentValue(argsLoader.getTargetArgs().getAtomicSuffix(), n);
                }
            }
        }
    }

    private static void parseTargetOptionCumulateFiles(YADEXMLArgumentsLoader argsLoader, Node cumulateFiles) throws Exception {
        NodeList nl = cumulateFiles.getChildNodes();
        block10: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "CumulativeFileSeparator": {
                    argsLoader.setStringArgumentValue(argsLoader.getTargetArgs().getCumulativeFileSeparator(), n);
                    continue block10;
                }
                case "CumulativeFilename": {
                    argsLoader.setStringArgumentValue(argsLoader.getTargetArgs().getCumulativeFileName(), n);
                    continue block10;
                }
                case "CumulativeFileDelete": {
                    argsLoader.setBooleanArgumentValue(argsLoader.getTargetArgs().getCumulativeFileDelete(), n);
                }
            }
        }
    }

    private static void parseTargetOptionCompressFiles(YADEXMLArgumentsLoader argsLoader, Node compressFiles) throws Exception {
        NodeList nl = compressFiles.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "CompressedFileExtension": {
                    argsLoader.setStringArgumentValue(argsLoader.getTargetArgs().getCompressedFileExtension(), n);
                }
            }
        }
    }

    private static void parseTargetOptionCreateIntegrityHashFile(YADEXMLArgumentsLoader argsLoader, Node createIntegrityHashFile) throws Exception {
        argsLoader.getTargetArgs().getCreateIntegrityHashFile().setValue((Object)true);
        NodeList nl = createIntegrityHashFile.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "HashAlgorithm": {
                    argsLoader.setStringArgumentValue(argsLoader.getTargetArgs().getIntegrityHashAlgorithm(), n);
                }
            }
        }
    }

    private static void parseFragmentRefRename(YADEXMLArgumentsLoader argsLoader, Node rename, YADESourceTargetArguments sourceTargetArgs) throws Exception {
        NodeList nl = rename.getChildNodes();
        block8: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "ReplaceWhat": {
                    argsLoader.setStringArgumentValue(sourceTargetArgs.getReplacing(), n);
                    continue block8;
                }
                case "ReplaceWith": {
                    argsLoader.setStringArgumentValue(sourceTargetArgs.getReplacement(), n);
                }
            }
        }
    }

    public static void parsePreProcessing(YADEXMLArgumentsLoader argsLoader, YADEProviderCommandArguments args, Node preProcessing) throws Exception {
        NodeList nl = preProcessing.getChildNodes();
        block8: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "CommandBeforeFile": {
                    String attrVal = SOSXML.getAttributeValue((Node)n, (String)"enable_for_skipped_transfer");
                    if (!SOSString.isEmpty((String)attrVal)) {
                        args.getCommandsBeforeFileEnableForSkipped().setValue((Object)Boolean.parseBoolean(attrVal));
                    }
                    args.setCommandsBeforeFile(argsLoader.getValue(n));
                    continue block8;
                }
                case "CommandBeforeOperation": {
                    args.setCommandsBeforeOperation(argsLoader.getValue(n));
                }
            }
        }
    }

    public static void parsePostProcessing(YADEXMLArgumentsLoader argsLoader, YADEProviderCommandArguments args, Node postProcessing) throws Exception {
        NodeList nl = postProcessing.getChildNodes();
        block14: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "CommandAfterFile": {
                    String attrVal = SOSXML.getAttributeValue((Node)n, (String)"disable_for_skipped_transfer");
                    if (!SOSString.isEmpty((String)attrVal)) {
                        args.getCommandsAfterFileDisableForSkipped().setValue((Object)Boolean.parseBoolean(attrVal));
                    }
                    args.setCommandsAfterFile(argsLoader.getValue(n));
                    continue block14;
                }
                case "CommandAfterOperationOnSuccess": {
                    args.setCommandsAfterOperationOnSuccess(argsLoader.getValue(n));
                    continue block14;
                }
                case "CommandAfterOperationOnError": {
                    args.setCommandsAfterOperationOnError(argsLoader.getValue(n));
                    continue block14;
                }
                case "CommandAfterOperationFinal": {
                    args.setCommandsAfterOperationFinal(argsLoader.getValue(n));
                    continue block14;
                }
                case "CommandBeforeRename": {
                    args.setCommandsBeforeRename(argsLoader.getValue(n));
                }
            }
        }
    }
}

