/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.commons.delegators;

import com.sos.commons.util.SOSPathUtils;
import com.sos.commons.util.SOSShell;
import com.sos.commons.util.SOSString;
import com.sos.commons.vfs.commons.AProvider;
import com.sos.commons.vfs.commons.AProviderArguments;
import com.sos.yade.engine.commons.arguments.YADESourceTargetArguments;
import com.sos.yade.engine.commons.delegators.IYADEProviderDelegator;

public abstract class AYADEProviderDelegator
implements IYADEProviderDelegator {
    private final AProvider<?> provider;
    private final YADESourceTargetArguments args;
    private final String label;
    private final String directory;
    private final String directoryWithTrailingPathSeparator;
    private final boolean isHTTP;
    private final boolean isAzure;
    private final boolean isWindows;

    public AYADEProviderDelegator(AProvider<?> provider, YADESourceTargetArguments args) {
        this.provider = provider;
        this.args = args;
        this.label = (String)args.getLabel().getValue();
        this.isHTTP = this.isHTTPProvider();
        this.isAzure = this.isAzureProvider();
        this.isWindows = this.isWindowsProvider();
        this.directory = this.getDirectoryPath((String)args.getDirectory().getValue());
        this.directoryWithTrailingPathSeparator = this.getDirectoryPathWithTrailingPathSeparator(this.directory);
    }

    @Override
    public AProvider<?> getProvider() {
        return this.provider;
    }

    @Override
    public YADESourceTargetArguments getArgs() {
        return this.args;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getDirectory() {
        return this.directory;
    }

    @Override
    public String getDirectoryWithTrailingPathSeparator() {
        return this.directoryWithTrailingPathSeparator;
    }

    public String appendPath(String parent, String file) {
        return SOSPathUtils.appendPath((String)parent, (String)file, (String)this.provider.getPathSeparator());
    }

    public String getParentPath(String path) {
        return SOSPathUtils.getParentPath((String)path, (String)this.provider.getPathSeparator());
    }

    public boolean containsParentPath(String path) {
        return path.contains(this.provider.getPathSeparator());
    }

    public boolean isHTTP() {
        return this.isHTTP;
    }

    public boolean isAzure() {
        return this.isAzure;
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    public boolean isJumpHost() {
        return "Jump".equals(this.label);
    }

    private boolean isHTTPProvider() {
        switch ((AProviderArguments.Protocol)this.getArgs().getProvider().getProtocol().getValue()) {
            case AZURE_BLOB_STORAGE: 
            case HTTP: 
            case HTTPS: 
            case WEBDAV: 
            case WEBDAVS: {
                return true;
            }
        }
        return false;
    }

    private boolean isAzureProvider() {
        return AProviderArguments.Protocol.AZURE_BLOB_STORAGE.equals(this.getArgs().getProvider().getProtocol().getValue());
    }

    private boolean isWindowsProvider() {
        switch ((AProviderArguments.Protocol)this.getArgs().getProvider().getProtocol().getValue()) {
            case LOCAL: {
                return SOSShell.IS_WINDOWS;
            }
        }
        return false;
    }

    private String getDirectoryPath(String path) {
        if (SOSString.isEmpty((String)path)) {
            return null;
        }
        String dir = path;
        if (!this.isJumpHost()) {
            dir = this.provider.normalizePath(dir);
        }
        return SOSPathUtils.isUnixStylePathSeparator((String)this.getProvider().getPathSeparator()) ? SOSPathUtils.getUnixStyleDirectoryWithoutTrailingSeparator((String)dir) : SOSPathUtils.getWindowsStyleDirectoryWithoutTrailingSeparator((String)dir);
    }

    private String getDirectoryPathWithTrailingPathSeparator(String path) {
        if (SOSString.isEmpty((String)path)) {
            return null;
        }
        return SOSPathUtils.isUnixStylePathSeparator((String)this.getProvider().getPathSeparator()) ? SOSPathUtils.getUnixStyleDirectoryWithTrailingSeparator((String)path) : SOSPathUtils.getWindowsStyleDirectoryWithTrailingSeparator((String)path);
    }
}

