/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.commons.helpers;

import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.yade.commons.Yade;
import com.sos.yade.engine.commons.arguments.YADEArguments;
import com.sos.yade.engine.commons.arguments.YADEClientArguments;
import com.sos.yade.engine.commons.arguments.YADESourceArguments;
import com.sos.yade.engine.commons.arguments.YADETargetArguments;
import com.sos.yade.engine.commons.arguments.loaders.AYADEArgumentsLoader;
import com.sos.yade.engine.commons.helpers.YADEArgumentsHelper;
import com.sos.yade.engine.exceptions.YADEEngineInitializationException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class YADEArgumentsChecker {
    public static void validateOrExit(ISOSLogger logger, AYADEArgumentsLoader argsLoader) throws YADEEngineInitializationException {
        boolean needTargetProvider = YADEArgumentsChecker.checkCommonArguments(argsLoader.getArgs(), argsLoader.getClientArgs());
        YADEArgumentsChecker.checkClientArguments(argsLoader.getArgs(), argsLoader.getClientArgs(), needTargetProvider);
        YADEArgumentsChecker.checkSourceArguments(argsLoader.getSourceArgs());
        YADEArgumentsChecker.checkTargetArguments(argsLoader.getArgs(), argsLoader.getTargetArgs(), needTargetProvider);
        YADEArgumentsChecker.checkSourceTargetArguments(argsLoader.getArgs(), argsLoader.getSourceArgs(), argsLoader.getTargetArgs(), needTargetProvider);
        YADEArgumentsChecker.adjustSourceArguments(logger, argsLoader.getSourceArgs());
        YADEArgumentsChecker.adjustTargetArguments(logger, argsLoader.getSourceArgs(), argsLoader.getTargetArgs(), needTargetProvider);
    }

    private static boolean checkCommonArguments(YADEArguments args, YADEClientArguments clientArgs) throws YADEEngineInitializationException {
        if (args == null) {
            throw new YADEEngineInitializationException("Missing YADEArguments");
        }
        if (args.getOperation().getValue() == null) {
            throw new YADEEngineInitializationException("Missing \"" + args.getOperation().getName() + "\" argument");
        }
        return YADEArgumentsHelper.needTargetProvider(args);
    }

    private static void checkClientArguments(YADEArguments args, YADEClientArguments clientArgs, boolean needTargetProvider) throws YADEEngineInitializationException {
        if (!needTargetProvider && Yade.TransferOperation.GETLIST.equals(args.getOperation().getValue()) && (clientArgs == null || clientArgs.getResultSetFile().isEmpty())) {
            throw new YADEEngineInitializationException("[Client][" + Yade.TransferOperation.GETLIST + "]Missing \"SourceFileOptions/ResultSet/" + clientArgs.getResultSetFile().getName() + "\" argument");
        }
    }

    private static void checkSourceArguments(YADESourceArguments sourceArgs) throws YADEEngineInitializationException {
        if (sourceArgs == null) {
            throw new YADEEngineInitializationException("Missing Source Arguments");
        }
        if (!sourceArgs.isSingleFilesSelection() && sourceArgs.getDirectory().isEmpty()) {
            throw new YADEEngineInitializationException(String.format("[%s]The \"%s\" argument is missing but is required if %s is set", "Source", sourceArgs.getDirectory().getName(), YADEArgumentsHelper.toString(sourceArgs.getFileSpec())));
        }
        if (sourceArgs.isPollingEnabled() && ((Boolean)sourceArgs.getPolling().getPollingWait4SourceFolder().getValue()).booleanValue() && sourceArgs.getDirectory() == null) {
            throw new YADEEngineInitializationException("[Source]" + sourceArgs.getPolling().getPollingWait4SourceFolder().getName() + "=true, but \"" + sourceArgs.getDirectory().getName() + "\" is not set");
        }
    }

    private static void checkTargetArguments(YADEArguments args, YADETargetArguments targetArgs, boolean needTargetProvider) throws YADEEngineInitializationException {
        if (needTargetProvider && targetArgs == null) {
            throw new YADEEngineInitializationException("Missing Target Arguments");
        }
    }

    private static void checkSourceTargetArguments(YADEArguments args, YADESourceArguments sourceArgs, YADETargetArguments targetArgs, boolean needTargetProvider) throws YADEEngineInitializationException {
        String targetAlg;
        String sourceAlg = sourceArgs.getCheckIntegrityHash().isTrue() ? (String)sourceArgs.getIntegrityHashAlgorithm().getValue() : null;
        String string = targetAlg = needTargetProvider && targetArgs.getCreateIntegrityHashFile().isTrue() ? (String)targetArgs.getIntegrityHashAlgorithm().getValue() : null;
        if (sourceAlg != null || targetAlg != null) {
            try {
                if (sourceAlg != null && targetAlg != null) {
                    if (sourceAlg.equals(targetAlg)) {
                        MessageDigest.getInstance(sourceAlg);
                    } else {
                        MessageDigest.getInstance(sourceAlg);
                        MessageDigest.getInstance(targetAlg);
                    }
                } else if (sourceAlg != null) {
                    MessageDigest.getInstance(sourceAlg);
                } else if (targetAlg != null) {
                    MessageDigest.getInstance(targetAlg);
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw new YADEEngineInitializationException(e);
            }
        }
    }

    private static void adjustSourceArguments(ISOSLogger logger, YADESourceArguments args) {
        if (YADESourceArguments.ZeroByteTransfer.RELAXED.equals(args.getZeroByteTransfer().getValue()) && (args.getMinFileSize().getValue() == null || (Long)args.getMinFileSize().getValue() <= 0L)) {
            logger.info("[%s][%s=1]ZeroByteTransfer.RELAXED is active, setting %s=1", new Object[]{"Source", args.getMinFileSize().getName(), args.getMinFileSize().getName()});
            args.getMinFileSize().setValue((Object)1L);
        }
    }

    private static void adjustTargetArguments(ISOSLogger logger, YADESourceArguments sourceArgs, YADETargetArguments targetArgs, boolean needTargetProvider) {
        if (!needTargetProvider) {
            if (targetArgs != null) {
                logger.info((Object)"Target arguments are ignored");
            }
            targetArgs = null;
            return;
        }
        if (!sourceArgs.isSingleFilesSelection() && targetArgs.getDirectory().isEmpty()) {
            logger.info("[%s][configured \"%s\" is missing, using '.' as the default]%s=.", new Object[]{"Target", targetArgs.getDirectory().getName(), targetArgs.getDirectory().getName()});
            targetArgs.getDirectory().setValue((Object)".");
        }
    }
}

