/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.commons.helpers;

import com.sos.commons.exception.SOSInvalidDataException;
import com.sos.commons.util.SOSComparisonOperator;
import com.sos.commons.util.arguments.base.ASOSArguments;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.util.arguments.base.SOSArgumentHelper;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.yade.commons.Yade;
import com.sos.yade.engine.commons.arguments.YADEArguments;
import com.sos.yade.engine.exceptions.YADEEngineInitializationException;
import java.util.List;

public class YADEArgumentsHelper {
    public static boolean needTargetProvider(YADEArguments args) throws YADEEngineInitializationException {
        switch ((Yade.TransferOperation)args.getOperation().getValue()) {
            case GETLIST: 
            case REMOVE: {
                return false;
            }
            case RENAME: 
            case UNKNOWN: {
                throw new YADEEngineInitializationException((Throwable)new SOSInvalidDataException(args.getOperation().getName() + "=" + args.getOperation().getValue()));
            }
        }
        return true;
    }

    public static String toString(String name, String value) {
        return name + "=" + (value == null ? "" : value);
    }

    public static String toString(SOSArgument<?> arg) {
        return YADEArgumentsHelper.toString(arg.getName(), arg);
    }

    public static String toStringFromListString(SOSArgument<List<String>> arg) {
        return YADEArgumentsHelper.toString(arg.getName(), SOSArgumentHelper.getListStringArgumentValueAsString(arg));
    }

    public static String toString(String name, SOSArgument<?> arg) {
        return YADEArgumentsHelper.toString(name, arg.getDisplayValue());
    }

    public static String comparisonOperatorToString(SOSArgument<SOSComparisonOperator> arg) {
        return YADEArgumentsHelper.toString(arg.getName(), arg.getValue() == null ? null : ((SOSComparisonOperator)arg.getValue()).getFirstAlias());
    }

    public static String toStringAsOppositeValue(SOSArgument<Boolean> arg) {
        return YADEArgumentsHelper.toString("Disable" + arg.getName(), String.valueOf(!arg.isTrue()));
    }

    public static String toString(ISOSLogger logger, String label, ASOSArguments args) {
        if (args == null) {
            return "[" + label + "]null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(label).append("]");
        sb.append("[").append(args.getClass().getSimpleName()).append("]");
        boolean add = false;
        try {
            for (SOSArgument arg : args.getArguments()) {
                if (add) {
                    sb.append(", ");
                }
                sb.append(YADEArgumentsHelper.toString(arg));
                add = true;
            }
        }
        catch (Throwable e) {
            logger.warn((Object)(sb + e.toString()));
        }
        try {
            List included = args.getIncludedArgumentsIfNotNull();
            if (included != null) {
                for (ASOSArguments include : included) {
                    String name = include.getClass().getSimpleName();
                    sb.append(", ").append(YADEArgumentsHelper.toString(logger, name, include));
                }
            }
        }
        catch (Exception e) {
            sb.append(e.toString());
        }
        return sb.toString();
    }
}

