/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.commons.helpers;

import com.sos.commons.util.SOSDate;
import com.sos.commons.util.SOSShell;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.arguments.base.ASOSArguments;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.vfs.commons.AProviderArguments;
import com.sos.commons.vfs.commons.file.ProviderFile;
import com.sos.commons.vfs.exceptions.ProviderInitializationException;
import com.sos.yade.commons.Yade;
import com.sos.yade.engine.addons.YADEEngineJumpHostAddon;
import com.sos.yade.engine.commons.YADEProviderFile;
import com.sos.yade.engine.commons.arguments.YADEArguments;
import com.sos.yade.engine.commons.arguments.YADEClientArguments;
import com.sos.yade.engine.commons.arguments.YADEJumpHostArguments;
import com.sos.yade.engine.commons.arguments.YADENotificationArguments;
import com.sos.yade.engine.commons.arguments.YADESourceArguments;
import com.sos.yade.engine.commons.arguments.YADETargetArguments;
import com.sos.yade.engine.commons.arguments.loaders.AYADEArgumentsLoader;
import com.sos.yade.engine.commons.delegators.YADESourceProviderDelegator;
import com.sos.yade.engine.commons.delegators.YADETargetProviderDelegator;
import com.sos.yade.engine.commons.helpers.YADEArgumentsHelper;
import com.sos.yade.engine.handlers.operations.copymove.file.commons.YADETargetProviderFile;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class YADEClientBannerWriter {
    public static final String SEPARATOR_LINE = "****************************************************************************************";
    private static final String NEW_LINE = "\n";
    private static final boolean STATE_TO_LOWERCASE = true;

    public static String formatState(Yade.TransferEntryState state) {
        if (state == null) {
            return "";
        }
        return YADEClientBannerWriter.formatState(state.name());
    }

    public static void writeHeader(ISOSLogger logger, AYADEArgumentsLoader argsLoader, boolean writeYADEBanner) {
        if (writeYADEBanner) {
            logger.info((Object)SEPARATOR_LINE);
            logger.info((Object)String.format("*    YADE    - %-72s%s", "Managed File Transfer (www.sos-berlin.com)", "*"));
            logger.info((Object)String.format("*    Version - %-72s%s", "2.8.1 (2025-09-26 6daa35b59c60e44e290bb0f756a4f5a5b8642a6b)", "*"));
            logger.info((Object)SEPARATOR_LINE);
        }
        YADEClientBannerWriter.writeTransferHeader(logger, argsLoader.getArgs());
        YADEClientBannerWriter.writeNotificationHeader(logger, argsLoader.getNotificationArgs());
        YADEClientBannerWriter.writeClientHeader(logger, argsLoader.getClientArgs());
        YADEClientBannerWriter.writeSourceHeader(logger, argsLoader.getSourceArgs());
        YADEClientBannerWriter.writeJumpHostHeader(logger, argsLoader.getJumpHostArgs());
        YADEClientBannerWriter.writeTargetHeader(logger, argsLoader.getTargetArgs());
        logger.info((Object)SEPARATOR_LINE);
    }

    public static void writeSummary(ISOSLogger logger, YADEArguments args, Duration operationDuration, YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator, YADEEngineJumpHostAddon jumpHostAddon, List<ProviderFile> files, Throwable error) {
        args.getEnd().setValue((Object)Instant.now());
        int totalFiles = files == null ? 0 : files.size();
        String summaryLineFilesSummary = null;
        StringBuilder detailsLines = new StringBuilder();
        if (totalFiles > 0 && !Yade.TransferOperation.GETLIST.equals(args.getOperation().getValue())) {
            ArrayList l = new ArrayList();
            if (logger.isDebugEnabled()) {
                for (ProviderFile f : files) {
                    logger.debug((Object)((YADEProviderFile)f));
                }
            }
            Map<String, List<YADEProviderFile>> groupedByState = FileStateUtils.getGroupedByState(targetDelegator, files, YADEClientBannerWriter.getDefaultState(args));
            boolean needsDetails = groupedByState.keySet().stream().anyMatch(k -> k.contains(YADEClientBannerWriter.formatState(Yade.TransferEntryState.ROLLED_BACK)) || k.contains(YADEClientBannerWriter.formatState(Yade.TransferEntryState.FAILED)));
            groupedByState.forEach((state, fileList) -> {
                l.add(YADEClientBannerWriter.formatState(state) + "=" + fileList.size());
                if (needsDetails) {
                    detailsLines.append(YADEClientBannerWriter.formatState(state) + ":").append(NEW_LINE);
                    for (YADEProviderFile file : fileList) {
                        detailsLines.append(YADEClientBannerWriter.formatFile(sourceDelegator, targetDelegator, file)).append(NEW_LINE);
                    }
                }
            });
            int size = l.size();
            if (size > 0) {
                summaryLineFilesSummary = size == 1 && ((String)l.get(0)).startsWith(YADEClientBannerWriter.formatState(YADEClientBannerWriter.getDefaultState(args))) ? "(" + YADEClientBannerWriter.formatState(Yade.TransferEntryState.SELECTED) + ")" : "(" + String.join((CharSequence)",", l) + ")";
            }
        }
        StringBuilder summaryLine = new StringBuilder();
        summaryLine.append("Files=").append(totalFiles);
        if (summaryLineFilesSummary != null) {
            summaryLine.append(summaryLineFilesSummary);
        }
        summaryLine.append(", Duration=").append(SOSDate.getDuration((Instant)((Instant)args.getStart().getValue()), (Instant)((Instant)args.getEnd().getValue())));
        if (operationDuration != null) {
            summaryLine.append("(Operation=").append(SOSDate.getDuration((Duration)operationDuration)).append(")");
        }
        logger.info((Object)SEPARATOR_LINE);
        logger.info((Object)("[Summary]" + summaryLine));
        if (detailsLines.length() > 0) {
            logger.info((Object)("[Details]" + detailsLines));
        }
        if (error != null) {
            logger.error((Object)("[Error]" + error.toString()));
        }
    }

    private static void writeTransferHeader(ISOSLogger logger, YADEArguments args) {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append("Transfer").append("]");
        sb.append(YADEArgumentsHelper.toString(args.getOperation()));
        sb.append(", ").append(YADEArgumentsHelper.toString(args.getTransactional()));
        if (args.isParallelismEnabled()) {
            sb.append(", ").append(YADEArgumentsHelper.toString("Parallelism", args.getParallelism()));
        }
        if (!args.getProfile().isEmpty()) {
            sb.append(", ").append(YADEArgumentsHelper.toString("Profile", args.getProfile()));
        }
        if (!args.getSettings().isEmpty()) {
            sb.append(", ").append(YADEArgumentsHelper.toString("Settings", args.getSettings()));
        }
        logger.info((Object)sb);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)YADEArgumentsHelper.toString(logger, "Transfer", args));
        }
    }

    private static void writeNotificationHeader(ISOSLogger logger, YADENotificationArguments args) {
        if (args == null) {
            return;
        }
        if (!args.isEnabled()) {
            if (args.isTriggerEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("[").append("Notification").append("]");
                sb.append("[ignored due to MailServer not defined");
                logger.info((Object)sb);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("[%s]%s", new Object[]{"Notification", SOSString.toString((Object)args)});
            }
            return;
        }
        ArrayList<String> triggers = new ArrayList<String>();
        if (args.getMailOnSuccess() != null) {
            triggers.add("OnSuccess");
        }
        if (args.getMailOnError() != null) {
            triggers.add("OnError");
        }
        if (args.getMailOnEmptyFiles() != null) {
            triggers.add("OnEmptyFiles");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[").append("Notification").append("]");
        sb.append("NotificationTriggers");
        sb.append("=").append(String.join((CharSequence)", ", triggers));
        logger.info((Object)sb);
        if (logger.isDebugEnabled()) {
            logger.debug("[%s]%s", new Object[]{"Notification", SOSString.toString((Object)args)});
        }
    }

    private static void writeClientHeader(ISOSLogger logger, YADEClientArguments clientArgs) {
        if (clientArgs == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)YADEClientBannerWriter.getLocalHostInfo());
            }
            return;
        }
        ArrayList<String> l = new ArrayList<String>();
        if (!clientArgs.getResultSetFile().isEmpty()) {
            l.add(YADEArgumentsHelper.toString(clientArgs.getResultSetFile()));
        }
        if (!clientArgs.getRaiseErrorIfResultSetIs().isEmpty()) {
            l.add(YADEArgumentsHelper.comparisonOperatorToString(clientArgs.getRaiseErrorIfResultSetIs()));
        }
        if (!clientArgs.getExpectedResultSetCount().isEmpty()) {
            l.add(YADEArgumentsHelper.toString(clientArgs.getExpectedResultSetCount()));
        }
        if (l.size() > 0) {
            logger.info((Object)("[Client]" + String.join((CharSequence)", ", l)));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)YADEClientBannerWriter.getLocalHostInfo());
            logger.debug((Object)YADEArgumentsHelper.toString(logger, "Client", clientArgs));
        }
    }

    private static void writeSourceHeader(ISOSLogger logger, YADESourceArguments sourceArgs) {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(sourceArgs.getLabel().isEmpty() ? "Source" : (String)sourceArgs.getLabel().getValue()).append("]");
        if (sourceArgs.getProvider() == null) {
            sb.append("Missing Provider");
            logger.info((Object)sb);
            return;
        }
        sb.append(YADEArgumentsHelper.toString("Protocol", sourceArgs.getProvider().getProtocol()));
        try {
            sb.append("(");
            sb.append(sourceArgs.getProvider().getAccessInfo());
            if (!SOSString.isEmpty((String)sourceArgs.getProvider().getAdvancedAccessInfo())) {
                sb.append(", ").append(sourceArgs.getProvider().getAdvancedAccessInfo());
            }
            sb.append(")");
        }
        catch (ProviderInitializationException e) {
            sb.append("[getAccessInfo]" + e);
            logger.error("[getAccessInfo]" + e, (Throwable)e);
        }
        if (sourceArgs.getDirectory().getValue() != null) {
            sb.append(", ").append(YADEArgumentsHelper.toString(sourceArgs.getDirectory()));
        }
        sb.append(", ").append(YADEArgumentsHelper.toString(sourceArgs.getRecursive()));
        if (sourceArgs.isSingleFilesSelection()) {
            if (sourceArgs.isFileListEnabled()) {
                sb.append(", ").append(YADEArgumentsHelper.toString(sourceArgs.getFileList()));
            } else if (sourceArgs.isFilePathEnabled()) {
                sb.append(", ").append(YADEArgumentsHelper.toString(sourceArgs.getFilePath().getName(), sourceArgs.getFilePathAsString()));
            }
        } else {
            sb.append(", ").append(YADEArgumentsHelper.toString(sourceArgs.getFileSpec()));
        }
        if (!sourceArgs.getExcludedDirectories().isEmpty()) {
            sb.append(", ").append(YADEArgumentsHelper.toString(sourceArgs.getExcludedDirectories()));
        }
        if (sourceArgs.getErrorOnNoFilesFound().isDirty()) {
            sb.append(", ").append(YADEArgumentsHelper.toStringAsOppositeValue(sourceArgs.getErrorOnNoFilesFound()));
        }
        if (!YADESourceArguments.ZeroByteTransfer.TRUE.equals(sourceArgs.getZeroByteTransfer().getValue())) {
            sb.append(", ").append(YADEArgumentsHelper.toString(sourceArgs.getZeroByteTransfer()));
        }
        if (!sourceArgs.getMaxFiles().isEmpty()) {
            sb.append(", ").append(YADEArgumentsHelper.toString(sourceArgs.getMaxFiles()));
        }
        if (!sourceArgs.getMaxFileSize().isEmpty()) {
            sb.append(", ").append(YADEArgumentsHelper.toString(sourceArgs.getMaxFileSize()));
        }
        if (!sourceArgs.getMinFileSize().isEmpty()) {
            sb.append(", ").append(YADEArgumentsHelper.toString(sourceArgs.getMinFileSize()));
        }
        if (sourceArgs.getPolling() != null) {
            if (sourceArgs.getPolling().getPollingServer().isTrue()) {
                sb.append(", ").append(YADEArgumentsHelper.toString(sourceArgs.getPolling().getPollingServer()));
            }
            if (!sourceArgs.getPolling().getPollingServerDuration().isEmpty()) {
                sb.append(", ").append(YADEArgumentsHelper.toString(sourceArgs.getPolling().getPollingServerDuration()));
            }
            if (sourceArgs.getPolling().getPollingServerPollForever().isTrue()) {
                sb.append(", ").append(YADEArgumentsHelper.toString(sourceArgs.getPolling().getPollingServerPollForever()));
            }
            if (sourceArgs.getPolling().getPollingWait4SourceFolder().isTrue()) {
                sb.append(", ").append(YADEArgumentsHelper.toString(sourceArgs.getPolling().getPollingWait4SourceFolder()));
            }
            if (sourceArgs.getPolling().getWaitingForLateComers().isTrue()) {
                sb.append(", ").append(YADEArgumentsHelper.toString(sourceArgs.getPolling().getWaitingForLateComers()));
            }
            if (!sourceArgs.getPolling().getPollInterval().isEmpty()) {
                sb.append(", ").append(YADEArgumentsHelper.toString(sourceArgs.getPolling().getPollInterval()));
            }
            if (!sourceArgs.getPolling().getPollMinFiles().isEmpty()) {
                sb.append(", ").append(YADEArgumentsHelper.toString(sourceArgs.getPolling().getPollMinFiles()));
            }
            if (!sourceArgs.getPolling().getPollTimeout().isEmpty()) {
                sb.append(", ").append(YADEArgumentsHelper.toString(sourceArgs.getPolling().getPollTimeout()));
            }
        }
        if (sourceArgs.isCheckSteadyStateEnabled()) {
            sb.append(", ").append(YADEArgumentsHelper.toString(sourceArgs.getCheckSteadyStateInterval()));
            sb.append(", ").append(YADEArgumentsHelper.toString(sourceArgs.getCheckSteadyCount()));
        }
        if (sourceArgs.isReplacementEnabled()) {
            sb.append(", ").append(YADEArgumentsHelper.toString(sourceArgs.getReplacing()));
            sb.append(", ").append(YADEArgumentsHelper.toString(sourceArgs.getReplacement()));
        }
        if (sourceArgs.getCheckIntegrityHash().isTrue()) {
            sb.append(", ").append(YADEArgumentsHelper.toString(sourceArgs.getCheckIntegrityHash()));
        }
        logger.info((Object)sb);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)YADEClientBannerWriter.getHostInfo("Source", sourceArgs.getProvider()));
            logger.debug((Object)YADEArgumentsHelper.toString(logger, "Source", (ASOSArguments)sourceArgs.getProvider()));
            logger.debug((Object)YADEArgumentsHelper.toString(logger, "Source", sourceArgs));
        }
    }

    private static void writeJumpHostHeader(ISOSLogger logger, YADEJumpHostArguments jumpHostArgs) {
        if (jumpHostArgs == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[ ").append("Jump").append(" ]");
        sb.append(YADEArgumentsHelper.toString("Protocol", jumpHostArgs.getProvider().getProtocol()));
        try {
            sb.append("(");
            sb.append(jumpHostArgs.getAccessInfo());
            if (!SOSString.isEmpty((String)jumpHostArgs.getAdvancedAccessInfo())) {
                sb.append(", ").append(jumpHostArgs.getAdvancedAccessInfo());
            }
            sb.append(")");
        }
        catch (ProviderInitializationException e) {
            sb.append("[getAccessInfo]" + e);
            logger.error("[getAccessInfo]" + e, (Throwable)e);
        }
        if (jumpHostArgs.getTempDirectoryParent().getValue() != null) {
            sb.append(", ").append(YADEArgumentsHelper.toString(jumpHostArgs.getTempDirectoryParent()));
        }
        sb.append(", ").append(YADEArgumentsHelper.toString(jumpHostArgs.getYADEClientCommand()));
        logger.info((Object)sb);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)YADEClientBannerWriter.getHostInfo("Jump", (AProviderArguments)jumpHostArgs.getProvider()));
            logger.debug((Object)YADEArgumentsHelper.toString(logger, "Jump", (ASOSArguments)jumpHostArgs.getProvider()));
            logger.debug((Object)YADEArgumentsHelper.toString(logger, "Jump", jumpHostArgs));
        }
    }

    private static void writeTargetHeader(ISOSLogger logger, YADETargetArguments targetArgs) {
        if (targetArgs == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(targetArgs.getLabel().isEmpty() ? "Target" : (String)targetArgs.getLabel().getValue()).append("]");
        sb.append(YADEArgumentsHelper.toString("Protocol", targetArgs.getProvider().getProtocol()));
        try {
            sb.append("(");
            sb.append(targetArgs.getProvider().getAccessInfo());
            if (!SOSString.isEmpty((String)targetArgs.getProvider().getAdvancedAccessInfo())) {
                sb.append(", ").append(targetArgs.getProvider().getAdvancedAccessInfo());
            }
            sb.append(")");
        }
        catch (ProviderInitializationException e) {
            sb.append("[getAccessInfo]" + e);
            logger.error("[getAccessInfo]" + e, (Throwable)e);
        }
        if (targetArgs.getDirectory().getValue() != null) {
            sb.append(", ").append(YADEArgumentsHelper.toString(targetArgs.getDirectory()));
        }
        if (targetArgs.getCreateDirectories().isDirty()) {
            sb.append(", ").append(YADEArgumentsHelper.toStringAsOppositeValue(targetArgs.getCreateDirectories()));
        }
        if (targetArgs.getCheckSize().isDirty()) {
            sb.append(", ").append(YADEArgumentsHelper.toString(targetArgs.getCheckSize()));
        }
        if (targetArgs.getOverwriteFiles().isDirty()) {
            sb.append(", ").append(YADEArgumentsHelper.toStringAsOppositeValue(targetArgs.getOverwriteFiles()));
        }
        if (targetArgs.getAppendFiles().isTrue()) {
            sb.append(", ").append(YADEArgumentsHelper.toString(targetArgs.getAppendFiles()));
        }
        if (!targetArgs.getAtomicPrefix().isEmpty()) {
            sb.append(", ").append(YADEArgumentsHelper.toString(targetArgs.getAtomicPrefix()));
        }
        if (!targetArgs.getAtomicSuffix().isEmpty()) {
            sb.append(", ").append(YADEArgumentsHelper.toString(targetArgs.getAtomicSuffix()));
        }
        if (targetArgs.isReplacementEnabled()) {
            sb.append(", ").append(YADEArgumentsHelper.toString(targetArgs.getReplacing()));
            sb.append(", ").append(YADEArgumentsHelper.toString(targetArgs.getReplacement()));
        }
        if (targetArgs.getKeepModificationDate().isTrue()) {
            sb.append(", ").append(YADEArgumentsHelper.toString(targetArgs.getKeepModificationDate()));
        }
        if (targetArgs.getCreateIntegrityHashFile().isTrue()) {
            sb.append(", ").append(YADEArgumentsHelper.toString(targetArgs.getCreateIntegrityHashFile()));
        }
        if (!targetArgs.getCumulativeFileName().isEmpty()) {
            sb.append(", ").append(YADEArgumentsHelper.toString(targetArgs.getCumulativeFileName()));
            sb.append(", ").append(YADEArgumentsHelper.toString(targetArgs.getCumulativeFileDelete()));
            sb.append(", ").append(YADEArgumentsHelper.toString(targetArgs.getCumulativeFileSeparator()));
        }
        logger.info((Object)sb);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)YADEClientBannerWriter.getHostInfo("Target", targetArgs.getProvider()));
            logger.debug((Object)YADEArgumentsHelper.toString(logger, "Target", (ASOSArguments)targetArgs.getProvider()));
            logger.debug((Object)YADEArgumentsHelper.toString(logger, "Target", targetArgs));
        }
    }

    private static String getLocalHostInfo() {
        String localhost = SOSShell.getLocalHostNameOptional().orElse("unknown");
        return YADEClientBannerWriter.getHostInfo("Client", localhost, SOSShell.getHostAddressQuietly((String)localhost));
    }

    private static String getHostInfo(String label, AProviderArguments args) {
        return YADEClientBannerWriter.getHostInfo(label, (String)args.getHost().getValue(), SOSShell.getHostAddressQuietly((String)((String)args.getHost().getValue())));
    }

    private static String getHostInfo(String label, String host, String ip) {
        return "[" + label + "][Host]" + host + ", IP=" + ip;
    }

    private static String formatState(String state) {
        return state.toLowerCase();
    }

    private static String formatFile(YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator, YADEProviderFile file) {
        StringBuilder sb = new StringBuilder();
        sb.append(" [").append(sourceDelegator.getLabel()).append("]");
        sb.append(YADEClientBannerWriter.formatFile(file));
        if (file.getTarget() != null) {
            sb.append(" [").append(targetDelegator.getLabel()).append("]");
            sb.append(YADEClientBannerWriter.formatFile(file.getTarget()));
        }
        return sb.toString();
    }

    private static String formatFile(YADEProviderFile file) {
        StringBuilder sb = new StringBuilder();
        if (file.getState() != null) {
            sb.append(YADEClientBannerWriter.formatState(file.getState()));
            if (file.getSubState() != null) {
                sb.append("(").append(YADEClientBannerWriter.formatState(file.getSubState())).append(")");
            }
            sb.append(", ");
        }
        sb.append(file.getFinalFullPath());
        return sb.toString();
    }

    private static Yade.TransferEntryState getDefaultState(YADEArguments args) {
        return Yade.TransferEntryState.UNKNOWN;
    }

    private class FileStateUtils {
        private FileStateUtils() {
        }

        private static Map<String, List<YADEProviderFile>> getGroupedByState(YADETargetProviderDelegator targetDelegator, List<ProviderFile> files, Yade.TransferEntryState defaultState) {
            return files.stream().map(f -> (YADEProviderFile)((Object)f)).collect(Collectors.groupingBy(f -> FileStateUtils.getState(f, defaultState)));
        }

        private static String getState(YADEProviderFile f, Yade.TransferEntryState defaultState) {
            if (f.getTarget() != null) {
                YADETargetProviderFile target = f.getTarget();
                return FileStateUtils.resolve(f.getTarget(), defaultState, !target.isNameReplaced());
            }
            return FileStateUtils.resolve(f, defaultState, false);
        }

        private static String resolve(YADEProviderFile f, Yade.TransferEntryState defaultState, boolean skipRenameSubStateForTarget) {
            String state = f.getState() == null ? YADEClientBannerWriter.formatState(defaultState) : YADEClientBannerWriter.formatState(f.getState());
            String subState = FileStateUtils.getSubState(f, skipRenameSubStateForTarget);
            return state + subState;
        }

        private static String getSubState(YADEProviderFile target, boolean skipRenameSubState) {
            if (target.getSubState() == null || skipRenameSubState && Yade.TransferEntryState.RENAMED.equals((Object)target.getSubState())) {
                return "";
            }
            return "(" + YADEClientBannerWriter.formatState(target.getSubState()) + ")";
        }
    }
}

