/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.commons.helpers;

import com.sos.commons.util.SOSCollection;
import com.sos.commons.util.SOSPath;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.vfs.commons.file.ProviderFile;
import com.sos.yade.commons.Yade;
import com.sos.yade.engine.commons.arguments.YADEClientArguments;
import com.sos.yade.engine.exceptions.YADEEngineException;
import java.io.BufferedReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class YADEClientHelper {
    private static String NEW_LINE = "\n";

    public static void setSystemPropertiesFromFiles(ISOSLogger logger, YADEClientArguments args) {
        if (args == null || SOSCollection.isEmpty((Collection)((Collection)args.getSystemPropertyFiles().getValue()))) {
            return;
        }
        String method = "setSystemPropertiesFromFiles";
        logger.info("[%s][files]", new Object[]{method, SOSString.join((Collection)((Collection)args.getSystemPropertyFiles().getValue()), (String)",", f -> f.toString())});
        Properties p = new Properties();
        for (Path file : (List)args.getSystemPropertyFiles().getValue()) {
            if (Files.exists(file, new LinkOption[0]) && Files.isRegularFile(file, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(file);){
                    p.load(reader);
                    logger.info("[%s][%s]loaded", new Object[]{method, file});
                }
                catch (Throwable e) {
                    logger.warn("[%s][%s][failed]%s", new Object[]{method, file, e.toString()});
                }
                continue;
            }
            logger.warn("[%s][%s]does not exist or is not a regular file", new Object[]{method, file});
        }
        for (String n : p.stringPropertyNames()) {
            String v = p.getProperty(n);
            if (logger.isDebugEnabled()) {
                logger.debug("[%s]%s=%s", new Object[]{method, n, v});
            }
            System.setProperty(n, v);
        }
    }

    public static void writeResultSet(ISOSLogger logger, Yade.TransferOperation operation, YADEClientArguments clientArgs, List<ProviderFile> sourceFiles) throws Exception {
        if (clientArgs.getResultSetFile().getValue() == null) {
            return;
        }
        Path file = SOSPath.toAbsoluteNormalizedPath((Path)((Path)clientArgs.getResultSetFile().getValue()));
        boolean logEntries = Yade.TransferOperation.GETLIST.equals((Object)operation);
        StringBuilder sb = new StringBuilder();
        if (SOSCollection.isEmpty(sourceFiles)) {
            if (logEntries) {
                logger.info("[%s][%s=%s]write a new line (because of 0 entries)", new Object[]{"Client", clientArgs.getResultSetFile().getName(), file});
            }
            sb.append(NEW_LINE);
        } else {
            if (logEntries) {
                logger.info("[%s][%s=%s]write %s entries:", new Object[]{"Client", clientArgs.getResultSetFile().getName(), file, sourceFiles.size()});
            }
            sourceFiles.stream().forEach(f -> {
                String entry = f.getFullPath();
                if (logEntries) {
                    logger.info((Object)entry);
                }
                sb.append(entry).append(NEW_LINE);
            });
        }
        try {
            SOSPath.overwrite((Path)file, (String)sb.toString());
        }
        catch (Throwable e) {
            throw new YADEEngineException("[writeResultSet][" + file + "]" + e, e);
        }
        if (!logEntries) {
            logger.info("[%s][%s=%s]%s entries written", new Object[]{"Client", clientArgs.getResultSetFile().getName(), file, sourceFiles.size()});
        }
    }

    public static void waitFor(long interval) {
        if (interval <= 0L) {
            return;
        }
        try {
            TimeUnit.SECONDS.sleep(interval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

